/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.exporters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import pt.unl.fct.di.novasys.babel.metrics.exporters.Exporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ThreadedExporter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.JSONFormatter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.NodeSampleFormatter;

public class TimedServerSocketExporter
extends ThreadedExporter {
    public static final String PORT = "PORT";
    public static final String TERMINATOR = "TERMINATOR";
    public static final String FORMATTER = "FORMATTER";
    NodeSampleFormatter formatter = TimedServerSocketExporter.getFormatterOrDefault(this.getProperty("FORMATTER"), new JSONFormatter());
    int sleepTime;

    public TimedServerSocketExporter(Builder exporterBuilder) {
        super(exporterBuilder);
    }

    private OutputStreamWriter waitForConnect() {
        OutputStreamWriter outputStreamWriter;
        ServerSocket serverSocket = new ServerSocket(Integer.parseInt(this.getProperty(PORT)));
        try {
            Socket s2 = serverSocket.accept();
            serverSocket.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(s2.getInputStream()));
            String line = in.readLine();
            int timesPerMinute = Integer.parseInt(line);
            this.sleepTime = 60000 / timesPerMinute;
            outputStreamWriter = new OutputStreamWriter(s2.getOutputStream());
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        serverSocket.close();
        return outputStreamWriter;
    }

    @Override
    public void run() {
        try {
            OutputStreamWriter out = this.waitForConnect();
            System.err.println("Connected to socket - 1st time");
            while (true) {
                Thread.sleep(this.sleepTime);
                if (this.isDisabled()) {
                    return;
                }
                try {
                    out.write(this.formatter.format(this.collectAllMetrics()));
                    out.write(this.getProperty(TERMINATOR));
                    out.flush();
                }
                catch (IOException e) {
                    System.err.println("Error connecting to socket, will try again");
                    out = this.waitForConnect();
                    System.err.println("Connected to socket");
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Properties loadDefaults() {
        Properties defaults = new Properties();
        defaults.setProperty(PORT, "9101");
        defaults.setProperty(TERMINATOR, "\n");
        defaults.setProperty(FORMATTER, "JSONFormatter");
        return defaults;
    }

    public static class Builder
    extends Exporter.ExporterBuilder<Builder> {
        Properties properties = new Properties();

        public Builder(String exporterName) {
            super(exporterName);
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder setPort(int port) {
            this.properties.setProperty(TimedServerSocketExporter.PORT, Integer.toString(port));
            return this;
        }

        public Builder setTerminator(String terminator) {
            this.properties.setProperty(TimedServerSocketExporter.TERMINATOR, terminator);
            return this;
        }

        public Builder setFormatter(NodeSampleFormatter formatter) {
            this.properties.setProperty(TimedServerSocketExporter.FORMATTER, formatter.getFormatterName());
            return this;
        }

        @Override
        public TimedServerSocketExporter build() {
            this.exporterConfigs(this.properties);
            return new TimedServerSocketExporter(this);
        }
    }
}

