/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.exporters;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Properties;
import pt.unl.fct.di.novasys.babel.metrics.exporters.Exporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ThreadedExporter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.JSONFormatter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.NodeSampleFormatter;

public class TimedSocketExporter
extends ThreadedExporter {
    public static final String HOST = "HOST";
    public static final String PORT = "PORT";
    public static final String TERMINATOR = "TERMINATOR";
    public static final String FORMATTER = "FORMATTER";
    public static final String INTERVAL = "INTERVAL";
    public static final long S_TO_MS = 1000L;
    NodeSampleFormatter formatter = TimedSocketExporter.getFormatterOrDefault(this.getProperty("FORMATTER"), new JSONFormatter());
    Socket socket = null;

    private TimedSocketExporter(Builder exporterBuilder) {
        super(exporterBuilder);
    }

    private boolean checkProperties(String ... properties) {
        for (String property : properties) {
            if (!this.getProperty(property).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Properties loadDefaults() {
        Properties defaults = new Properties();
        defaults.setProperty(INTERVAL, "10");
        defaults.setProperty(HOST, "");
        defaults.setProperty(PORT, "");
        defaults.setProperty(TERMINATOR, "\n");
        defaults.setProperty(FORMATTER, "JSONFormatter");
        return defaults;
    }

    private void connect(String ip, int port) {
        try {
            this.socket = new Socket(ip, port);
        }
        catch (IOException e) {
            System.err.println("Error connecting to socket, will try again");
        }
    }

    @Override
    public void run() {
        if (!this.checkProperties(HOST, PORT)) {
            throw new IllegalArgumentException("HOST and PORT must be set");
        }
        String ip = this.getProperty(HOST);
        int port = Integer.parseInt(this.getProperty(PORT));
        this.connect(ip, port);
        long sleep_ms = Math.round(Double.parseDouble(this.getProperty(INTERVAL)) * 1000.0);
        while (!this.isDisabled()) {
            try {
                OutputStreamWriter osw = new OutputStreamWriter(this.socket.getOutputStream());
                osw.write(this.formatter.format(this.collectAllMetrics()));
                osw.write(this.getProperty(TERMINATOR));
                osw.flush();
            }
            catch (IOException | NullPointerException e) {
                this.connect(ip, port);
            }
            try {
                Thread.sleep(sleep_ms);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return;
    }

    public static class Builder
    extends Exporter.ExporterBuilder<Builder> {
        Properties properties = new Properties();

        public Builder(String exporterName) {
            super(exporterName);
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder setHost(String host) {
            this.properties.setProperty(TimedSocketExporter.HOST, host);
            return this;
        }

        public Builder setPort(int port) {
            this.properties.setProperty(TimedSocketExporter.PORT, Integer.toString(port));
            return this;
        }

        public Builder setTerminator(String terminator) {
            this.properties.setProperty(TimedSocketExporter.TERMINATOR, terminator);
            return this;
        }

        public Builder setFormatter(NodeSampleFormatter formatter) {
            this.properties.setProperty(TimedSocketExporter.FORMATTER, formatter.getFormatterName());
            return this;
        }

        public Builder setInterval(double interval) {
            this.properties.setProperty(TimedSocketExporter.INTERVAL, Double.toString(interval));
            return this;
        }

        @Override
        public TimedSocketExporter build() {
            this.exporterConfigs(this.properties);
            return new TimedSocketExporter(this);
        }
    }
}

