/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.formatting;

import java.util.Map;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolSample;
import pt.unl.fct.di.novasys.babel.metrics.Sample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.NoSuchProtocolRegistry;
import pt.unl.fct.di.novasys.babel.metrics.formatting.NodeSampleFormatter;

public class PrometheusFormatter
implements NodeSampleFormatter {
    public static final String NAME = "PrometheusFormatter";
    private static final int SUM = 1;
    private static final int COUNT = 2;

    private StringBuilder formatSample(String metricName, String[] labelNames, long timestamp, Sample sample) {
        StringBuilder sb = new StringBuilder();
        if (labelNames.length > 0) {
            sb.append(metricName);
            sb.append("{");
            for (Map.Entry<String, String> entry : sample.getLabels().entrySet()) {
                sb.append(entry.getKey());
                sb.append("=");
                sb.append("\"");
                sb.append(entry.getValue());
                sb.append("\"");
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("}");
        } else {
            sb.append(metricName);
        }
        sb.append(" ");
        sb.append(sample.getValue());
        if (timestamp != -1L) {
            sb.append(" ");
            sb.append(timestamp);
        }
        return sb;
    }

    private StringBuilder formatMetricSample(short protocolID, MetricSample metricSample, long timestamp) {
        StringBuilder sb = new StringBuilder();
        StringBuilder nameSb = new StringBuilder();
        if (protocolID == -1) {
            nameSb.append("OS_");
        } else {
            nameSb.append("Protocol_");
            nameSb.append(protocolID);
            nameSb.append("_");
        }
        nameSb.append(metricSample.getMetricName());
        if (!metricSample.getMetricUnit().equals("")) {
            nameSb.append("_");
            nameSb.append(metricSample.getMetricUnit());
        } else if (metricSample.getMetricType() == Metric.MetricType.COUNTER && !metricSample.getMetricName().endsWith("_total")) {
            nameSb.append("_total");
        }
        String metricName = nameSb.toString();
        if (metricSample.hasDescription()) {
            sb.append("# HELP ");
            sb.append(metricName);
            sb.append(" ");
            sb.append(metricSample.getDescription());
            sb.append("\n");
        }
        sb.append("# TYPE ");
        sb.append((CharSequence)nameSb);
        sb.append(" ");
        sb.append(metricSample.getMetricType().getType());
        sb.append("\n");
        if (!metricSample.hasLabels()) {
            sb.append((CharSequence)nameSb);
            sb.append(" ");
            sb.append(metricSample.getSamples()[0].getValue());
            sb.append("\n");
            return sb;
        }
        switch (metricSample.getMetricType()) {
            case COUNTER: 
            case GAUGE: {
                for (int i = 0; i < metricSample.getNSamples(); ++i) {
                    sb.append((CharSequence)this.formatSample(metricName, metricSample.getLabelNames(), timestamp, metricSample.getSamples()[i]));
                    sb.append("\n");
                }
                break;
            }
            case HISTOGRAM: {
                int count_or_sum = 1;
                String[] labelNamesWithoutLe = new String[metricSample.getLabelNames().length - 1];
                System.arraycopy(metricSample.getLabelNames(), 0, labelNamesWithoutLe, 0, metricSample.getLabelNames().length - 1);
                for (int i = 0; i < metricSample.getNSamples(); ++i) {
                    Sample sample = metricSample.getSamples()[i];
                    String[] histogramLabelValues = sample.getLabelsValues();
                    String lastLabelValue = histogramLabelValues[histogramLabelValues.length - 1];
                    if (lastLabelValue.equals("sum") || lastLabelValue.equals("count")) {
                        if (count_or_sum == 1) {
                            sb.append((CharSequence)this.formatSample(metricName + "_sum", labelNamesWithoutLe, timestamp, sample));
                            count_or_sum = 2;
                        } else {
                            sb.append((CharSequence)this.formatSample(metricName + "_count", labelNamesWithoutLe, timestamp, sample));
                            count_or_sum = 1;
                        }
                        sb.append("\n");
                        continue;
                    }
                    sb.append((CharSequence)this.formatSample(metricName + "_bucket", metricSample.getLabelNames(), timestamp, sample));
                    sb.append("\n");
                }
                break;
            }
        }
        return sb;
    }

    @Override
    public String getFormatterName() {
        return NAME;
    }

    @Override
    public String format(NodeSample sample) throws NoSuchProtocolRegistry {
        StringBuilder sb = new StringBuilder();
        for (short protocolID : sample.getProtocols()) {
            ProtocolSample protocolSample = sample.getProtocolSample(protocolID);
            long timestamp = protocolSample.getTimestamp();
            for (MetricSample metricSample : protocolSample.getMetricSamples()) {
                if (metricSample.getMetricType() == Metric.MetricType.RECORD) continue;
                sb.append((CharSequence)this.formatMetricSample(protocolID, metricSample, timestamp));
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

