/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.generic.os;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.OSMetric;
import pt.unl.fct.di.novasys.babel.metrics.Sample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.NoProcfsException;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.OSMetricsConfigException;
import pt.unl.fct.di.novasys.babel.metrics.generic.os.CPUUsageRecord;
import pt.unl.fct.di.novasys.babel.metrics.generic.os.ProcessCPUUsageRecord;

public class OSMetrics {
    private static final Logger logger = LogManager.getLogger(OSMetrics.class);
    private static final String[] MEMORY_LABEL_NAMES = new String[]{"memory"};
    Map<MetricType, String> units;
    Map<MetricType, String> names;
    public static final int CLK_TCK = 100;
    public static final int BLKSIZE = 512;
    private static final String PROC = "/proc/";
    private static final String PROCSTAT = "/proc/stat";
    private static final String PROCMEMINFO = "/proc/meminfo";
    private static final String PROCUPTIME = "/proc/uptime";
    private static final String PROCLOADAVG = "/proc/loadavg";
    public int n_cpus;
    private final String pid;
    private ProcessCPUUsageRecord last_process_cpu_usage = new ProcessCPUUsageRecord();
    private CPUUsageRecord last_system_cpu_usage = new CPUUsageRecord();

    private Map<MetricType, String> getMetricUnits() {
        HashMap<MetricType, String> units = new HashMap<MetricType, String>();
        units.put(MetricType.SYSTEM_CPU_USAGE, "%");
        units.put(MetricType.SYSTEM_LOAD_AVERAGE, "");
        units.put(MetricType.SYSTEM_MEMORY_USAGE_PERCENTAGE, "%");
        units.put(MetricType.SYSTEM_MEMORY_USAGE, "Kbytes");
        units.put(MetricType.PROCESS_CPU_USAGE, "%");
        units.put(MetricType.PROCESS_MEMORY_USAGE_PERCENTAGE, "%");
        units.put(MetricType.PROCESS_MEMORY_USAGE, "Kbytes");
        units.put(MetricType.SYSTEM_DISK_WRITE_BYTES, "bytes");
        units.put(MetricType.SYSTEM_DISK_READ_BYTES, "bytes");
        units.put(MetricType.PROCESS_DISK_WRITE_BYTES, "bytes");
        units.put(MetricType.PROCESS_DISK_WRITE_NUM, "");
        units.put(MetricType.PROCESS_DISK_READ_BYTES, "bytes");
        units.put(MetricType.PROCESS_DISK_READ_NUM, "");
        units.put(MetricType.SYSTEM_NETWORK_WRITE_BYTES, "bytes");
        units.put(MetricType.SYSTEM_NETWORK_WRITE_PACKETS, "");
        units.put(MetricType.SYSTEM_NETWORK_READ_BYTES, "bytes");
        units.put(MetricType.SYSTEM_NETWORK_READ_PACKETS, "");
        return units;
    }

    private Map<MetricType, String> getMetricNames() {
        HashMap<MetricType, String> names = new HashMap<MetricType, String>();
        names.put(MetricType.SYSTEM_CPU_USAGE, "system_cpu_usage");
        names.put(MetricType.SYSTEM_LOAD_AVERAGE, "system_load_average");
        names.put(MetricType.SYSTEM_MEMORY_USAGE_PERCENTAGE, "system_memory_usage_percentage");
        names.put(MetricType.SYSTEM_MEMORY_USAGE, "system_memory_usage");
        names.put(MetricType.PROCESS_CPU_USAGE, "process_cpu_usage");
        names.put(MetricType.PROCESS_MEMORY_USAGE_PERCENTAGE, "process_memory_usage_percentage");
        names.put(MetricType.PROCESS_MEMORY_USAGE, "process_memory_usage");
        names.put(MetricType.SYSTEM_DISK_WRITE_BYTES, "system_disk_write_bytes");
        names.put(MetricType.SYSTEM_DISK_READ_BYTES, "system_disk_read_bytes");
        names.put(MetricType.PROCESS_DISK_WRITE_BYTES, "process_disk_write_bytes");
        names.put(MetricType.PROCESS_DISK_WRITE_NUM, "process_disk_write_num");
        names.put(MetricType.PROCESS_DISK_READ_BYTES, "process_disk_read_bytes");
        names.put(MetricType.PROCESS_DISK_READ_NUM, "process_disk_read_num");
        names.put(MetricType.SYSTEM_NETWORK_WRITE_BYTES, "system_network_write_bytes");
        names.put(MetricType.SYSTEM_NETWORK_WRITE_PACKETS, "system_network_write_packets");
        names.put(MetricType.SYSTEM_NETWORK_READ_BYTES, "system_network_read_bytes");
        names.put(MetricType.SYSTEM_NETWORK_READ_PACKETS, "system_network_read_packets");
        return names;
    }

    public OSMetric getOSMetric(MetricType mt, OSMetrics osm) {
        String unit = this.units.get((Object)mt);
        String name = this.names.get((Object)mt);
        final String[] networkLabelNames = new String[]{"interface"};
        String[] absoluteMemoryLabelNames = new String[]{"total_memory"};
        switch (mt.ordinal()) {
            case 0: {
                return new OSMetric(this, name, unit, Metric.MetricType.GAUGE, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().systemCPUUsage()));
                    }
                };
            }
            case 1: {
                return new OSMetric(this, name, unit, Metric.MetricType.GAUGE, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().getSystemLoadAverage_Minute()));
                    }
                };
            }
            case 2: {
                return new OSMetric(this, name, unit, Metric.MetricType.GAUGE, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().getSystemUsedMemoryPercentage()));
                    }
                };
            }
            case 3: {
                return new OSMetric(name, unit, Metric.MetricType.GAUGE, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        Sample[] samples = OSMetrics.this.getMemorySample(OSMetrics.this.getSystemMemoryAbsolute());
                        return this.sampleBuilder().labelNames(MEMORY_LABEL_NAMES).build(samples);
                    }
                };
            }
            case 8: {
                return new OSMetric(this, name, unit, Metric.MetricType.COUNTER, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().getSystemDiskReadBytes()));
                    }
                };
            }
            case 7: {
                return new OSMetric(this, name, unit, Metric.MetricType.COUNTER, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().getSystemDiskWriteBytes()));
                    }
                };
            }
            case 13: {
                return new OSMetric(this, name, unit, Metric.MetricType.COUNTER, osm, mt){
                    final Map<String, Long> values;
                    {
                        super(name, unit, mt, osm, osmt);
                        this.values = this.getOsMetrics().getSystemNetworkWriteBytes();
                    }

                    @Override
                    protected MetricSample collectMetric() {
                        Sample[] samples = new Sample[this.values.size()];
                        int i = 0;
                        for (Map.Entry<String, Long> entry : this.values.entrySet()) {
                            samples[i++] = new Sample(entry.getValue().doubleValue(), networkLabelNames, new String[]{entry.getKey()});
                        }
                        return this.sampleBuilder().labelNames(networkLabelNames).build(samples);
                    }
                };
            }
            case 14: {
                return new OSMetric(this, name, unit, Metric.MetricType.COUNTER, osm, mt){
                    final Map<String, Long> values;
                    {
                        super(name, unit, mt, osm, osmt);
                        this.values = this.getOsMetrics().getSystemNetworkWritePackets();
                    }

                    @Override
                    protected MetricSample collectMetric() {
                        Sample[] samples = new Sample[this.values.size()];
                        int i = 0;
                        for (Map.Entry<String, Long> entry : this.values.entrySet()) {
                            samples[i++] = new Sample(entry.getValue().doubleValue(), networkLabelNames, new String[]{entry.getKey()});
                        }
                        return this.sampleBuilder().labelNames(networkLabelNames).build(samples);
                    }
                };
            }
            case 15: {
                return new OSMetric(this, name, unit, Metric.MetricType.COUNTER, osm, mt){
                    final Map<String, Long> values;
                    {
                        super(name, unit, mt, osm, osmt);
                        this.values = this.getOsMetrics().getSystemNetworkReadBytes();
                    }

                    @Override
                    protected MetricSample collectMetric() {
                        Sample[] samples = new Sample[this.values.size()];
                        int i = 0;
                        for (Map.Entry<String, Long> entry : this.values.entrySet()) {
                            samples[i++] = new Sample(entry.getValue().doubleValue(), networkLabelNames, new String[]{entry.getKey()});
                        }
                        return this.sampleBuilder().labelNames(networkLabelNames).build(samples);
                    }
                };
            }
            case 16: {
                return new OSMetric(this, name, unit, Metric.MetricType.COUNTER, osm, mt){
                    final Map<String, Long> values;
                    {
                        super(name, unit, mt, osm, osmt);
                        this.values = this.getOsMetrics().getSystemNetworkReadPackets();
                    }

                    @Override
                    protected MetricSample collectMetric() {
                        Sample[] samples = new Sample[this.values.size()];
                        int i = 0;
                        for (Map.Entry<String, Long> entry : this.values.entrySet()) {
                            samples[i++] = new Sample(entry.getValue().doubleValue(), networkLabelNames, new String[]{entry.getKey()});
                        }
                        return this.sampleBuilder().labelNames(networkLabelNames).build(samples);
                    }
                };
            }
            case 4: {
                return new OSMetric(this, name, unit, Metric.MetricType.GAUGE, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().processCPUUsage()));
                    }
                };
            }
            case 5: {
                return new OSMetric(this, name, unit, Metric.MetricType.GAUGE, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().getProcessMemoryUsagePercentage()));
                    }
                };
            }
            case 6: {
                return new OSMetric(name, unit, Metric.MetricType.GAUGE, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        Sample[] samples = OSMetrics.this.getMemorySample(OSMetrics.this.getProcessMemoryUsage());
                        return this.sampleBuilder().labelNames(MEMORY_LABEL_NAMES).build(samples);
                    }
                };
            }
            case 11: {
                return new OSMetric(this, name, unit, Metric.MetricType.COUNTER, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().getProcessDiskReadBytes()));
                    }
                };
            }
            case 12: {
                return new OSMetric(this, name, unit, Metric.MetricType.COUNTER, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().getProcessDiskReadNum()));
                    }
                };
            }
            case 9: {
                return new OSMetric(this, name, unit, Metric.MetricType.COUNTER, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().getProcessDiskWriteBytes()));
                    }
                };
            }
            case 10: {
                return new OSMetric(this, name, unit, Metric.MetricType.COUNTER, osm, mt){

                    @Override
                    protected MetricSample collectMetric() {
                        return this.sampleBuilder().build(new Sample(this.getOsMetrics().getProcessDiskWriteNum()));
                    }
                };
            }
        }
        return null;
    }

    public OSMetrics() throws NoProcfsException, OSMetricsConfigException {
        this.n_cpus = this.getNumCPUs();
        File f = new File(PROC);
        if (!f.exists() || !f.isDirectory()) {
            throw new NoProcfsException("No /proc directory found");
        }
        try {
            this.pid = new File("/proc/self").getCanonicalFile().getName();
        }
        catch (IOException e) {
            throw new NoProcfsException("No /proc/self directory found");
        }
        this.units = this.getMetricUnits();
        this.names = this.getMetricNames();
        if (this.units.size() != MetricType.values().length || this.names.size() != MetricType.values().length) {
            throw new OSMetricsConfigException("MetricType enum and units/names map are not in sync");
        }
    }

    public Set<MetricType> getMetricsFromCategories(MetricCategory[] categoriesToCollect) {
        HashSet<MetricType> metricsToCollect = new HashSet<MetricType>();
        block8: for (MetricCategory category : categoriesToCollect) {
            switch (category.ordinal()) {
                case 0: {
                    ArrayList<MetricType> system_collection = new ArrayList<MetricType>();
                    system_collection.add(MetricType.SYSTEM_CPU_USAGE);
                    system_collection.add(MetricType.SYSTEM_LOAD_AVERAGE);
                    system_collection.add(MetricType.SYSTEM_MEMORY_USAGE_PERCENTAGE);
                    system_collection.add(MetricType.SYSTEM_MEMORY_USAGE);
                    system_collection.add(MetricType.SYSTEM_DISK_WRITE_BYTES);
                    system_collection.add(MetricType.SYSTEM_DISK_READ_BYTES);
                    system_collection.add(MetricType.SYSTEM_NETWORK_WRITE_BYTES);
                    system_collection.add(MetricType.SYSTEM_NETWORK_WRITE_PACKETS);
                    system_collection.add(MetricType.SYSTEM_NETWORK_READ_BYTES);
                    system_collection.add(MetricType.SYSTEM_NETWORK_READ_PACKETS);
                    metricsToCollect.addAll(system_collection);
                    continue block8;
                }
                case 1: {
                    ArrayList<MetricType> process_collection = new ArrayList<MetricType>();
                    process_collection.add(MetricType.PROCESS_CPU_USAGE);
                    process_collection.add(MetricType.PROCESS_MEMORY_USAGE_PERCENTAGE);
                    process_collection.add(MetricType.PROCESS_MEMORY_USAGE);
                    process_collection.add(MetricType.PROCESS_DISK_WRITE_BYTES);
                    process_collection.add(MetricType.PROCESS_DISK_WRITE_NUM);
                    process_collection.add(MetricType.PROCESS_DISK_READ_BYTES);
                    process_collection.add(MetricType.PROCESS_DISK_READ_NUM);
                    metricsToCollect.addAll(process_collection);
                    continue block8;
                }
                case 2: {
                    ArrayList<MetricType> disk_collection = new ArrayList<MetricType>();
                    disk_collection.add(MetricType.SYSTEM_DISK_WRITE_BYTES);
                    disk_collection.add(MetricType.SYSTEM_DISK_READ_BYTES);
                    disk_collection.add(MetricType.PROCESS_DISK_WRITE_BYTES);
                    disk_collection.add(MetricType.PROCESS_DISK_WRITE_NUM);
                    disk_collection.add(MetricType.PROCESS_DISK_READ_BYTES);
                    disk_collection.add(MetricType.PROCESS_DISK_READ_NUM);
                    metricsToCollect.addAll(disk_collection);
                    continue block8;
                }
                case 3: {
                    ArrayList<MetricType> cpu_collection = new ArrayList<MetricType>();
                    cpu_collection.add(MetricType.SYSTEM_CPU_USAGE);
                    cpu_collection.add(MetricType.PROCESS_CPU_USAGE);
                    metricsToCollect.addAll(cpu_collection);
                    continue block8;
                }
                case 4: {
                    ArrayList<MetricType> memory_collection = new ArrayList<MetricType>();
                    memory_collection.add(MetricType.SYSTEM_MEMORY_USAGE_PERCENTAGE);
                    memory_collection.add(MetricType.PROCESS_MEMORY_USAGE_PERCENTAGE);
                    memory_collection.add(MetricType.SYSTEM_MEMORY_USAGE);
                    memory_collection.add(MetricType.PROCESS_MEMORY_USAGE);
                    metricsToCollect.addAll(memory_collection);
                    continue block8;
                }
                case 5: {
                    ArrayList<MetricType> network_collection = new ArrayList<MetricType>();
                    network_collection.add(MetricType.SYSTEM_NETWORK_WRITE_BYTES);
                    network_collection.add(MetricType.SYSTEM_NETWORK_WRITE_PACKETS);
                    network_collection.add(MetricType.SYSTEM_NETWORK_READ_BYTES);
                    network_collection.add(MetricType.SYSTEM_NETWORK_READ_PACKETS);
                    metricsToCollect.addAll(network_collection);
                }
            }
        }
        return metricsToCollect;
    }

    private int getNumCPUs() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(PROCSTAT));
            int n_cpus = 0;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("cpu")) continue;
                ++n_cpus;
            }
            reader.close();
            return n_cpus - 1;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return -1;
        }
    }

    public int getSystemUsedMemoryPercentage() {
        MemInfo memInfo = this.getSystemMemoryAbsolute();
        if (memInfo.memTotal == -1L || memInfo.memAvailable == -1L) {
            return -1;
        }
        return (int)((memInfo.memTotal - memInfo.memAvailable) * 100L / memInfo.memTotal);
    }

    public MemInfo getSystemMemoryAbsolute() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(PROCMEMINFO));
            String mem_total_str = reader.readLine().replace("MemTotal:", "").replace("kB", "").trim();
            long mem_total = Long.parseLong(mem_total_str);
            reader.readLine();
            long mem_available = Long.parseLong(reader.readLine().replace("MemAvailable:", "").replace("kB", "").trim());
            reader.close();
            return new MemInfo(mem_total, mem_available);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return new MemInfo(-1L, -1L);
        }
    }

    private long getSystemUptime() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(PROCUPTIME));
            String uptime = reader.readLine().split(" ")[0];
            reader.close();
            return (long)(Double.parseDouble(uptime) * 100.0);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return -1L;
        }
    }

    private long getProcessRunningTime(String pid) {
        try {
            long uptime_clock_ticks = this.getSystemUptime();
            if (uptime_clock_ticks == -1L) {
                return -1L;
            }
            BufferedReader reader = new BufferedReader(new FileReader(PROC + pid + "/stat"));
            String[] stat = reader.readLine().split(" ");
            long starttime = Long.parseLong(stat[21]);
            reader.close();
            return uptime_clock_ticks - starttime;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return -1L;
        }
    }

    public int getProcessMemoryUsagePercentage() {
        MemInfo processMemoryInfo = this.getProcessMemoryUsage();
        return (int)((processMemoryInfo.memTotal - processMemoryInfo.memAvailable) * 100L / processMemoryInfo.memTotal);
    }

    public MemInfo getProcessMemoryUsage() {
        return new MemInfo(Runtime.getRuntime().totalMemory() / 1000L, Runtime.getRuntime().freeMemory() / 1000L);
    }

    public int processCPUUsage() {
        long process_running_in_clk_ticks = this.getProcessRunningTime(this.pid);
        if (process_running_in_clk_ticks == -1L) {
            return -1;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(PROC + this.pid + "/stat"));
            String[] stat = reader.readLine().split(" ");
            long utime = Long.parseLong(stat[13]);
            long stime = Long.parseLong(stat[14]);
            reader.close();
            ProcessCPUUsageRecord current_process_cpu_usage = new ProcessCPUUsageRecord(utime + stime, process_running_in_clk_ticks);
            long delta_active_time = current_process_cpu_usage.getActive_time() - this.last_process_cpu_usage.getActive_time();
            long delta_elapsed_time = current_process_cpu_usage.getElapsed_time() - this.last_process_cpu_usage.getElapsed_time();
            int cpu_usage = (int)(delta_active_time * 100L / delta_elapsed_time);
            this.last_process_cpu_usage = current_process_cpu_usage;
            return cpu_usage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int processCPUUsageBounded() {
        int cpu_usage = this.processCPUUsage();
        if (cpu_usage == -1) {
            return -1;
        }
        return cpu_usage / this.n_cpus;
    }

    public int systemCPUUsage() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(PROCSTAT));
            String[] stat = reader.readLine().split(" ");
            reader.close();
            CPUUsageRecord current_system_cpu_usage = OSMetrics.getCpuUsageRecord(stat);
            long total_delta = current_system_cpu_usage.getTotal_time() - this.last_system_cpu_usage.getTotal_time();
            long idle_delta = current_system_cpu_usage.getIdle_time() - this.last_system_cpu_usage.getIdle_time();
            int cpu_usage = (int)((total_delta - idle_delta) * 100L / total_delta);
            this.last_system_cpu_usage = current_system_cpu_usage;
            return cpu_usage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static CPUUsageRecord getCpuUsageRecord(String[] stat) {
        long user_time = Long.parseLong(stat[2]);
        long nice_time = Long.parseLong(stat[3]);
        long system_time = Long.parseLong(stat[4]);
        long idle_time = Long.parseLong(stat[5]);
        long iowait_time = Long.parseLong(stat[6]);
        long irq_time = Long.parseLong(stat[7]);
        long softirq_time = Long.parseLong(stat[8]);
        long steal_time = Long.parseLong(stat[9]);
        long guest_time = Long.parseLong(stat[10]);
        long guest_nice_time = Long.parseLong(stat[11]);
        long idlealltime = idle_time + iowait_time;
        long systemalltime = system_time + irq_time + softirq_time;
        long virtalltime = guest_time + guest_nice_time;
        long totaltime = (user_time -= guest_time) + (nice_time -= guest_nice_time) + systemalltime + idlealltime + steal_time + virtalltime;
        return new CPUUsageRecord(totaltime, idlealltime);
    }

    public double getSystemLoadAverage_Minute() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(PROCLOADAVG));
            String[] loadavg = reader.readLine().split(" ");
            reader.close();
            return Double.parseDouble(loadavg[0]);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return -1.0;
        }
    }

    public int getSystemLoadAverage_Minute_Percentage() {
        double load_avg = this.getSystemLoadAverage_Minute();
        if (load_avg == -1.0) {
            return -1;
        }
        return (int)(load_avg / (double)this.n_cpus * 100.0);
    }

    public long getSystemDiskWriteBytes() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/diskstats"));
            long write_sectors = 0L;
            while ((line = reader.readLine()) != null) {
                if (!line.matches("nvme0n\\d\\s") && !line.matches("sda\\s")) continue;
                String[] split = line.split(" ");
                write_sectors = Long.parseLong(split[9]);
            }
            reader.close();
            return write_sectors * 512L;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return -1L;
        }
    }

    public long getSystemDiskReadBytes() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/diskstats"));
            long read_sectors = 0L;
            while ((line = reader.readLine()) != null) {
                if (!line.matches("nvme0n\\d\\s") && !line.matches("sda\\s")) continue;
                String[] split = line.split(" ");
                read_sectors = Long.parseLong(split[5]);
            }
            reader.close();
            return read_sectors * 512L;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return -1L;
        }
    }

    public Map<String, Long> getSystemNetworkWriteBytes() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/net/dev"));
            HashMap<String, Long> write_bytes = new HashMap<String, Long>();
            while ((line = reader.readLine()) != null) {
                if (!line.matches("(.*?):(.*?)") || line.trim().startsWith("lo:")) continue;
                String[] split = line.split(":");
                String iface = split[0].trim();
                String[] stats = split[1].trim().split("(\\s)+");
                long bytes = Long.parseLong(stats[0]);
                if (bytes <= 0L) continue;
                write_bytes.put(iface, bytes);
            }
            return write_bytes;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public Map<String, Long> getSystemNetworkWritePackets() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/net/dev"));
            HashMap<String, Long> write_packets = new HashMap<String, Long>();
            while ((line = reader.readLine()) != null) {
                if (!line.matches("(.*?):(.*?)") || line.trim().startsWith("lo:")) continue;
                String[] split = line.split(":");
                String iface = split[0].trim();
                String[] stats = split[1].trim().split("(\\s)+");
                long packets = Long.parseLong(stats[1]);
                if (packets <= 0L) continue;
                write_packets.put(iface, packets);
            }
            return write_packets;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public Map<String, Long> getSystemNetworkReadBytes() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/net/dev"));
            HashMap<String, Long> read_bytes = new HashMap<String, Long>();
            while ((line = reader.readLine()) != null) {
                if (!line.matches("(.*?):(.*?)") || line.trim().startsWith("lo:")) continue;
                String[] split = line.split(":");
                String iface = split[0].trim();
                String[] stats = split[1].trim().split("(\\s)+");
                long bytes = Long.parseLong(stats[8]);
                if (bytes <= 0L) continue;
                read_bytes.put(iface, bytes);
            }
            return read_bytes;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public Map<String, Long> getSystemNetworkReadPackets() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/net/dev"));
            HashMap<String, Long> read_packets = new HashMap<String, Long>();
            while ((line = reader.readLine()) != null) {
                if (!line.matches("(.*?):(.*?)") || line.trim().startsWith("lo:")) continue;
                String[] split = line.split(":");
                String iface = split[0].trim();
                String[] stats = split[1].trim().split("(\\s)+");
                long packets = Long.parseLong(stats[9]);
                if (packets <= 0L) continue;
                read_packets.put(iface, packets);
            }
            return read_packets;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public long getProcessDiskWriteBytes() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(PROC + this.pid + "/io"));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("write_bytes:")) continue;
                return Long.parseLong(line.split(" ")[1]);
            }
            reader.close();
            return -1L;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return -1L;
        }
    }

    public long getProcessDiskWriteNum() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(PROC + this.pid + "/io"));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("syscw:")) continue;
                return Long.parseLong(line.split(" ")[1]);
            }
            reader.close();
            return -1L;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return -1L;
        }
    }

    public long getProcessDiskReadBytes() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(PROC + this.pid + "/io"));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("read_bytes:")) continue;
                return Long.parseLong(line.split(" ")[1]);
            }
            reader.close();
            return -1L;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return -1L;
        }
    }

    public long getProcessDiskReadNum() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(PROC + this.pid + "/io"));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("syscr:")) continue;
                return Long.parseLong(line.split(" ")[1]);
            }
            reader.close();
            return -1L;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return -1L;
        }
    }

    public Sample[] getMemorySample(MemInfo memInfo) {
        Sample[] samples = new Sample[]{new Sample(memInfo.memTotal, MEMORY_LABEL_NAMES, new String[]{"total"}), new Sample(memInfo.memAvailable, MEMORY_LABEL_NAMES, new String[]{"available"})};
        return samples;
    }

    public static enum MetricType {
        SYSTEM_CPU_USAGE,
        SYSTEM_LOAD_AVERAGE,
        SYSTEM_MEMORY_USAGE_PERCENTAGE,
        SYSTEM_MEMORY_USAGE,
        PROCESS_CPU_USAGE,
        PROCESS_MEMORY_USAGE_PERCENTAGE,
        PROCESS_MEMORY_USAGE,
        SYSTEM_DISK_WRITE_BYTES,
        SYSTEM_DISK_READ_BYTES,
        PROCESS_DISK_WRITE_BYTES,
        PROCESS_DISK_WRITE_NUM,
        PROCESS_DISK_READ_BYTES,
        PROCESS_DISK_READ_NUM,
        SYSTEM_NETWORK_WRITE_BYTES,
        SYSTEM_NETWORK_WRITE_PACKETS,
        SYSTEM_NETWORK_READ_BYTES,
        SYSTEM_NETWORK_READ_PACKETS;

    }

    public static enum MetricCategory {
        SYSTEM,
        PROCESS,
        DISK,
        CPU,
        MEMORY,
        NETWORK;

    }

    public static class MemInfo {
        public long memTotal;
        public long memAvailable;

        public MemInfo(long memTotal, long memAvailable) {
            this.memTotal = memTotal;
            this.memAvailable = memAvailable;
        }
    }
}

