/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.monitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolSample;
import pt.unl.fct.di.novasys.babel.metrics.monitor.Aggregation;
import pt.unl.fct.di.novasys.babel.metrics.monitor.AggregationInput;
import pt.unl.fct.di.novasys.babel.metrics.monitor.AggregationResult;
import pt.unl.fct.di.novasys.babel.metrics.monitor.HostProtocolIdentifier;
import pt.unl.fct.di.novasys.babel.metrics.monitor.MetricIdentifier;

public class AggregationManager {
    private static final Logger logger = LogManager.getLogger(AggregationManager.class);
    private final Map<MetricIdentifier, Map<String, MetricSample>> samples = new ConcurrentHashMap<MetricIdentifier, Map<String, MetricSample>>();
    private final List<Aggregation> aggregationsToPerform = new LinkedList<Aggregation>();
    private final Set<MetricIdentifier> metricsNotAggregated = new HashSet<MetricIdentifier>();
    private final Set<MetricIdentifier> metricsBelongingToAggregation = new HashSet<MetricIdentifier>();
    private final Map<Short, String> protocolIdsToNames = new ConcurrentHashMap<Short, String>();

    public Map<MetricIdentifier, Map<String, MetricSample>> getSamples() {
        return this.samples;
    }

    public List<Aggregation> getAggregationsToPerform() {
        return this.aggregationsToPerform;
    }

    public Set<MetricIdentifier> getMetricsNotAggregated() {
        return this.metricsNotAggregated;
    }

    public synchronized void addSample(String host, NodeSample sample) {
        for (Map.Entry<Short, ProtocolSample> entry : sample.getSamplesPerProtocol().entrySet()) {
            this.protocolIdsToNames.put(entry.getKey(), entry.getValue().getProtocolName());
            for (MetricSample metricEntry : entry.getValue().getMetricSamples()) {
                MetricIdentifier identifier = new MetricIdentifier(metricEntry.getMetricName(), entry.getKey());
                if (!this.metricsBelongingToAggregation.contains(identifier)) {
                    this.metricsNotAggregated.add(identifier);
                }
                if (!this.samples.containsKey(identifier)) {
                    this.samples.put(identifier, new HashMap());
                }
                this.samples.get(identifier).put(host, metricEntry);
            }
        }
    }

    public synchronized void addAggregation(Aggregation aggregation) {
        this.aggregationsToPerform.add(aggregation);
        for (MetricIdentifier mi : aggregation.getMetricIdentifiers()) {
            this.metricsBelongingToAggregation.add(mi);
            this.metricsNotAggregated.remove(mi);
        }
    }

    public Map<String, NodeSample> performAggregations() {
        return this.performAggregations(System.currentTimeMillis());
    }

    public synchronized Map<String, NodeSample> performAggregations(long timestamp) {
        LinkedList<Thread> threads = new LinkedList<Thread>();
        Object lock = new Object();
        HashMap<String, NodeSample> resultSamples = new HashMap<String, NodeSample>();
        if (timestamp <= 0L) {
            throw new IllegalArgumentException("Timestamp must be a positive value");
        }
        if (this.samples.isEmpty()) {
            logger.warn("No samples to aggregate, returning empty result");
            return resultSamples;
        }
        LinkedList<AggregationResult> results = new LinkedList<AggregationResult>();
        for (Aggregation aggregation : this.aggregationsToPerform) {
            Thread t2 = new Thread(() -> {
                AggregationInput ai = new AggregationInput();
                AggregationResult ar = new AggregationResult(timestamp, this.protocolIdsToNames);
                for (MetricIdentifier mi : aggregation.getMetricIdentifiers()) {
                    Map<String, MetricSample> metricSamples = this.samples.get(mi);
                    if (metricSamples == null || metricSamples.isEmpty()) {
                        logger.warn("Aggregation {} was not performed because metric {} was not present in the samples", (Object)aggregation.getClass().getName(), (Object)mi);
                        return;
                    }
                    if (metricSamples.size() == 1) {
                        logger.warn("Aggregation {} was not performed because metric {} was only present for one host", (Object)aggregation.getClass().getName(), (Object)mi);
                    }
                    for (Map.Entry<String, MetricSample> entry : this.samples.get(mi).entrySet()) {
                        ai.addMetricSample(entry.getKey(), mi, entry.getValue());
                    }
                }
                AggregationResult result = aggregation.aggregate(ai, ar);
                Object object = lock;
                synchronized (object) {
                    if (result != null) {
                        results.add(result);
                    }
                }
            });
            threads.add(t2);
            t2.start();
        }
        for (Thread t3 : threads) {
            try {
                t3.join();
            }
            catch (InterruptedException t2) {}
        }
        AggregationResult ar = new AggregationResult(timestamp, this.protocolIdsToNames);
        for (MetricIdentifier mi : this.metricsNotAggregated) {
            for (Map.Entry<String, MetricSample> entry : this.samples.get(mi).entrySet()) {
                ar.addSample(entry.getValue(), mi.getProtocolId(), entry.getKey());
            }
        }
        results.add(ar);
        for (AggregationResult result : results) {
            for (Map.Entry<Object, Object> entry : result.getAggregatedSamples().entrySet()) {
                if (!resultSamples.containsKey(((HostProtocolIdentifier)entry.getKey()).getHost())) {
                    resultSamples.put(((HostProtocolIdentifier)entry.getKey()).getHost(), new NodeSample());
                }
                short protoID = ((HostProtocolIdentifier)entry.getKey()).getProtocolId();
                if (!((NodeSample)resultSamples.get(((HostProtocolIdentifier)entry.getKey()).getHost())).getProtocols().contains(protoID)) {
                    ProtocolSample es = new ProtocolSample(protoID, this.protocolIdsToNames.get(protoID), (List)entry.getValue());
                    ((NodeSample)resultSamples.get(((HostProtocolIdentifier)entry.getKey()).getHost())).addProtocolSample(protoID, es);
                    continue;
                }
                for (MetricSample metricSample : (List)entry.getValue()) {
                    ((NodeSample)resultSamples.get(((HostProtocolIdentifier)entry.getKey()).getHost())).getProtocolSample(protoID).addMetricSample(metricSample);
                }
            }
        }
        this.samples.clear();
        return resultSamples;
    }
}

