/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.monitor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolMetrics;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolSample;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ProtocolCollectOptions;
import pt.unl.fct.di.novasys.babel.metrics.monitor.HostProtocolIdentifier;

public class AggregationResult {
    private Map<HostProtocolIdentifier, List<MetricSample>> samplesPerNode = new HashMap<HostProtocolIdentifier, List<MetricSample>>();
    private long timestamp;
    private Map<Short, String> protoIdToName;

    public AggregationResult(long timestamp, Map<Short, String> protoIdToName) {
        this.timestamp = timestamp;
        this.protoIdToName = protoIdToName;
    }

    public void addMetricToSample(Metric m4, short protocolId, String host) {
        String protocolName = this.protoIdToName.get(protocolId);
        if (protocolName == null) {
            protocolName = "";
        }
        ProtocolMetrics protocolMetrics = new ProtocolMetrics(protocolId, protocolName);
        protocolMetrics.register(m4);
        ProtocolSample es = protocolMetrics.collect(new ProtocolCollectOptions());
        this.addSample(es.getMetricSample(m4.getName()), protocolId, host);
    }

    public void addGlobalMetricToSample(Metric m4, short protocolID) {
        this.addMetricToSample(m4, protocolID, "GLOBAL");
    }

    public void addSample(MetricSample ms, short protocolID, String host) {
        HostProtocolIdentifier npi = new HostProtocolIdentifier(host, protocolID);
        if (!this.samplesPerNode.containsKey(npi)) {
            this.samplesPerNode.put(npi, new LinkedList());
        }
        this.samplesPerNode.get(npi).add(ms);
    }

    public void addGlobalSample(MetricSample ms, short protocolID) {
        this.addSample(ms, protocolID, "GLOBAL");
    }

    public Map<HostProtocolIdentifier, List<MetricSample>> getAggregatedSamples() {
        return this.samplesPerNode;
    }
}

