/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.monitor.aggregation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.Sample;
import pt.unl.fct.di.novasys.babel.metrics.monitor.Aggregation;
import pt.unl.fct.di.novasys.babel.metrics.monitor.AggregationInput;
import pt.unl.fct.di.novasys.babel.metrics.monitor.AggregationResult;
import pt.unl.fct.di.novasys.babel.metrics.monitor.MetricIdentifier;

public class DefaultAggregation
extends Aggregation {
    private static final String DELIMITER = ";";

    public DefaultAggregation(short protocolId, String metricName) {
        super(protocolId, metricName);
    }

    private Map<String, Double> aggregateCounter(Iterator<MetricSample> samples) {
        HashMap<String, Double> resultSamples = new HashMap<String, Double>();
        while (samples.hasNext()) {
            MetricSample sample = samples.next();
            for (int i = 0; i < sample.getSamples().length; ++i) {
                String labelValuesWithPlusSeparator = String.join((CharSequence)DELIMITER, sample.getSamples()[i].getLabelsValues());
                double value = 0.0;
                if (resultSamples.containsKey(labelValuesWithPlusSeparator)) {
                    value = (Double)resultSamples.get(labelValuesWithPlusSeparator);
                }
                resultSamples.put(labelValuesWithPlusSeparator, value + sample.getSamples()[i].getValue());
            }
        }
        return resultSamples;
    }

    private Map<String, Double> aggregateGauge(Iterator<MetricSample> samples, int nHosts) {
        Map<String, Double> resultSamples = this.aggregateCounter(samples);
        for (Map.Entry<String, Double> entry : resultSamples.entrySet()) {
            entry.setValue(entry.getValue() / (double)nHosts);
        }
        return resultSamples;
    }

    private Map<String, Double> aggregateHistogram(Iterator<MetricSample> samples) {
        return this.aggregateCounter(samples);
    }

    private Map<String, Double> aggregateRecord(Iterator<MetricSample> samples) {
        return this.aggregateCounter(samples);
    }

    @Override
    public AggregationResult aggregate(AggregationInput aggregationInput, AggregationResult aggregationResult) {
        if (aggregationInput.getMetrics().size() != 1) {
            throw new IllegalArgumentException("DefaultAggregation can only aggregate one metric");
        }
        MetricIdentifier mid = aggregationInput.getMetrics().getFirst();
        List<MetricSample> metricSampleMap = aggregationInput.getSamples(mid.getProtocolId(), mid.getMetricName());
        if (metricSampleMap.isEmpty()) {
            return aggregationResult;
        }
        int nHosts = metricSampleMap.size();
        MetricSample sample = metricSampleMap.getFirst();
        String[] labelNames = sample.getLabelNames();
        Iterator<MetricSample> it = metricSampleMap.iterator();
        Map<String, Double> resultingSamples = switch (sample.getMetricType()) {
            case Metric.MetricType.COUNTER -> this.aggregateCounter(it);
            case Metric.MetricType.GAUGE -> this.aggregateGauge(it, nHosts);
            case Metric.MetricType.HISTOGRAM -> this.aggregateHistogram(it);
            case Metric.MetricType.RECORD -> this.aggregateRecord(it);
            default -> throw new IllegalArgumentException("Unknown metric type");
        };
        Sample[] samplesArray = new Sample[resultingSamples.size()];
        int i = 0;
        for (Map.Entry<String, Double> entry : resultingSamples.entrySet()) {
            String[] labels = entry.getKey().split(DELIMITER);
            samplesArray[i] = new Sample(entry.getValue(), labelNames, labels);
            ++i;
        }
        MetricSample resultingMetricSample = sample.hasLabels() ? MetricSample.builder(sample.getMetricUnit(), sample.getMetricName(), sample.getMetricType()).labelNames(labelNames).build(samplesArray) : MetricSample.builder(sample.getMetricUnit(), sample.getMetricName(), sample.getMetricType()).build(samplesArray[0]);
        aggregationResult.addGlobalSample(resultingMetricSample, mid.getProtocolId());
        return aggregationResult;
    }
}

