/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.monitor.datalayer;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.formatting.IdentifiedNodeSampleFormatter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.SimpleFormatter;
import pt.unl.fct.di.novasys.babel.metrics.monitor.datalayer.Storage;

public class LocalTextStorage
implements Storage {
    private final IdentifiedNodeSampleFormatter formatter;
    private final FileWriter writer;

    private LocalTextStorage(IdentifiedNodeSampleFormatter formatter, String path, boolean append) {
        this.formatter = formatter;
        try {
            this.writer = new FileWriter(path, append);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void store(String host, NodeSample nodeSample) {
        try {
            this.writer.write(this.formatter.format(host, nodeSample));
            this.writer.write(System.lineSeparator());
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void store(Map<String, NodeSample> samples) {
        try {
            this.writer.write(this.formatter.format(samples));
            this.writer.write(System.lineSeparator());
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private IdentifiedNodeSampleFormatter formatter = new SimpleFormatter();
        private String path = "MonitorTextStorage.txt";
        private boolean append = true;

        public Builder setFormatter(IdentifiedNodeSampleFormatter formatter) {
            this.formatter = formatter;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setAppend(boolean append) {
            this.append = append;
            return this;
        }

        public LocalTextStorage build() {
            return new LocalTextStorage(this.formatter, this.path, this.append);
        }
    }
}

