/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.monitor.datalayer;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.formatting.JSONFormatter;
import pt.unl.fct.di.novasys.babel.metrics.monitor.datalayer.Storage;
import pt.unl.fct.di.novasys.babel.metrics.utils.ClientSocketCommons;

public class MonitorStorage
implements Storage {
    LinkedBlockingQueue<Map<String, NodeSample>> queue = new LinkedBlockingQueue();
    ClientSocketCommons.HostPort hostPort;
    Thread thread = new Thread(this::sendSamplesSocket);
    boolean threadRunning = false;

    public MonitorStorage(Properties props) {
        try {
            this.hostPort = ClientSocketCommons.parseHostPort(props);
        }
        catch (ClientSocketCommons.IncorrectHostPortException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    private void sendSamplesSocket() {
        OutputStreamWriter osw;
        JSONFormatter jsonFormatter = new JSONFormatter();
        Socket socket = ClientSocketCommons.connect(this.hostPort.host, this.hostPort.port);
        try {
            osw = new OutputStreamWriter(socket.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (true) {
            try {
                while (true) {
                    osw.write(jsonFormatter.format(this.queue.take()));
                    osw.write("\n");
                    osw.flush();
                }
            }
            catch (IOException | NullPointerException e) {
                socket = ClientSocketCommons.connect(this.hostPort.host, this.hostPort.port);
                try {
                    osw = new OutputStreamWriter(socket.getOutputStream());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void store(String host, NodeSample nodeSample) {
        Map<String, NodeSample> samples = Map.of(host, nodeSample);
        this.store(samples);
    }

    @Override
    public void store(Map<String, NodeSample> samples) {
        if (!this.threadRunning) {
            this.thread.start();
            this.threadRunning = true;
        }
        this.queue.add(samples);
    }
}

