/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONParser {
    public static Object parseJson(String json) {
        Tokenizer tokenizer = new Tokenizer(json);
        tokenizer.skipInitialWhitespace();
        return JSONParser.parseValue(tokenizer);
    }

    public static Object parseJsonFile(String filePath) {
        StringBuilder jsonBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                jsonBuilder.append(line.trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String json = jsonBuilder.toString();
        return JSONParser.parseJson(json);
    }

    private static Map<String, Object> parseObject(Tokenizer tokenizer) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        tokenizer.consume('{');
        while (tokenizer.peek() != '}') {
            String key = tokenizer.nextString();
            tokenizer.consume(':');
            Object value = JSONParser.parseValue(tokenizer);
            map.put(key, value);
            if (tokenizer.peek() != ',') continue;
            tokenizer.consume(',');
        }
        tokenizer.consume('}');
        return map;
    }

    private static List<Object> parseArray(Tokenizer tokenizer) {
        ArrayList<Object> list = new ArrayList<Object>();
        tokenizer.consume('[');
        while (tokenizer.peek() != ']') {
            list.add(JSONParser.parseValue(tokenizer));
            if (tokenizer.peek() != ',') continue;
            tokenizer.consume(',');
        }
        tokenizer.consume(']');
        return list;
    }

    private static Object parseValue(Tokenizer tokenizer) {
        char nextChar = tokenizer.peek();
        if (nextChar == '{') {
            return JSONParser.parseObject(tokenizer);
        }
        if (nextChar == '[') {
            return JSONParser.parseArray(tokenizer);
        }
        if (nextChar == '\"') {
            return tokenizer.nextString();
        }
        return tokenizer.nextPrimitive();
    }

    public static void main(String[] args) {
        String jsonString = "[{\"type\":\"TimedLogExporter\",\"name\":false,\"exporterConfigs\":\"./exporter.Properties\",\"exporterCollectOptions\":\"./exporter_collectoptions.json\"}]";
        Object parsedJson = JSONParser.parseJson(jsonString);
        System.out.println(parsedJson);
    }

    private static class Tokenizer {
        private final String json;
        private int pos;

        public Tokenizer(String json) {
            this.json = json;
            this.pos = 0;
        }

        public void skipInitialWhitespace() {
            while (this.pos < this.json.length() && (this.json.charAt(this.pos) == ' ' || this.json.charAt(this.pos) == '\t' || this.json.charAt(this.pos) == '\n')) {
                ++this.pos;
            }
        }

        public char peek() {
            this.skipWhitespace();
            return this.json.charAt(this.pos);
        }

        public void consume(char expected) {
            this.skipWhitespace();
            if (this.json.charAt(this.pos) != expected) {
                throw new RuntimeException("Expected '" + expected + "' but found '" + this.json.charAt(this.pos) + "'");
            }
            ++this.pos;
        }

        public String nextString() {
            this.consume('\"');
            StringBuilder sb = new StringBuilder();
            while (this.json.charAt(this.pos) != '\"') {
                sb.append(this.json.charAt(this.pos));
                ++this.pos;
            }
            this.consume('\"');
            return sb.toString();
        }

        public Object nextPrimitive() {
            StringBuilder sb = new StringBuilder();
            while (this.pos < this.json.length() && !Character.isWhitespace(this.json.charAt(this.pos)) && this.json.charAt(this.pos) != ',' && this.json.charAt(this.pos) != ']' && this.json.charAt(this.pos) != '}') {
                sb.append(this.json.charAt(this.pos));
                ++this.pos;
            }
            String value = sb.toString();
            if (value.equals("true") || value.equals("false")) {
                return Boolean.parseBoolean(value);
            }
            if (value.contains(".")) {
                return Double.parseDouble(value);
            }
            return Integer.parseInt(value);
        }

        private void skipWhitespace() {
            while (this.pos < this.json.length() && Character.isWhitespace(this.json.charAt(this.pos))) {
                ++this.pos;
            }
        }
    }
}

