/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.hyparview;

import java.io.IOException;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.AutoConfigureParameter;
import pt.unl.fct.di.novasys.babel.core.adaptive.AdaptiveMembershipProtocol;
import pt.unl.fct.di.novasys.babel.core.adaptive.annotations.Adaptive;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.ReconfigurationSucceeded;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.DecreaseNumberNeighbors;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.IncreaseNumberNeighbors;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.metrics.Counter;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.DisconnectMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.ForwardJoinMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.JoinMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.JoinReplyMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.NeighborReplyMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.NeighborRequestMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.ShuffleMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.ShuffleReplyMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.timers.CheckConnectivityTimeout;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.timers.ShuffleTimer;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.utils.IView;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.utils.View;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborDown;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborUp;
import pt.unl.fct.di.novasys.babel.protocols.membership.requests.GetNeighborsSampleReply;
import pt.unl.fct.di.novasys.babel.protocols.membership.requests.GetNeighborsSampleRequest;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.data.Host;

public class HyParView
extends AdaptiveMembershipProtocol {
    private static final Logger logger = LogManager.getLogger(HyParView.class);
    private static final String LOGGER_RECONFIG_TAG = "RECONFIGURATION";
    public static final short PROTOCOL_ID = 400;
    public static final String PROTOCOL_NAME = "HyParView";
    private static final int MAX_BACKOFF = 120000;
    @Adaptive
    @AutoConfigureParameter
    private short ARWL;
    @AutoConfigureParameter
    private short PRWL;
    @AutoConfigureParameter
    private int maxActive;
    @AutoConfigureParameter
    private int maxPassive;
    @AutoConfigureParameter
    private short shuffleTime;
    @AutoConfigureParameter
    private short originalTimeout;
    private short timeout;
    @AutoConfigureParameter
    private short kActive;
    @AutoConfigureParameter
    private short kPassive;
    private final boolean isFounder;
    protected int channelId;
    private Host contact;
    protected Host substituteNeighbor;
    protected IView active;
    protected IView passive;
    protected Set<Host> pending;
    private final Map<Short, Host[]> activeShuffles;
    private final Set<Long> activeConnectivityTimers;
    private String DNSHost;
    private Counter sentMessagesCounter = this.registerMetric(new Counter("SentMessages", "", new String[0]));
    private short seqNum = 0;
    protected final Random rnd;
    public static final String PAR_ACTIVE_VIEW_SIZE = "HyParView.ActiveView";
    public static final String PAR_PASSIVE_VIEW_SIZE = "HyParView.PassiveView";
    public static final String PAR_ARWL = "HyParView.ARWL";
    public static final String PAR_PRWL = "HyParView.PRWL";
    public static final String PAR_SHUFFLE_PERIOD = "HyParView.ShufflePeriod";
    public static final String PAR_CHECK_CONNECTIVITY_PERIOD = "HyParView.CheckConnectivityPeriod";
    public static final String PAR_K_A = "HyParView.kActive";
    public static final String PAR_K_P = "HyParView.kPassive";
    public static final String PAR_CONTACT = "HyParView.contact";
    public static final String PAR_DNS_HOST = "HyParView.DNSHost";
    public static final String PAR_CHANNEL_ADDRESS = "HyParView.Channel.Address";
    public static final String PAR_CHANNEL_PORT = "HyParView.Channel.Port";

    public HyParView(String channelName, Properties props, Host myself) throws IOException, HandlerRegistrationException {
        super(PROTOCOL_NAME, (short)400);
        this.setMyself(myself);
        this.substituteNeighbor = null;
        this.ARWL = Short.parseShort(props.getProperty(PAR_ARWL, "-1"));
        this.PRWL = Short.parseShort(props.getProperty(PAR_PRWL, "-1"));
        this.shuffleTime = Short.parseShort(props.getProperty(PAR_SHUFFLE_PERIOD, "-1"));
        this.timeout = this.originalTimeout = Short.parseShort(props.getProperty(PAR_CHECK_CONNECTIVITY_PERIOD, "-1"));
        this.kActive = Short.parseShort(props.getProperty(PAR_K_A, "-1"));
        this.kPassive = Short.parseShort(props.getProperty(PAR_K_P, "-1"));
        this.rnd = new Random();
        this.pending = new HashSet<Host>();
        this.activeShuffles = new TreeMap<Short, Host[]>();
        this.activeConnectivityTimers = new HashSet<Long>();
        Properties channelProps = new Properties();
        if (props.containsKey(PAR_CHANNEL_ADDRESS) && props.containsKey(PAR_CHANNEL_PORT)) {
            String address = props.getProperty(PAR_CHANNEL_ADDRESS);
            String port = props.getProperty(PAR_CHANNEL_PORT);
            channelProps.setProperty("address", address);
            channelProps.setProperty("port", port);
            this.channelId = this.createChannel("TCPChannel", channelProps);
        } else {
            if (this.getMyself() == null) {
                throw new RuntimeException("Cannot determine the interface and address to bind to");
            }
            channelProps.setProperty("address", this.getMyself().getAddress().getHostAddress());
            channelProps.setProperty("port", "" + this.getMyself().getPort());
            this.channelId = this.createChannel("TCPChannel", channelProps);
        }
        this.setDefaultChannel(this.channelId);
        this.setReconfigurationChannel();
        if (props.containsKey(PAR_CONTACT)) {
            String contact = props.getProperty(PAR_CONTACT).trim();
            if (!contact.isEmpty() && !contact.equalsIgnoreCase("none")) {
                try {
                    String[] hostElems = contact.split(":");
                    Host c = new Host(InetAddress.getByName(hostElems[0]), Short.parseShort(hostElems[1]));
                    this.addContact(c);
                }
                catch (Exception e) {
                    System.err.println("Invalid contact on configuration: '" + props.getProperty(PAR_CONTACT));
                    e.printStackTrace();
                    System.exit(-1);
                }
                this.isFounder = false;
            } else {
                this.isFounder = true;
            }
        } else {
            this.isFounder = false;
        }
        this.registerMessageSerializer(this.channelId, (short)401, JoinMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)402, JoinReplyMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)403, ForwardJoinMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)405, NeighborRequestMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)406, NeighborReplyMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)404, DisconnectMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)407, ShuffleMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)408, ShuffleReplyMessage.serializer);
        this.registerMessageHandler(this.channelId, (short)401, this::uponReceiveJoin);
        this.registerMessageHandler(this.channelId, (short)402, this::uponReceiveJoinReply);
        this.registerMessageHandler(this.channelId, (short)403, this::uponReceiveForwardJoin);
        this.registerMessageHandler(this.channelId, (short)405, this::uponRNeeighborRequest);
        this.registerMessageHandler(this.channelId, (short)406, this::uponReceiveNeighborReply);
        this.registerMessageHandler(this.channelId, (short)404, this::uponReceiveDisconnect, this::uponDisconnectSent);
        this.registerMessageHandler(this.channelId, (short)407, this::uponShuffle);
        this.registerMessageHandler(this.channelId, (short)408, this::uponReceiveShuffleReply, this::uponShuffleReplySent);
        this.registerRequestHandler((short)401, this::uponGetSampleRequest);
        this.registerTimerHandler((short)401, this::uponShuffleTimer);
        this.registerTimerHandler((short)402, this::uponCheckConnectivityTimer);
        this.registerChannelEventHandler(this.channelId, (short)3, this::uponOutConnectionDown);
        this.registerChannelEventHandler(this.channelId, (short)4, this::uponOutConnectionFailed);
        this.registerChannelEventHandler(this.channelId, (short)5, this::uponOutConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)2, this::uponInConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)1, this::uponInConnectionDown);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        this.setFirstMaxActive(props.getProperty(PAR_ACTIVE_VIEW_SIZE, "-1"));
        this.setFirstMaxPassive(props.getProperty(PAR_PASSIVE_VIEW_SIZE, "-1"));
        this.DNSHost = props.getProperty(PAR_DNS_HOST);
    }

    @Override
    protected long getCurrentNeighborsSize() {
        return this.active.getCapacity();
    }

    private void uponGetSampleRequest(GetNeighborsSampleRequest req, short protoID) {
        if (req.getSampleSize() <= this.active.getCapacity()) {
            this.sendReply(new GetNeighborsSampleReply(this.active.getPeers()), protoID);
            return;
        }
        SecureRandom r = new SecureRandom();
        HashSet<Host> candidates = new HashSet<Host>(this.active.getPeers());
        while (candidates.size() > req.getSampleSize()) {
            candidates.remove(candidates.toArray()[r.nextInt(candidates.size())]);
        }
        this.sendReply(new GetNeighborsSampleReply((Set<? extends Host>)candidates), protoID);
    }

    @Override
    protected void uponDecreaseNumberNeighbors(DecreaseNumberNeighbors request, short protoID) {
        short amount = request.getAmount();
        this.active.changeCapacity(-amount);
        this.kActive = (short)(this.kActive - amount);
        this.triggerNotification(new ReconfigurationSucceeded("active", this.active.getCapacity(), PROTOCOL_NAME));
    }

    @Override
    protected void uponIncreaseNumberNeighbors(IncreaseNumberNeighbors request, short protoID) {
        short amount = request.getAmount();
        this.active.changeCapacity(amount);
        this.kActive = (short)(this.kActive + amount);
        this.triggerNotification(new ReconfigurationSucceeded("active", this.active.getCapacity(), PROTOCOL_NAME));
    }

    public int getChannel() {
        return this.channelId;
    }

    protected void handleDropFromActive(Host dropped) {
        if (dropped != null) {
            this.triggerNotification(new NeighborDown(dropped, false));
            this.sendMessage((ProtoMessage)new DisconnectMessage(), dropped);
            this.sentMessagesCounter.inc();
            logger.debug("Sent DisconnectMessage to {}", (Object)dropped);
            this.passive.addPeer(dropped);
            logger.trace("Added to {} passive{}", (Object)dropped, (Object)this.passive);
        }
    }

    private void uponReceiveJoin(JoinMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        Host h2 = this.active.addPeer(from);
        logger.trace("Added to {} active{}", (Object)from, (Object)this.active);
        this.openConnection(from);
        this.triggerNotification(new NeighborUp(from));
        this.sendMessage((ProtoMessage)new JoinReplyMessage(), from);
        this.sentMessagesCounter.inc();
        logger.debug("Sent JoinReplyMessage to {}", (Object)from);
        this.handleDropFromActive(h2);
        for (Host peer : this.active.getPeers()) {
            if (peer.equals(from)) continue;
            this.sendMessage((ProtoMessage)new ForwardJoinMessage(this.ARWL, from), peer);
            this.sentMessagesCounter.inc();
            logger.debug("Sent ForwardJoinMessage to {}", (Object)peer);
        }
    }

    private void uponReceiveJoinReply(JoinReplyMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        if (!this.active.containsPeer(from)) {
            this.passive.removePeer(from);
            this.pending.remove(from);
            Host h2 = this.active.addPeer(from);
            this.openConnection(from);
            logger.trace("Added to {} active{}", (Object)from, (Object)this.active);
            this.triggerNotification(new NeighborUp(from));
            this.handleDropFromActive(h2);
        }
    }

    private void uponReceiveForwardJoin(ForwardJoinMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        if (msg.decrementTtl() == 0 || this.active.getPeers().size() == 1) {
            if (!msg.getNewHost().equals(this.getMyself()) && !this.active.containsPeer(msg.getNewHost())) {
                this.passive.removePeer(msg.getNewHost());
                this.pending.remove(msg.getNewHost());
                Host h2 = this.active.addPeer(msg.getNewHost());
                logger.trace("Added to {} active{}", (Object)msg.getNewHost(), (Object)this.active);
                this.openConnection(msg.getNewHost());
                this.triggerNotification(new NeighborUp(msg.getNewHost()));
                this.sendMessage((ProtoMessage)new JoinReplyMessage(), msg.getNewHost());
                this.sentMessagesCounter.inc();
                logger.debug("Sent JoinReplyMessage to {}", (Object)msg.getNewHost());
                this.handleDropFromActive(h2);
            }
        } else {
            Host next;
            if (msg.getTtl() == this.PRWL) {
                this.passive.addPeer(msg.getNewHost());
                logger.trace("Added to {} passive{}", (Object)from, (Object)this.passive);
            }
            if ((next = this.active.getRandomDiff(from, msg.getNewHost())) != null) {
                this.sendMessage((ProtoMessage)msg, next);
                this.sentMessagesCounter.inc();
                logger.debug("Sent ForwardJoinMessage to {}", (Object)next);
            }
        }
    }

    private void uponRNeeighborRequest(NeighborRequestMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        if (msg.isPriority()) {
            if (!this.active.containsPeer(from)) {
                this.pending.remove(from);
                logger.trace("Removed from {} pending{}", (Object)from, (Object)this.pending);
                this.passive.removePeer(from);
                logger.trace("Removed from {} passive{}", (Object)from, (Object)this.passive);
                Host h2 = this.active.addPeer(from);
                logger.trace("Added to {} active{}", (Object)from, (Object)this.active);
                this.openConnection(from);
                this.triggerNotification(new NeighborUp(from));
                this.handleDropFromActive(h2);
            }
            this.sendMessage((ProtoMessage)new NeighborReplyMessage(true), from);
            this.sentMessagesCounter.inc();
            logger.debug("Sent NeighborReplyMessage to {}", (Object)from);
        } else {
            this.pending.remove(from);
            logger.trace("Removed from {} pending{}", (Object)from, (Object)this.pending);
            if (!this.active.fullWithPending(this.pending) || this.active.containsPeer(from)) {
                if (!this.active.containsPeer(from)) {
                    this.passive.removePeer(from);
                    logger.trace("Removed from {} passive{}", (Object)from, (Object)this.passive);
                    this.active.addPeer(from);
                    logger.trace("Added to {} active{}", (Object)from, (Object)this.active);
                    this.openConnection(from);
                    this.triggerNotification(new NeighborUp(from));
                }
                this.sendMessage((ProtoMessage)new NeighborReplyMessage(true), from);
                this.sentMessagesCounter.inc();
                logger.debug("Sent NeighborReplyMessage to {}", (Object)from);
                this.substituteNeighbor = from;
                logger.debug("Substitute neighbor set to {} due to priority", (Object)from);
            } else if (this.substituteNeighbor != null) {
                this.sendMessage((ProtoMessage)new NeighborReplyMessage(false, this.substituteNeighbor), from, 1);
                this.sentMessagesCounter.inc();
                logger.debug("Sent NeighborReplyMessage to {} with {} as a substitute neighbor", (Object)from, (Object)this.substituteNeighbor);
                this.substituteNeighbor = null;
            } else {
                this.sendMessage((ProtoMessage)new NeighborReplyMessage(false), from, 1);
                this.sentMessagesCounter.inc();
                logger.debug("Sent NeighborReplyMessage to {}", (Object)from);
                this.substituteNeighbor = from;
                this.passive.addPeer(from);
                logger.debug("Substitute neighbor set to {}", (Object)from);
            }
        }
    }

    private void uponReceiveNeighborReply(NeighborReplyMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        this.pending.remove(from);
        logger.trace("Removed from {} pending{}", (Object)from, (Object)this.pending);
        if (msg.isTrue()) {
            if (!this.active.containsPeer(from)) {
                this.timeout = this.originalTimeout;
                Host h2 = this.active.addPeer(from);
                logger.trace("Added to {} active{}", (Object)from, (Object)this.active);
                this.openConnection(from);
                this.triggerNotification(new NeighborUp(from));
                this.handleDropFromActive(h2);
            }
        } else if (!this.active.containsPeer(from)) {
            this.passive.addPeer(from);
            this.closeConnection(from);
            logger.trace("Added to {} passive{}", (Object)from, (Object)this.passive);
            Host substitute = msg.getSubstitute();
            if (substitute != null) {
                this.openConnection(substitute);
                this.sendMessage((ProtoMessage)new NeighborRequestMessage(this.getPriority()), substitute);
                this.sentMessagesCounter.inc();
                this.pending.add(substitute);
                logger.debug("Sent HelloMessage to {}", (Object)substitute);
            }
            if (!this.active.fullWithPending(this.pending)) {
                this.timeout = (short)Math.min(this.timeout * 2, 120000);
                this.activeConnectivityTimers.add(this.setupTimer(new CheckConnectivityTimeout(), this.timeout));
            }
        }
    }

    private void uponReceiveDisconnect(DisconnectMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        if (this.active.containsPeer(from)) {
            this.active.removePeer(from);
            logger.trace("Removed from {} active{}", (Object)from, (Object)this.active);
            this.handleDropFromActive(from);
            if (this.active.getPeers().isEmpty()) {
                this.timeout = this.originalTimeout;
            }
        }
    }

    private void uponDisconnectSent(DisconnectMessage msg, Host host, short destProto, int channelId) {
        logger.trace("Sent {} to {}", (Object)msg, (Object)host);
        this.closeConnection(host);
    }

    private void uponShuffle(ShuffleMessage msg, Host from, short sourceProto, int channelId) {
        Host[] tmp;
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        Host next = this.active.getRandomDiff(from, msg.getOrigin());
        if (msg.decrementTtl() > 0 && next != null) {
            this.sendMessage((ProtoMessage)msg, next);
            this.sentMessagesCounter.inc();
            logger.debug("Sent ShuffleMessage to {}", (Object)next);
            return;
        }
        logger.trace("Processing {}, passive{}", (Object)msg, (Object)this.passive);
        HashSet<Host> peers = new HashSet<Host>();
        peers.addAll(this.passive.getRandomSample(1 + this.kActive + this.kPassive));
        Host[] hosts = peers.toArray(new Host[peers.size()]);
        if (!this.active.containsPeer(msg.getOrigin()) && !this.pending.contains(msg.getOrigin())) {
            this.openConnection(msg.getOrigin());
        }
        this.sendMessage((ProtoMessage)new ShuffleReplyMessage(peers, msg.getSeqnum()), msg.getOrigin());
        this.sentMessagesCounter.inc();
        logger.debug("Sent ShuffleReplyMessage to {}", (Object)msg.getOrigin());
        List<Host> shuffleSample = msg.getFullSample();
        for (Host h2 : tmp = shuffleSample.toArray(new Host[shuffleSample.size()])) {
            if (!h2.equals(this.getMyself()) && !this.active.containsPeer(h2) && !this.passive.containsPeer(h2)) continue;
            shuffleSample.remove(h2);
        }
        for (int i = 0; i < hosts.length && this.passive.getPeers().size() + shuffleSample.size() > this.passive.getCapacity(); ++i) {
            this.passive.removePeer(hosts[i]);
        }
        while (this.passive.getPeers().size() + shuffleSample.size() > this.passive.getCapacity()) {
            this.passive.dropRandom();
        }
        for (Host h3 : shuffleSample) {
            this.passive.addPeer(h3);
        }
        logger.trace("After Passive{}", (Object)this.passive);
    }

    private void uponShuffleReplySent(ShuffleReplyMessage msg, Host host, short destProto, int channelId) {
        if (!this.active.containsPeer(host) && !this.pending.contains(host)) {
            logger.trace("Disconnecting from {} after shuffleReply", (Object)host);
            this.closeConnection(host);
        }
    }

    private void uponReceiveShuffleReply(ShuffleReplyMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        Host[] sent = this.activeShuffles.remove(msg.getSeqnum());
        if (sent == null) {
            sent = new Host[]{};
        }
        List<Host> sample = msg.getSample();
        for (Host h2 : sample.toArray(new Host[sample.size()])) {
            if (!h2.equals(this.getMyself()) && !this.active.containsPeer(h2) && !this.passive.containsPeer(h2)) continue;
            sample.remove(h2);
        }
        for (int i = 0; i < sent.length && this.passive.getPeers().size() + sample.size() > this.passive.getCapacity(); ++i) {
            this.passive.removePeer(sent[i]);
        }
        while (this.passive.getPeers().size() + sample.size() > this.passive.getCapacity()) {
            this.passive.dropRandom();
        }
        for (Host h3 : sample) {
            this.passive.addPeer(h3);
        }
        logger.trace("After Passive {}", (Object)this.passive);
    }

    private void uponShuffleTimer(ShuffleTimer timer, long timerId) {
        Host h2;
        if (!this.active.fullWithPending(this.pending)) {
            this.activeConnectivityTimers.add(this.setupTimer(new CheckConnectivityTimeout(), this.timeout));
        }
        if ((h2 = this.active.getRandom()) != null) {
            HashSet<Host> peers = new HashSet<Host>();
            peers.addAll(this.active.getRandomSample(this.kActive));
            peers.addAll(this.passive.getRandomSample(this.kPassive));
            this.activeShuffles.put(this.seqNum, peers.toArray(new Host[peers.size()]));
            this.sendMessage((ProtoMessage)new ShuffleMessage(this.getMyself(), peers, this.ARWL, this.seqNum), h2);
            this.sentMessagesCounter.inc();
            logger.debug("Sent ShuffleMessage to {}", (Object)h2);
            this.seqNum = (short)((short)(this.seqNum % Short.MAX_VALUE) + 1);
        }
    }

    private void uponCheckConnectivityTimer(CheckConnectivityTimeout timer, long timerId) {
        this.activeConnectivityTimers.clear();
        if (!this.active.fullWithPending(this.pending)) {
            Host h2 = this.passive.dropRandom();
            if (h2 != null && this.pending.add(h2)) {
                logger.trace("Sending HelloMessage to {}, pending {}, active {}, passive {}", (Object)h2, (Object)this.pending, (Object)this.active, (Object)this.passive);
                this.openConnection(h2);
                this.sendMessage((ProtoMessage)new NeighborRequestMessage(this.getPriority()), h2);
                this.sentMessagesCounter.inc();
                logger.debug("Sent HelloMessage to {}", (Object)h2);
                this.timeout = (short)Math.min(this.timeout * 2, 120000);
            } else if (h2 != null) {
                this.passive.addPeer(h2);
            }
        }
    }

    private boolean getPriority() {
        return this.active.getPeers().size() + this.pending.size() == 1;
    }

    private void uponOutConnectionDown(OutConnectionDown event, int channelId) {
        logger.trace("Host {} is down, active{}, cause: {}", (Object)event.getNode(), (Object)this.active, (Object)event.getCause());
        if (this.active.removePeer(event.getNode())) {
            this.triggerNotification(new NeighborDown(event.getNode(), true));
            if (!this.active.fullWithPending(this.pending)) {
                this.activeConnectivityTimers.add(this.setupTimer(new CheckConnectivityTimeout(), this.timeout));
            }
        } else {
            this.pending.remove(event.getNode());
        }
    }

    private void uponOutConnectionFailed(OutConnectionFailed<?> event, int channelId) {
        logger.trace("Connection to host {} failed, cause: {}", (Object)event.getNode(), (Object)event.getCause());
        if (this.active.removePeer(event.getNode())) {
            this.triggerNotification(new NeighborDown(event.getNode(), true));
            if (!this.active.fullWithPending(this.pending)) {
                this.activeConnectivityTimers.add(this.setupTimer(new CheckConnectivityTimeout(), this.timeout));
            }
        } else {
            this.pending.remove(event.getNode());
        }
    }

    private void uponOutConnectionUp(OutConnectionUp event, int channelId) {
        logger.trace("Host (out) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionUp(InConnectionUp event, int channelId) {
        logger.trace("Host (in) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionDown(InConnectionDown event, int channelId) {
        logger.trace("Connection from host {} is down, active{}, cause: {}", (Object)event.getNode(), (Object)this.active, (Object)event.getCause());
    }

    public void setARWL(Short arwl) {
        if (arwl != null) {
            this.ARWL = arwl;
            logger.debug("{} ARWL {}", (Object)LOGGER_RECONFIG_TAG, (Object)this.ARWL);
            this.PRWL = (short)Math.floor(arwl / 2);
            logger.debug("{} PRWL {}", (Object)LOGGER_RECONFIG_TAG, (Object)this.PRWL);
        }
    }

    public String getFirstMaxActive() {
        return this.maxActive == -1 ? null : String.valueOf(this.maxActive);
    }

    public void setFirstMaxActive(String maxActive) {
        this.maxActive = Integer.parseInt(maxActive);
        logger.debug("maxActive set to {}", (Object)this.active);
        if (this.maxActive == -1) {
            return;
        }
        this.active = new View(this.maxActive, this.getMyself(), this.rnd);
        if (this.passive != null) {
            this.active.setOther(this.passive, this.pending);
            this.passive.setOther(this.active, this.pending);
        }
    }

    public String getFirstMaxPassive() {
        return this.maxPassive == -1 ? null : String.valueOf(this.maxPassive);
    }

    public void setFirstMaxPassive(String maxPassive) {
        this.maxPassive = Integer.parseInt(maxPassive);
        logger.debug("maxPassive set to {}", (Object)this.passive);
        if (this.maxPassive == -1) {
            return;
        }
        this.passive = new View(this.maxPassive, this.getMyself(), this.rnd);
        if (this.active != null) {
            this.active.setOther(this.passive, this.pending);
            this.passive.setOther(this.active, this.pending);
        }
    }

    public String getFirstARWL() {
        return this.ARWL == -1 ? null : String.valueOf(this.ARWL);
    }

    public void setFirstARWL(String arwl) {
        this.ARWL = Short.parseShort(arwl);
        logger.debug("ARWL set to {}", (Object)this.ARWL);
    }

    public String getFirstPRWL() {
        return this.PRWL == -1 ? null : String.valueOf(this.PRWL);
    }

    public void setFirstPRWL(String prwl) {
        this.PRWL = Short.parseShort(prwl);
        logger.debug("PRWL set to {}", (Object)this.PRWL);
    }

    public String getFirstShuffleTime() {
        return this.shuffleTime == -1 ? null : String.valueOf(this.shuffleTime);
    }

    public void setFirstShuffleTime(String shuffleTime) {
        this.shuffleTime = Short.parseShort(shuffleTime);
        logger.debug("ShuffleTime set to {}", (Object)this.shuffleTime);
    }

    public String getFirstKActive() {
        return this.kActive == -1 ? null : String.valueOf(this.kActive);
    }

    public void setFirstKActive(String kActive) {
        this.kActive = Short.parseShort(kActive);
        logger.debug("kActive set to {}", (Object)this.kActive);
    }

    public String getFirstKPassive() {
        return this.kPassive == -1 ? null : String.valueOf(this.kPassive);
    }

    public void setFirstKPassive(String kPassive) {
        this.kPassive = Short.parseShort(kPassive);
        logger.debug("kPassive set to {}", (Object)this.kPassive);
    }

    public String getFirstOriginalTimeout() {
        return this.originalTimeout == -1 ? null : String.valueOf(this.originalTimeout);
    }

    public void setFirstOriginalTimeout(String timeout) {
        this.timeout = this.originalTimeout = Short.parseShort(timeout);
        logger.debug("OriginalTimeout set to {}", (Object)this.originalTimeout);
    }

    @Override
    public void start() {
        if (this.contact != null) {
            JoinMessage m4 = new JoinMessage();
            this.sendMessage((ProtoMessage)m4, this.contact);
            this.sentMessagesCounter.inc();
            logger.debug("Sent JoinMessage to {}", (Object)this.contact);
            logger.trace("Sent " + String.valueOf(m4) + " to " + String.valueOf(this.contact));
        }
        this.setupPeriodicTimer(new ShuffleTimer(), this.shuffleTime, this.shuffleTime);
    }

    @Override
    public boolean readyToStart() {
        boolean result = (this.contact != null || this.isFounder) && this.ARWL != -1 && this.PRWL != -1 && this.originalTimeout != -1 && this.shuffleTime != -1 && this.kPassive != -1 && this.kActive != -1 && this.maxActive != -1 && this.maxPassive != -1;
        logger.debug("Checking if protocol is ready to start. Result: {}", (Object)result);
        return result;
    }

    @Override
    public boolean needsDiscovery() {
        boolean result = !this.isFounder && this.contact == null;
        logger.debug("Checking if protocol needs discovery. Is Founder: {}, Contact: {}, Result: {}", (Object)this.isFounder, (Object)this.contact, (Object)result);
        return result;
    }

    @Override
    public void addContact(Host host) {
        this.contact = host;
        this.openConnection(this.contact);
    }

    @Override
    public Host getContact() {
        return this.contact;
    }

    @Override
    public String getHost() {
        return this.DNSHost;
    }
}

