/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.hyparview.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.utils.IView;
import pt.unl.fct.di.novasys.network.data.Host;

public class View
implements IView {
    private int capacity;
    private final Set<Host> peers;
    private final Random rnd;
    private final Host self;
    private IView other;
    private Set<Host> pending;

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public View(int capacity, Host self, Random rnd) {
        this.capacity = capacity;
        this.self = self;
        this.peers = new HashSet<Host>();
        this.rnd = rnd;
    }

    @Override
    public void setOther(IView other, Set<Host> pending) {
        this.other = other;
        this.pending = pending;
    }

    public String toString() {
        return "View{peers=" + String.valueOf(this.peers) + "}";
    }

    @Override
    public Host addPeer(Host peer) {
        if (!(peer.equals(this.self) || this.peers.contains(peer) || this.other.containsPeer(peer) || this.pending.contains(peer))) {
            Host excess = null;
            if (this.peers.size() == this.capacity) {
                excess = this.dropRandom();
            }
            boolean ret = this.peers.add(peer);
            assert (ret);
            assert (this.peers.size() <= this.capacity);
            return excess;
        }
        return null;
    }

    @Override
    public boolean removePeer(Host peer) {
        return this.peers.remove(peer);
    }

    @Override
    public boolean containsPeer(Host peer) {
        return this.peers.contains(peer);
    }

    @Override
    public Host dropRandom() {
        Host torm = null;
        if (this.peers.size() > 0) {
            int idx = this.rnd.nextInt(this.peers.size());
            Host[] hosts = this.peers.toArray(new Host[0]);
            torm = hosts[idx];
            this.peers.remove(torm);
        }
        return torm;
    }

    @Override
    public Set<Host> getRandomSample(int sampleSize) {
        HashSet<Host> toret;
        if (sampleSize <= 0) {
            throw new RuntimeException("Cannot request a sample with size lower or equal to zero. input: " + sampleSize);
        }
        if (this.peers.size() > sampleSize) {
            ArrayList<Host> hosts = new ArrayList<Host>(this.peers);
            while (hosts.size() > sampleSize) {
                hosts.remove(this.rnd.nextInt(hosts.size()));
            }
            toret = new HashSet<Host>(hosts);
        } else {
            toret = new HashSet<Host>(this.peers);
        }
        return toret;
    }

    @Override
    public Set<Host> getPeers() {
        return this.peers;
    }

    @Override
    public Host getRandom() {
        if (this.peers.size() > 0) {
            int idx = this.rnd.nextInt(this.peers.size());
            Host[] hosts = this.peers.toArray(new Host[0]);
            return hosts[idx];
        }
        return null;
    }

    @Override
    public Host getRandomDiff(Host from, Host from2) {
        ArrayList<Host> hosts = new ArrayList<Host>(this.peers);
        if (from != null) {
            hosts.remove(from);
        }
        if (from2 != null) {
            hosts.remove(from2);
        }
        if (hosts.size() > 0) {
            return (Host)hosts.get(this.rnd.nextInt(hosts.size()));
        }
        return null;
    }

    @Override
    public boolean fullWithPending(Set<Host> pending) {
        assert (this.peers.size() + pending.size() <= this.capacity);
        return this.peers.size() + pending.size() >= this.capacity;
    }

    @Override
    public boolean isFull() {
        return this.peers.size() >= this.capacity;
    }

    @Override
    public void changeCapacity(int delta) {
        this.capacity += delta;
        if (this.capacity < 1) {
            this.capacity = 1;
        }
        this.removeExcessPeers();
    }

    @Override
    public Set<Host> removeExcessPeers() {
        if (this.peers.size() <= this.capacity) {
            return new HashSet<Host>(0);
        }
        HashSet<Host> excess = new HashSet<Host>(this.peers.size() - this.capacity);
        while (this.peers.size() > this.capacity) {
            Host torm = this.dropRandom();
            if (torm == null) continue;
            excess.add(torm);
        }
        return excess;
    }
}

