/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.storage.datatypes;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.protocols.storage.utils.Utils;
import pt.unl.fct.di.novasys.network.ISerializer;

public enum ReplicatedStructuresOperations {
    SET_ADD(ReplicatedDataTypes.SET, StructureOperationTypes.ADD),
    SET_REMOVE(ReplicatedDataTypes.SET, StructureOperationTypes.REMOVE),
    SET_LOOKUP(ReplicatedDataTypes.SET, StructureOperationTypes.LOOKUP),
    SET_ITERATOR(ReplicatedDataTypes.SET, StructureOperationTypes.ITERATOR),
    MAP_PUT(ReplicatedDataTypes.MAP, StructureOperationTypes.PUT),
    MAP_GET(ReplicatedDataTypes.MAP, StructureOperationTypes.GET),
    MAP_DEL(ReplicatedDataTypes.MAP, StructureOperationTypes.DELETE),
    MAP_ITERATOR(ReplicatedDataTypes.MAP, StructureOperationTypes.ITERATOR),
    REGISTER_ASSIGN(ReplicatedDataTypes.REGISTER, StructureOperationTypes.ASSIGN),
    REGISTER_GET(ReplicatedDataTypes.REGISTER, StructureOperationTypes.GET),
    COUNTER_INC(ReplicatedDataTypes.COUNTER, StructureOperationTypes.INC),
    COUNTER_DEC(ReplicatedDataTypes.COUNTER, StructureOperationTypes.DEC),
    COUNTER_GET(ReplicatedDataTypes.COUNTER, StructureOperationTypes.GET),
    LIST_INSERT_AT(ReplicatedDataTypes.LIST, StructureOperationTypes.INSERT_AT),
    LIST_GET_AT(ReplicatedDataTypes.LIST, StructureOperationTypes.GET_AT),
    LIST_REMOVE_AT(ReplicatedDataTypes.LIST, StructureOperationTypes.REMOVE_AT),
    LIST_GET(ReplicatedDataTypes.LIST, StructureOperationTypes.GET),
    FLAG_ENABLE(ReplicatedDataTypes.FLAG, StructureOperationTypes.ENABLE),
    FLAG_DISABLE(ReplicatedDataTypes.FLAG, StructureOperationTypes.DISABLE),
    FLAG_GET(ReplicatedDataTypes.FLAG, StructureOperationTypes.GET),
    MATRIX_SET_CELL(ReplicatedDataTypes.MATRIX, StructureOperationTypes.INSERT_AT),
    MATRIX_SET(ReplicatedDataTypes.MATRIX, StructureOperationTypes.ASSIGN),
    MATRIX_GET(ReplicatedDataTypes.MATRIX, StructureOperationTypes.GET),
    MATRIX_GET_AT(ReplicatedDataTypes.MATRIX, StructureOperationTypes.GET_AT),
    MATRIX_CONTAINS(ReplicatedDataTypes.MATRIX, StructureOperationTypes.CONTAINS);

    private ReplicatedDataTypes dataType;
    private StructureOperationTypes opType;
    public static ISerializer<ReplicatedStructuresOperations> serializer;

    private ReplicatedStructuresOperations(ReplicatedDataTypes dataType, StructureOperationTypes opType) {
        this.dataType = dataType;
        this.opType = opType;
    }

    public ReplicatedDataTypes getDataType() {
        return this.dataType;
    }

    public StructureOperationTypes OperationType() {
        return this.opType;
    }

    static {
        serializer = new ISerializer<ReplicatedStructuresOperations>(){

            @Override
            public void serialize(ReplicatedStructuresOperations policy, ByteBuf out) throws IOException {
                Utils.encodeUTF8(policy.toString(), out);
            }

            @Override
            public ReplicatedStructuresOperations deserialize(ByteBuf in) throws IOException {
                return ReplicatedStructuresOperations.valueOf(Utils.decodeUTF8(in));
            }
        };
    }

    public static enum ReplicatedDataTypes {
        SET,
        MAP,
        REGISTER,
        LIST,
        COUNTER,
        FLAG,
        MATRIX;

        public static ISerializer<ReplicatedDataTypes> serializer;

        static {
            serializer = new ISerializer<ReplicatedDataTypes>(){

                @Override
                public void serialize(ReplicatedDataTypes policy, ByteBuf out) throws IOException {
                    Utils.encodeUTF8(policy.toString(), out);
                }

                @Override
                public ReplicatedDataTypes deserialize(ByteBuf in) throws IOException {
                    return ReplicatedDataTypes.valueOf(Utils.decodeUTF8(in));
                }
            };
        }
    }

    public static enum StructureOperationTypes {
        ADD,
        REMOVE,
        LOOKUP,
        ITERATOR,
        ASSIGN,
        GET,
        PUT,
        DELETE,
        INC,
        DEC,
        INSERT_AT,
        REMOVE_AT,
        GET_AT,
        ENABLE,
        DISABLE,
        CONTAINS;

        public static ISerializer<StructureOperationTypes> serializer;

        static {
            serializer = new ISerializer<StructureOperationTypes>(){

                @Override
                public void serialize(StructureOperationTypes policy, ByteBuf out) throws IOException {
                    Utils.encodeUTF8(policy.toString(), out);
                }

                @Override
                public StructureOperationTypes deserialize(ByteBuf in) throws IOException {
                    return StructureOperationTypes.valueOf(Utils.decodeUTF8(in));
                }
            };
        }
    }
}

