/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.storage.operations.utils;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import pt.unl.fct.di.novasys.network.ISerializer;

public class ConditionsOnObjects {
    private Map<String, List<String>> conditions;
    public static ISerializer<ConditionsOnObjects> serializer = new ISerializer<ConditionsOnObjects>(){

        @Override
        public void serialize(ConditionsOnObjects o, ByteBuf out) throws IOException {
            Map<String, List<String>> conditions = o.getConditions();
            out.writeInt(conditions.keySet().size());
            for (Map.Entry<String, List<String>> entry : conditions.entrySet()) {
                ConditionsOnObjects.encodeUTF8(entry.getKey(), out);
                out.writeInt(entry.getValue().size());
                List<String> conditionsObject = entry.getValue();
                for (String condition : conditionsObject) {
                    ConditionsOnObjects.encodeUTF8(condition, out);
                }
            }
        }

        @Override
        public ConditionsOnObjects deserialize(ByteBuf in) throws IOException {
            HashMap<String, List<String>> conditions = new HashMap<String, List<String>>();
            int numObjects = in.readInt();
            for (int i = 0; i < numObjects; ++i) {
                String objectID = ConditionsOnObjects.decodeUTF8(in);
                LinkedList<String> objectConditions = new LinkedList<String>();
                int numConditionsObject = in.readInt();
                for (int j = 0; j < numConditionsObject; ++j) {
                    objectConditions.add(ConditionsOnObjects.decodeUTF8(in));
                }
                conditions.put(objectID, objectConditions);
            }
            return new ConditionsOnObjects(conditions);
        }
    };

    public ConditionsOnObjects(Map<String, List<String>> conditions) {
        this.conditions = new HashMap<String, List<String>>(conditions);
    }

    public Map<String, List<String>> getConditions() {
        return this.conditions;
    }

    private static void encodeUTF8(String str, ByteBuf out) {
        byte[] stringBytes = str.getBytes(StandardCharsets.UTF_8);
        out.writeInt(stringBytes.length);
        out.writeBytes(stringBytes);
    }

    private static String decodeUTF8(ByteBuf in) {
        int length = in.readInt();
        byte[] stringBytes = new byte[length];
        in.readBytes(stringBytes);
        return new String(stringBytes, StandardCharsets.UTF_8);
    }
}

