/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.secure.auth;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.network.ISerializer;

public class AuthenticatedMessage {
    private final byte[] data;
    private final byte[] mac;

    public AuthenticatedMessage(byte[] msg, byte[] mac) {
        this.data = msg;
        this.mac = mac;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getMac() {
        return this.mac;
    }

    public static ISerializer<AuthenticatedMessage> getSerializer(final int macLength) {
        return new ISerializer<AuthenticatedMessage>(){

            @Override
            public void serialize(AuthenticatedMessage msg, ByteBuf out) throws IOException {
                out.writeBytes(msg.mac).writeInt(msg.data.length).writeBytes(msg.data);
            }

            @Override
            public AuthenticatedMessage deserialize(ByteBuf in) throws IOException {
                byte[] mac = new byte[macLength];
                in.readBytes(mac);
                byte[] data = new byte[in.readInt()];
                in.readBytes(data);
                return new AuthenticatedMessage(data, mac);
            }
        };
    }
}

