/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.secure.tls;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.channel.secure.SecureChannelListener;
import pt.unl.fct.di.novasys.channel.secure.SecureSingleThreadedBiChannel;
import pt.unl.fct.di.novasys.channel.secure.events.SecureInConnectionDown;
import pt.unl.fct.di.novasys.channel.secure.events.SecureInConnectionUp;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionDown;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionFailed;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionUp;
import pt.unl.fct.di.novasys.channel.secure.tls.IdentifiedConnectionState;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.NetworkManager;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Bytes;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;
import pt.unl.fct.di.novasys.network.security.X509ITrustManager;

public class TLSChannel<T>
extends SecureSingleThreadedBiChannel<T, T>
implements AttributeValidator {
    private static final Logger logger = LogManager.getLogger(TLSChannel.class);
    public static final short CHANNEL_MAGIC_NUMBER = 21845;
    public static final String NAME = "TLSChannel";
    public static final String ADDRESS_KEY = "address";
    public static final String PORT_KEY = "port";
    public static final String WORKER_GROUP_KEY = "worker_group";
    public static final String TRIGGER_SENT_KEY = "trigger_sent";
    public static final String METRICS_INTERVAL_KEY = "metrics_interval";
    public static final String HEARTBEAT_INTERVAL_KEY = "heartbeat_interval";
    public static final String HEARTBEAT_TOLERANCE_KEY = "heartbeat_tolerance";
    public static final String CONNECT_TIMEOUT_KEY = "connect_timeout";
    public static final String NONCE_SIZE_KEY = "nonce_length";
    public static final String LISTEN_ADDRESS_ATTR = "listen_address";
    public static final String DEFAULT_PORT = "9572";
    public static final String DEFAULT_HB_INTERVAL = "0";
    public static final String DEFAULT_HB_TOLERANCE = "0";
    public static final String DEFAULT_CONNECT_TIMEOUT = "1000";
    public static final String DEFAULT_METRICS_INTERVAL = "-1";
    public static final int CONNECTION_OUT = 0;
    public static final int CONNECTION_IN = 1;
    private final NetworkManager<T> network;
    private final SecureChannelListener<T> listener;
    private final Attributes baseAttributes;
    private final Map<Long, IdentifiedConnectionState<T>> outConnections;
    private final Map<Bytes, IdentifiedConnectionState<T>> outIdConnections;
    private final Map<Host, List<IdentifiedConnectionState<T>>> outHostConnections;
    private final Map<Bytes, List<Pair<Connection<T>, Host>>> inIdConnections;
    private final Map<Host, List<Pair<Connection<T>, byte[]>>> inHostConnections;
    private List<Pair<Host, Connection<T>>> oldIn;
    private List<Pair<Host, IdentifiedConnectionState<T>>> oldOUt;
    private final boolean triggerSent;
    private final boolean metrics;

    public TLSChannel(ISerializer<T> serializer, SecureChannelListener<T> list, Properties properties, X509IKeyManager keyManager, X509ITrustManager trustManager) throws IOException {
        super(NAME);
        this.listener = list;
        if (!properties.containsKey(ADDRESS_KEY)) {
            throw new IllegalArgumentException("TLSChannel requires binding address");
        }
        InetAddress addr = Inet4Address.getByName(properties.getProperty(ADDRESS_KEY));
        int port = Integer.parseInt(properties.getProperty(PORT_KEY, DEFAULT_PORT));
        int hbInterval = Integer.parseInt(properties.getProperty(HEARTBEAT_INTERVAL_KEY, "0"));
        int hbTolerance = Integer.parseInt(properties.getProperty(HEARTBEAT_TOLERANCE_KEY, "0"));
        int connTimeout = Integer.parseInt(properties.getProperty(CONNECT_TIMEOUT_KEY, DEFAULT_CONNECT_TIMEOUT));
        int metricsInterval = Integer.parseInt(properties.getProperty(METRICS_INTERVAL_KEY, DEFAULT_METRICS_INTERVAL));
        this.triggerSent = Boolean.parseBoolean(properties.getProperty(TRIGGER_SENT_KEY, "false"));
        this.metrics = metricsInterval > 0;
        Host listenAddress = new Host(addr, port);
        EventLoopGroup eventExecutors = properties.containsKey(WORKER_GROUP_KEY) ? (EventLoopGroup)properties.get(WORKER_GROUP_KEY) : NetworkManager.createNewWorkerGroup();
        this.baseAttributes = new Attributes();
        this.baseAttributes.putShort("magic_number", (short)21845);
        this.baseAttributes.putHost(LISTEN_ADDRESS_ATTR, listenAddress);
        this.network = new NetworkManager<T>(serializer, this, hbInterval, hbTolerance, connTimeout, eventExecutors);
        this.network.useTLS(keyManager, trustManager);
        this.network.createServerSocket(this, listenAddress, this.baseAttributes, (AttributeValidator)this, eventExecutors);
        this.outConnections = new HashMap<Long, IdentifiedConnectionState<T>>();
        this.outHostConnections = new HashMap<Host, List<IdentifiedConnectionState<T>>>();
        this.outIdConnections = new HashMap<Bytes, IdentifiedConnectionState<T>>();
        this.inIdConnections = new HashMap<Bytes, List<Pair<Connection<T>, Host>>>();
        this.inHostConnections = new HashMap<Host, List<Pair<Connection<T>, byte[]>>>();
        if (this.metrics) {
            this.oldIn = new LinkedList<Pair<Host, Connection<T>>>();
            this.oldOUt = new LinkedList<Pair<Host, IdentifiedConnectionState<T>>>();
            this.loop.scheduleAtFixedRate(this::triggerMetricsEvent, metricsInterval, metricsInterval, TimeUnit.MILLISECONDS);
        }
    }

    void triggerMetricsEvent() {
    }

    @Override
    public boolean validateAttributes(Attributes attr) {
        try {
            Short channel = attr.getShort("magic_number");
            return channel != null && channel == 21845 && attr.getHost(LISTEN_ADDRESS_ATTR) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    private IdentifiedConnectionState<T> removeHostIdConnection(Host host, byte[] peerId) {
        List<IdentifiedConnectionState<T>> hostCons = this.outHostConnections.get(host);
        Iterator<IdentifiedConnectionState<T>> it = hostCons.iterator();
        while (it.hasNext()) {
            IdentifiedConnectionState<T> conState = it.next();
            if (!Arrays.equals(conState.getPeerId(), peerId)) continue;
            it.remove();
            return conState;
        }
        return null;
    }

    private IdentifiedConnectionState<T> removeHostConnectionId(Host host, long conId) {
        List<IdentifiedConnectionState<T>> hostCons = this.outHostConnections.get(host);
        Iterator<IdentifiedConnectionState<T>> it = hostCons.iterator();
        while (it.hasNext()) {
            IdentifiedConnectionState<T> conState = it.next();
            if (conState.getConnectionId() != conId) continue;
            it.remove();
            return conState;
        }
        return null;
    }

    @Override
    protected void onOpenConnection(Host peer, int connection) {
        List<IdentifiedConnectionState<T>> connections = this.outHostConnections.get(peer);
        if (connections == null) {
            logger.debug("onOpenConnection creating connection to: " + String.valueOf(peer));
            IdentifiedConnectionState<T> conState = new IdentifiedConnectionState<T>(this.network.createConnection(peer, this.baseAttributes, this, this), peer);
            connections = new LinkedList<IdentifiedConnectionState<T>>();
            connections.add(conState);
            this.outHostConnections.put(peer, connections);
            this.outConnections.put(conState.getConnectionId(), conState);
        } else {
            logger.debug("onOpenConnection ignored: " + String.valueOf(peer));
        }
    }

    @Override
    protected void onOpenConnection(Host peer, byte[] expectedId, int connection) {
        Bytes expectedIdB = Bytes.of(expectedId);
        IdentifiedConnectionState<T> conState = this.outIdConnections.get(expectedIdB);
        if (conState == null) {
            logger.debug("onOpenConnection creating connection to {} ({})", (Object)peer, (Object)expectedIdB);
            Attributes attrs = this.baseAttributes.shallowClone();
            attrs.putBytes("expected_identity", expectedId);
            conState = new IdentifiedConnectionState<T>(this.network.createConnection(peer, attrs, this, this), peer);
            conState.setPeerId(expectedId);
            this.outIdConnections.put(expectedIdB, conState);
            this.outHostConnections.computeIfAbsent(peer, __ -> new LinkedList()).add(conState);
            this.outConnections.put(conState.getConnectionId(), conState);
        } else {
            logger.debug("onOpenConnection ignored: {} ({})", (Object)peer, (Object)expectedIdB);
        }
    }

    @Override
    protected void onSendMessage(T msg, Host peer, int connection) {
        logger.debug("onSendMessage " + String.valueOf(msg) + " " + String.valueOf(peer) + " " + (connection == 1 ? "IN" : "OUT"));
        if (connection <= 0) {
            List<IdentifiedConnectionState<T>> conList = this.outHostConnections.get(peer);
            if (conList != null) {
                assert (!conList.isEmpty());
                this.sendOutConMessage(conList.getLast(), msg);
            } else {
                this.listener.messageFailed(msg, peer, new IllegalArgumentException("No outgoing connection"));
            }
        } else if (connection == 1) {
            List<Pair<Connection<T>, byte[]>> inCons = this.inHostConnections.get(peer);
            if (inCons != null) {
                assert (!inCons.isEmpty());
                Pair<Connection<T>, byte[]> conAndId = inCons.getLast();
                this.sendWithListener(msg, peer, conAndId.getRight(), conAndId.getLeft());
            } else {
                this.listener.messageFailed(msg, peer, new IllegalArgumentException("No incoming connection"));
            }
        } else {
            this.listener.messageFailed(msg, peer, new IllegalArgumentException("Invalid connection: " + connection));
            logger.error("Invalid sendMessage mode " + connection);
        }
    }

    @Override
    protected void onSendMessage(T msg, byte[] peerIdentity, int connection) {
        Bytes peerIdB = Bytes.of(peerIdentity);
        logger.debug("onSendMessage {} to {} {}", (Object)msg, (Object)peerIdB, (Object)(connection == 1 ? "IN" : "OUT"));
        if (connection <= 0) {
            IdentifiedConnectionState<T> conState = this.outIdConnections.get(peerIdB);
            if (conState != null) {
                this.sendOutConMessage(conState, msg);
            } else {
                this.listener.messageFailed(msg, Optional.empty(), peerIdentity, new IllegalArgumentException("No outgoing connection"));
            }
        } else if (connection == 1) {
            List<Pair<Connection<T>, Host>> inCons = this.inIdConnections.get(Bytes.of(peerIdentity));
            if (inCons != null) {
                assert (!inCons.isEmpty());
                Pair<Connection<T>, Host> conAndHost = inCons.getLast();
                this.sendWithListener(msg, conAndHost.getRight(), peerIdentity, conAndHost.getLeft());
            } else {
                this.listener.messageFailed(msg, Optional.empty(), peerIdentity, new IllegalArgumentException("No incoming connection"));
            }
        } else {
            this.listener.messageFailed(msg, Optional.empty(), peerIdentity, new IllegalArgumentException("Invalid connection: " + connection));
            logger.error("Invalid sendMessage mode " + connection);
        }
    }

    private void sendOutConMessage(IdentifiedConnectionState<T> conState, T msg) {
        if (conState.isConnected()) {
            this.sendWithListener(msg, conState.getPeerListenAddress(), conState.getPeerId(), conState.getConnection());
        } else {
            conState.getQueue().add(msg);
        }
    }

    private void sendWithListener(T msg, Host peer, byte[] peerId, Connection<T> established) {
        Promise<Void> promise = this.loop.newPromise();
        promise.addListener(future -> {
            if (future.isSuccess() && this.triggerSent) {
                this.listener.messageSent(msg, peer, peerId);
            } else if (!future.isSuccess()) {
                this.listener.messageFailed(msg, Optional.of(peer), peerId, future.cause());
            }
        });
        established.sendMessage(msg, promise);
    }

    @Override
    protected void onOutboundConnectionUp(Connection<T> con) {
        IdentifiedConnectionState<T> conState = this.outConnections.get(con.getConnectionId());
        if (conState == null || conState.isConnected()) {
            throw new AssertionError((Object)"Connection up with no connection state or already connected state");
        }
        Host peerHost = conState.getPeerListenAddress();
        byte[] peerId = conState.getPeerId();
        Bytes peerIdB = Bytes.of(peerId);
        if (peerId == null) {
            peerId = con.getPeerAttributes().getBytes("identity");
            if (peerId == null) {
                throw new AssertionError((Object)"Outbound connection up with no peer id.");
            }
            conState.setPeerId(peerId);
            peerIdB = Bytes.of(peerId);
            IdentifiedConnectionState<T> existingCon = this.outIdConnections.put(peerIdB, conState);
            if (existingCon != null) {
                if (existingCon.isConnected()) {
                    logger.debug("Repeated out connection to peer {} ({})", (Object)peerIdB, (Object)peerHost);
                    this.outIdConnections.put(peerIdB, existingCon);
                    this.removeHostConnectionId(peerHost, conState.getConnectionId());
                    con.disconnect();
                    this.listener.deliverEvent(new SecureOutConnectionFailed<T>(peerHost, peerId, conState.getQueue(), (Throwable)new IllegalStateException("Repeated out connection to peer " + String.valueOf(peerIdB))));
                    return;
                }
                this.removeHostConnectionId(existingCon.getPeerListenAddress(), existingCon.getConnectionId());
                this.outConnections.remove(existingCon.getConnectionId());
            }
        }
        logger.debug("OutboundConnectionUp {} ({})", (Object)peerHost, (Object)peerIdB);
        if (conState.isConnected()) {
            throw new AssertionError((Object)("ConnectionUp in already connected state: " + String.valueOf(con)));
        }
        conState.setConnected();
        for (Object msg : conState.getQueue()) {
            this.sendWithListener(msg, peerHost, peerId, con);
        }
        conState.getQueue().clear();
        this.listener.deliverEvent(new SecureOutConnectionUp(peerHost, peerId));
    }

    @Override
    protected void onCloseConnection(Host peer, int connection) {
        logger.debug("onCloseConnection {}. Closing all out connections to host...", (Object)peer);
        List<IdentifiedConnectionState<T>> connections = this.outHostConnections.remove(peer);
        if (connections != null) {
            for (IdentifiedConnectionState<T> conState : connections) {
                this.outIdConnections.remove(Bytes.of(conState.getPeerId()));
                this.outConnections.remove(conState.getConnectionId());
                conState.disconnect();
            }
        }
    }

    @Override
    protected void onCloseConnection(byte[] peerId, int connection) {
        Bytes peerIdB = Bytes.of(peerId);
        logger.debug("onCloseConnection " + String.valueOf(peerIdB));
        IdentifiedConnectionState<T> conState = this.outIdConnections.remove(peerIdB);
        if (conState != null) {
            this.removeHostIdConnection(conState.getPeerListenAddress(), peerId);
            this.outConnections.remove(conState.getConnectionId());
            conState.disconnect();
        }
    }

    @Override
    protected void onOutboundConnectionDown(Connection<T> con, Throwable cause) {
        logger.debug("onOutboundConnectionDown {}" + String.valueOf(con.getPeer()) + (String)(cause != null ? " " + String.valueOf(cause) : ""));
        IdentifiedConnectionState<T> conState = this.outConnections.remove(con.getConnectionId());
        if (conState == null) {
            return;
        }
        byte[] peerId = conState.getPeerId();
        if (peerId != null) {
            this.outIdConnections.remove(Bytes.of(peerId));
            this.removeHostIdConnection(conState.getPeerListenAddress(), peerId);
        }
        this.listener.deliverEvent(new SecureOutConnectionDown(conState.getPeerListenAddress(), conState.getPeerId(), cause));
    }

    @Override
    protected void onOutboundConnectionFailed(Connection<T> conn, Throwable cause) {
        IdentifiedConnectionState<T> conState = this.outConnections.remove(conn.getConnectionId());
        if (conState == null) {
            return;
        }
        Bytes peerIdB = Bytes.of(conState.getPeerId());
        logger.debug("OutboundConnectionFailed {} ({}){}", (Object)conn.getPeer(), (Object)peerIdB, cause != null ? " " + String.valueOf(cause) : "");
        if (peerIdB != null) {
            this.outIdConnections.remove(peerIdB);
            this.removeHostIdConnection(conState.getPeerListenAddress(), peerIdB.array());
        }
        this.listener.deliverEvent(new SecureOutConnectionFailed<T>(conn.getPeer(), conState.getPeerId(), conState.getQueue(), cause));
    }

    @Override
    protected void onInboundConnectionUp(Connection<T> con) {
        Host clientSocket;
        try {
            clientSocket = con.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTR);
            if (clientSocket == null) {
                con.disconnect();
                throw new AssertionError((Object)"Inbound connection without listen address in connectionUp");
            }
        }
        catch (IOException e) {
            con.disconnect();
            throw new AssertionError((Object)("Inbound connection without valid listen address in connectionUp: " + e.getMessage()));
        }
        byte[] peerId = con.getPeerAttributes().getBytes("identity");
        assert (peerId != null);
        Bytes peerIdB = Bytes.of(peerId);
        List idConList = this.inIdConnections.computeIfAbsent(peerIdB, k -> new LinkedList());
        idConList.add(Pair.of(con, clientSocket));
        List hostConList = this.inHostConnections.computeIfAbsent(clientSocket, k -> new LinkedList());
        hostConList.add(Pair.of(con, peerId));
        if (idConList.size() == 1 || hostConList.size() == 1) {
            logger.debug("InboundConnectionUp {} ({})", (Object)clientSocket, (Object)peerIdB);
            this.listener.deliverEvent(new SecureInConnectionUp(clientSocket, peerId));
        } else {
            logger.debug("Multiple InboundConnectionUp with {} ({})", (Object)clientSocket, (Object)peerIdB);
        }
    }

    @Override
    protected void onInboundConnectionDown(Connection<T> con, Throwable cause) {
        Host serverSocket;
        try {
            serverSocket = con.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTR);
        }
        catch (IOException e) {
            con.disconnect();
            throw new AssertionError((Object)("Inbound connection without valid listen address in connectionUp: " + e.getMessage()));
        }
        byte[] peerId = con.getPeerAttributes().getBytes("identity");
        assert (peerId != null);
        Bytes peerIdB = Bytes.of(peerId);
        List<Pair<Connection<T>, Host>> idConList = this.inIdConnections.get(peerIdB);
        List<Pair<Connection<T>, byte[]>> hostConList = this.inHostConnections.get(serverSocket);
        if (idConList == null || idConList.isEmpty() || hostConList == null || hostConList.isEmpty()) {
            throw new AssertionError((Object)("No connections in InboundConnectionDown " + String.valueOf(serverSocket) + " (" + String.valueOf(peerIdB) + ")"));
        }
        Iterator<Pair<Connection<T>, Host>> idConIt = idConList.iterator();
        while (idConIt.hasNext() && !idConIt.next().getRight().equals(serverSocket)) {
        }
        idConIt.remove();
        Iterator<Pair<Connection<T>, byte[]>> hostConIt = hostConList.iterator();
        while (hostConIt.hasNext() && !Arrays.equals(hostConIt.next().getRight(), peerId)) {
        }
        hostConIt.remove();
        if (idConList.isEmpty() || hostConList.isEmpty()) {
            logger.debug(() -> "InboundConnectionDown %s (%s)%s".formatted(serverSocket, peerIdB, cause != null ? " " + String.valueOf(cause) : ""));
            if (idConList.isEmpty()) {
                this.inIdConnections.remove(peerIdB);
            }
            if (hostConList.isEmpty()) {
                this.inHostConnections.remove(serverSocket);
            }
            this.listener.deliverEvent(new SecureInConnectionDown(serverSocket, peerId, cause));
        } else {
            logger.debug("Extra InboundConnectionDown {}: {} or {}: {} remaining", (Object)serverSocket, (Object)hostConList.size(), (Object)peerIdB, (Object)idConList.size());
        }
        if (this.metrics) {
            this.oldIn.add(Pair.of(serverSocket, con));
        }
    }

    @Override
    public void onServerSocketBind(boolean success, Throwable cause) {
        if (success) {
            logger.debug("Server socket ready");
        } else {
            logger.error("Server socket bind failed: " + String.valueOf(cause));
        }
    }

    @Override
    public void onServerSocketClose(boolean success, Throwable cause) {
        logger.debug("Server socket closed. " + (String)(success ? "" : "Cause: " + String.valueOf(cause)));
    }

    @Override
    public void onDeliverMessage(T msg, Connection<T> conn) {
        byte[] peerId = conn.getPeerAttributes().getBytes("identity");
        assert (peerId != null);
        Host host = conn.getPeer();
        if (conn.isInbound()) {
            try {
                host = conn.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTR);
            }
            catch (IOException e) {
                conn.disconnect();
                throw new AssertionError((Object)("Inbound connection without valid listen address in deliver message: " + e.getMessage()));
            }
        }
        logger.debug("DeliverMessage {} {} ({}) {}", (Object)msg, (Object)host, (Object)Bytes.of(peerId), (Object)(conn.isInbound() ? "IN" : "OUT"));
        this.listener.deliverMessage(msg, host, peerId);
    }
}

