/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.secure.weakauth;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import pt.unl.fct.di.novasys.channel.secure.SecureChannelListener;
import pt.unl.fct.di.novasys.channel.secure.SecureSingleThreadedBiChannel;
import pt.unl.fct.di.novasys.channel.secure.events.SecureInConnectionDown;
import pt.unl.fct.di.novasys.channel.secure.events.SecureInConnectionUp;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionDown;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionFailed;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionUp;
import pt.unl.fct.di.novasys.channel.secure.utils.X509CertificateSerializer;
import pt.unl.fct.di.novasys.channel.secure.weakauth.IdentifiedConnectionState;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.NetworkManager;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Bytes;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeAttributesException;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeException;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;
import pt.unl.fct.di.novasys.network.security.X509ITrustManager;

public class WeakAuthChannel<T>
extends SecureSingleThreadedBiChannel<T, T>
implements AttributeValidator {
    private static final Logger logger = LogManager.getLogger(WeakAuthChannel.class);
    public static final short CHANNEL_MAGIC_NUMBER = 21764;
    public static final String NAME = "WeakAuthChannel";
    public static final String ADDRESS_KEY = "address";
    public static final String PORT_KEY = "port";
    public static final String WORKER_GROUP_KEY = "worker_group";
    public static final String TRIGGER_SENT_KEY = "trigger_sent";
    public static final String METRICS_INTERVAL_KEY = "metrics_interval";
    public static final String HEARTBEAT_INTERVAL_KEY = "heartbeat_interval";
    public static final String HEARTBEAT_TOLERANCE_KEY = "heartbeat_tolerance";
    public static final String CONNECT_TIMEOUT_KEY = "connect_timeout";
    public static final String NONCE_SIZE_KEY = "nonce_length";
    public static final String LISTEN_ADDRESS_ATTR = "listen_address";
    public static final String DEFAULT_PORT = "9572";
    public static final String DEFAULT_HB_INTERVAL = "0";
    public static final String DEFAULT_HB_TOLERANCE = "0";
    public static final String DEFAULT_CONNECT_TIMEOUT = "1000";
    public static final String DEFAULT_METRICS_INTERVAL = "-1";
    public static final String DEFAULT_NONCE_SIZE = "8";
    public static final int CONNECTION_OUT = 0;
    public static final int CONNECTION_IN = 1;
    private static final byte HANDSHAKE_STEPS = 3;
    static final String DEFAULT_ASYM_KEY_ALG = "RSA";
    private final NetworkManager<T> network;
    private final SecureChannelListener<T> listener;
    private final Attributes baseAttributes;
    private final Map<Long, IdentifiedConnectionState<T>> outConnections;
    private final Map<Bytes, IdentifiedConnectionState<T>> outIdConnections;
    private final Map<Host, List<IdentifiedConnectionState<T>>> outHostConnections;
    private final Map<Bytes, List<Pair<Connection<T>, Host>>> inIdConnections;
    private final Map<Host, List<Pair<Connection<T>, byte[]>>> inHostConnections;
    private List<Pair<Host, Connection<T>>> oldIn;
    private List<Pair<Host, IdentifiedConnectionState<T>>> oldOUt;
    private final boolean triggerSent;
    private final boolean metrics;
    private final Provider securityProvider;
    private final SecureRandom nonceRng;
    private final int nonceSize;
    private final X509IKeyManager keyManager;
    private final X509ITrustManager trustManager;
    private static final String EXPECTED_ID_ATTR = "expected_identity";
    private static final String ID_ATTR = "identity";
    private static final String CERT_ATTR = "certificate";
    private static final String NONCE_ATTR = "nonce";
    private static final String SIG_NONCE_ATTR = "signed_nonce";

    public WeakAuthChannel(ISerializer<T> serializer, SecureChannelListener<T> list, Properties properties, X509IKeyManager keyManager, X509ITrustManager trustManager) throws IOException {
        super(NAME);
        SecureRandom rng;
        this.listener = list;
        this.securityProvider = new BouncyCastleProvider();
        try {
            rng = SecureRandom.getInstance("NonceAndIV", this.securityProvider);
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Failed to get \"NonceAndIV\" secure random");
            rng = new SecureRandom();
        }
        this.nonceRng = rng;
        this.keyManager = keyManager;
        this.trustManager = trustManager;
        if (!properties.containsKey(ADDRESS_KEY)) {
            throw new IllegalArgumentException("WeakAuthChannel requires binding address");
        }
        InetAddress addr = Inet4Address.getByName(properties.getProperty(ADDRESS_KEY));
        int port = Integer.parseInt(properties.getProperty(PORT_KEY, DEFAULT_PORT));
        int hbInterval = Integer.parseInt(properties.getProperty(HEARTBEAT_INTERVAL_KEY, "0"));
        int hbTolerance = Integer.parseInt(properties.getProperty(HEARTBEAT_TOLERANCE_KEY, "0"));
        int connTimeout = Integer.parseInt(properties.getProperty(CONNECT_TIMEOUT_KEY, DEFAULT_CONNECT_TIMEOUT));
        int metricsInterval = Integer.parseInt(properties.getProperty(METRICS_INTERVAL_KEY, DEFAULT_METRICS_INTERVAL));
        this.triggerSent = Boolean.parseBoolean(properties.getProperty(TRIGGER_SENT_KEY, "false"));
        this.metrics = metricsInterval > 0;
        this.nonceSize = Integer.parseInt(properties.getProperty(NONCE_SIZE_KEY, DEFAULT_NONCE_SIZE));
        Host listenAddress = new Host(addr, port);
        EventLoopGroup eventExecutors = properties.containsKey(WORKER_GROUP_KEY) ? (EventLoopGroup)properties.get(WORKER_GROUP_KEY) : NetworkManager.createNewWorkerGroup();
        this.baseAttributes = new Attributes();
        this.baseAttributes.putShort("magic_number", (short)21764);
        this.baseAttributes.putHost(LISTEN_ADDRESS_ATTR, listenAddress);
        this.network = new NetworkManager<T>(3, serializer, this, hbInterval, hbTolerance, connTimeout, eventExecutors);
        this.network.createServerSocket(this, listenAddress, this.baseAttributes, (AttributeValidator)this, eventExecutors);
        this.outConnections = new HashMap<Long, IdentifiedConnectionState<T>>();
        this.outHostConnections = new HashMap<Host, List<IdentifiedConnectionState<T>>>();
        this.outIdConnections = new HashMap<Bytes, IdentifiedConnectionState<T>>();
        this.inIdConnections = new HashMap<Bytes, List<Pair<Connection<T>, Host>>>();
        this.inHostConnections = new HashMap<Host, List<Pair<Connection<T>, byte[]>>>();
        if (this.metrics) {
            this.oldIn = new LinkedList<Pair<Host, Connection<T>>>();
            this.oldOUt = new LinkedList<Pair<Host, IdentifiedConnectionState<T>>>();
            this.loop.scheduleAtFixedRate(this::triggerMetricsEvent, metricsInterval, metricsInterval, TimeUnit.MILLISECONDS);
        }
    }

    void triggerMetricsEvent() {
    }

    @Override
    public boolean validateAttributes(Attributes attr) {
        Short channel = attr.getShort("magic_number");
        return channel != null && channel == 21764;
    }

    private Attributes getFirstHandshakeAttributes(byte[] expectedId) throws CertificateException {
        String idAlias;
        Attributes attrs = this.baseAttributes.shallowClone();
        if (expectedId != null) {
            attrs.putBytes(EXPECTED_ID_ATTR, expectedId);
        }
        if ((idAlias = this.keyManager.chooseServerAlias(DEFAULT_ASYM_KEY_ALG, null, null)) == null) {
            idAlias = this.keyManager.chooseServerAlias(null, null, null);
        }
        byte[] id = this.keyManager.getAliasId(idAlias);
        attrs.putBytes(ID_ATTR, id);
        X509Certificate cert = this.keyManager.getCertificateChain(idAlias)[0];
        try {
            attrs.putObject(CERT_ATTR, cert, X509CertificateSerializer.INSTANCE);
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
        byte[] nonce = new byte[this.nonceSize];
        this.nonceRng.nextBytes(nonce);
        attrs.putBytes(NONCE_ATTR, nonce);
        return attrs;
    }

    @Override
    public Attributes getSecondHandshakeAttributes(long channelId, Attributes peerAttrs, Attributes myBaseAttrs) throws InvalidHandshakeAttributesException {
        try {
            return (Attributes)this.loop.submit(() -> this.onGetSecondHandshakeAttributes(channelId, peerAttrs, myBaseAttrs)).get();
        }
        catch (ExecutionException e) {
            throw (InvalidHandshakeAttributesException)e.getCause();
        }
        catch (InterruptedException e) {
            throw new InvalidHandshakeAttributesException(peerAttrs, 1, (Throwable)e);
        }
    }

    public Attributes onGetSecondHandshakeAttributes(long channelId, Attributes peerAttrs, Attributes myBaseAttrs) throws InvalidHandshakeAttributesException {
        if (!this.validateAttributes(peerAttrs)) {
            throw new InvalidHandshakeAttributesException(peerAttrs, 1);
        }
        try {
            PrivateKey privKey;
            X509Certificate myCert;
            X509Certificate peerCert = peerAttrs.getObject(CERT_ATTR, X509CertificateSerializer.INSTANCE);
            byte[] peerId = this.trustManager.extractIdFromCertificate(peerCert);
            if (!Arrays.equals(peerId, peerAttrs.getBytes(ID_ATTR))) {
                logger.debug("In connection attribute validation failed: peer id in attributes ({}) differs from the one extracted from certificate ({})", (Object)Bytes.of(peerId), (Object)Bytes.of(peerAttrs.getBytes(ID_ATTR)));
                throw new InvalidHandshakeAttributesException(peerAttrs, 1);
            }
            this.trustManager.checkClientTrusted(new X509Certificate[]{peerCert}, peerCert.getSigAlgName());
            Attributes replyAttrs = myBaseAttrs.shallowClone();
            byte[] myId = peerAttrs.getBytes(EXPECTED_ID_ATTR);
            if (myId != null) {
                myCert = this.keyManager.getCertificateChain(myId)[0];
                privKey = this.keyManager.getPrivateKey(myId);
            } else {
                String alias = this.keyManager.chooseServerAlias(DEFAULT_ASYM_KEY_ALG, null, null);
                if (alias == null) {
                    alias = this.keyManager.chooseServerAlias(DEFAULT_ASYM_KEY_ALG, null, null);
                }
                myId = this.keyManager.getAliasId(alias);
                myCert = this.keyManager.getCertificateChain(alias)[0];
                privKey = this.keyManager.getPrivateKey(alias);
            }
            replyAttrs.putBytes(ID_ATTR, myId);
            replyAttrs.putObject(CERT_ATTR, myCert, X509CertificateSerializer.INSTANCE);
            byte[] signedNonce = this.signNonce(peerAttrs.getBytes(NONCE_ATTR), myCert, privKey);
            replyAttrs.putBytes(SIG_NONCE_ATTR, signedNonce);
            byte[] nonce = new byte[this.nonceSize];
            this.nonceRng.nextBytes(nonce);
            replyAttrs.putBytes(NONCE_ATTR, nonce);
            return replyAttrs;
        }
        catch (IOException | NullPointerException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException e) {
            throw new InvalidHandshakeAttributesException(peerAttrs, 1, (Throwable)e);
        }
    }

    private byte[] signNonce(byte[] nonce, X509Certificate myCert, PrivateKey privKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(myCert.getSigAlgName(), this.securityProvider);
        signature.initSign(privKey);
        signature.update(nonce);
        return signature.sign();
    }

    @Override
    public Attributes getNthHandshakeAttributes(long connectionId, int handshakeN, List<Attributes> peerAttrs, List<Attributes> mySentAttrs) throws InvalidHandshakeAttributesException {
        try {
            return (Attributes)this.loop.submit(() -> this.onGetNthHandshakeAttributes(connectionId, handshakeN, peerAttrs, mySentAttrs)).get();
        }
        catch (ExecutionException e) {
            throw (InvalidHandshakeAttributesException)e.getCause();
        }
        catch (InterruptedException e) {
            throw new InvalidHandshakeAttributesException(peerAttrs.getLast(), handshakeN - 1, (Throwable)e);
        }
    }

    public Attributes onGetNthHandshakeAttributes(long connectionId, int handshakeN, List<Attributes> peerAttrs, List<Attributes> mySentAttrs) throws InvalidHandshakeAttributesException {
        IdentifiedConnectionState<T> conState = this.outConnections.get(connectionId);
        try {
            if (handshakeN == 3) {
                Attributes firstHsAttrs = mySentAttrs.getFirst();
                Attributes secondHsAttrs = peerAttrs.getFirst();
                byte[] peerId = secondHsAttrs.getBytes(ID_ATTR);
                if (conState.getPeerId() != null && !Arrays.equals(peerId, conState.getPeerId())) {
                    throw new InvalidHandshakeAttributesException(secondHsAttrs, "Handshake step 2: peer id was different from the expected id");
                }
                X509Certificate peerCert = secondHsAttrs.getObject(CERT_ATTR, X509CertificateSerializer.INSTANCE);
                if (!Arrays.equals(peerId, this.trustManager.extractIdFromCertificate(peerCert))) {
                    logger.debug("Out connection attribute validation failed: peer id in attributes ({}) differs from the one extracted from certificate ({})", (Object)Bytes.of(peerId), (Object)Bytes.of(secondHsAttrs.getBytes(ID_ATTR)));
                    throw new InvalidHandshakeAttributesException(secondHsAttrs, "Handshake step 2: peer id was different from the one exctracted from certificate");
                }
                this.trustManager.checkClientTrusted(new X509Certificate[]{peerCert}, peerCert.getSigAlgName());
                byte[] sentNonce = firstHsAttrs.getBytes(NONCE_ATTR);
                byte[] recvdSignedNonce = secondHsAttrs.getBytes(SIG_NONCE_ATTR);
                Signature sig = Signature.getInstance(peerCert.getSigAlgName(), this.securityProvider);
                sig.initVerify(peerCert.getPublicKey());
                sig.update(sentNonce);
                if (!sig.verify(recvdSignedNonce)) {
                    logger.debug("Out connection attribute validation failed: sent nonce wasn't correctly signed.");
                    throw new InvalidHandshakeAttributesException(secondHsAttrs, "Handshake step 2: invalid nonce signature");
                }
                if (conState.getPeerId() == null) {
                    this.outIdConnections.put(Bytes.of(peerId), conState);
                } else if (this.outIdConnections.get(Bytes.of(peerId)).isAuthenticated()) {
                    throw new InvalidHandshakeException("Handshake step 2: repeated connection to peer");
                }
                conState.setPeerId(peerId);
                conState.setAuthenticated();
                Attributes attrs = new Attributes();
                byte[] myId = firstHsAttrs.getBytes(ID_ATTR);
                byte[] signedNonce = this.signNonce(secondHsAttrs.getBytes(NONCE_ATTR), this.keyManager.getCertificateChain(myId)[0], this.keyManager.getPrivateKey(myId));
                attrs.putBytes(SIG_NONCE_ATTR, signedNonce);
                return attrs;
            }
            if (handshakeN == 4) {
                Attributes firstHsAttrs = peerAttrs.getFirst();
                Attributes thirdHsAttrs = peerAttrs.getLast();
                X509Certificate peerCert = firstHsAttrs.getObject(CERT_ATTR, X509CertificateSerializer.INSTANCE);
                byte[] sentNonce = mySentAttrs.getFirst().getBytes(NONCE_ATTR);
                byte[] recvdSignedNonce = thirdHsAttrs.getBytes(SIG_NONCE_ATTR);
                Signature sig = Signature.getInstance(peerCert.getSigAlgName(), this.securityProvider);
                sig.initVerify(peerCert.getPublicKey());
                sig.update(sentNonce);
                if (!sig.verify(recvdSignedNonce)) {
                    logger.debug("In connection attribute validation failed: sent nonce wasn't correctly signed.");
                    throw new InvalidHandshakeAttributesException(thirdHsAttrs, 3);
                }
                return Attributes.EMPTY;
            }
            throw new InvalidHandshakeAttributesException(peerAttrs.getLast(), handshakeN - 1);
        }
        catch (Exception e) {
            if (e instanceof InvalidHandshakeAttributesException) {
                InvalidHandshakeAttributesException hsEx = (InvalidHandshakeAttributesException)e;
                throw hsEx;
            }
            throw new InvalidHandshakeAttributesException(peerAttrs.getLast(), handshakeN - 1, (Throwable)e);
        }
    }

    private IdentifiedConnectionState<T> removeHostIdConnection(Host host, byte[] peerId) {
        List<IdentifiedConnectionState<T>> hostCons = this.outHostConnections.get(host);
        Iterator<IdentifiedConnectionState<T>> it = hostCons.iterator();
        while (it.hasNext()) {
            IdentifiedConnectionState<T> conState = it.next();
            if (!Arrays.equals(conState.getPeerId(), peerId)) continue;
            it.remove();
            return conState;
        }
        return null;
    }

    @Override
    protected void onOpenConnection(Host peer, int connection) {
        List<IdentifiedConnectionState<T>> connections = this.outHostConnections.get(peer);
        if (connections == null) {
            try {
                logger.debug("onOpenConnection creating connection to: " + String.valueOf(peer));
                Attributes firstHsAttrs = this.getFirstHandshakeAttributes(null);
                IdentifiedConnectionState<T> conState = new IdentifiedConnectionState<T>(this.network.createConnection(peer, firstHsAttrs, this, this), peer);
                connections = new LinkedList<IdentifiedConnectionState<T>>();
                connections.add(conState);
                this.outHostConnections.put(peer, connections);
                this.outConnections.put(conState.getConnectionId(), conState);
            }
            catch (CertificateException e) {
                logger.error("onOpenConnection to {} failed with exception {}", (Object)peer, (Object)e);
                this.listener.deliverEvent(new OutConnectionFailed(peer, new LinkedList(), e));
            }
        } else {
            logger.debug("onOpenConnection ignored: " + String.valueOf(peer));
        }
    }

    @Override
    protected void onOpenConnection(Host peer, byte[] expectedId, int connection) {
        Bytes expectedIdB = Bytes.of(expectedId);
        IdentifiedConnectionState<T> conState = this.outIdConnections.get(expectedIdB);
        if (conState == null) {
            try {
                logger.debug("onOpenConnection creating connection to {} ({})", (Object)peer, (Object)expectedIdB);
                Attributes attrs = this.getFirstHandshakeAttributes(expectedId);
                conState = new IdentifiedConnectionState<T>(this.network.createConnection(peer, attrs, this, this), peer);
                conState.setPeerId(expectedId);
                this.outIdConnections.put(expectedIdB, conState);
                this.outHostConnections.computeIfAbsent(peer, __ -> new LinkedList()).add(conState);
                this.outConnections.put(conState.getConnectionId(), conState);
            }
            catch (CertificateException e) {
                logger.error("onOpenConnection to {} ({}) failed with exception {}", (Object)peer, (Object)expectedIdB, (Object)e);
                this.listener.deliverEvent(new SecureOutConnectionFailed(peer, expectedId, new LinkedList(), (Throwable)e));
            }
        } else {
            logger.debug("onOpenConnection ignored: {} ({})", (Object)peer, (Object)expectedId);
        }
    }

    @Override
    protected void onSendMessage(T msg, Host peer, int connection) {
        logger.debug("onSendMessage " + String.valueOf(msg) + " " + String.valueOf(peer) + " " + (connection == 1 ? "IN" : "OUT"));
        if (connection <= 0) {
            List<IdentifiedConnectionState<T>> conList = this.outHostConnections.get(peer);
            if (conList != null) {
                assert (!conList.isEmpty());
                this.sendOutConMessage(conList.getLast(), msg);
            } else {
                this.listener.messageFailed(msg, peer, new IllegalArgumentException("No outgoing connection"));
            }
        } else if (connection == 1) {
            List<Pair<Connection<T>, byte[]>> inCons = this.inHostConnections.get(peer);
            if (inCons != null) {
                assert (!inCons.isEmpty());
                Pair<Connection<T>, byte[]> conAndId = inCons.getLast();
                this.sendWithListener(msg, peer, conAndId.getRight(), conAndId.getLeft());
            } else {
                this.listener.messageFailed(msg, peer, new IllegalArgumentException("No incoming connection"));
            }
        } else {
            this.listener.messageFailed(msg, peer, new IllegalArgumentException("Invalid connection: " + connection));
            logger.error("Invalid sendMessage mode " + connection);
        }
    }

    @Override
    protected void onSendMessage(T msg, byte[] peerIdentity, int connection) {
        Bytes peerIdB = Bytes.of(peerIdentity);
        logger.debug("onSendMessage {} to {} {}", (Object)msg, (Object)peerIdB, (Object)(connection == 1 ? "IN" : "OUT"));
        if (connection <= 0) {
            IdentifiedConnectionState<T> conState = this.outIdConnections.get(peerIdB);
            if (conState != null) {
                this.sendOutConMessage(conState, msg);
            } else {
                this.listener.messageFailed(msg, Optional.empty(), peerIdentity, new IllegalArgumentException("No outgoing connection"));
            }
        } else if (connection == 1) {
            List<Pair<Connection<T>, Host>> inCons = this.inIdConnections.get(Bytes.of(peerIdentity));
            if (inCons != null) {
                assert (!inCons.isEmpty());
                Pair<Connection<T>, Host> conAndHost = inCons.getLast();
                this.sendWithListener(msg, conAndHost.getRight(), peerIdentity, conAndHost.getLeft());
            } else {
                this.listener.messageFailed(msg, Optional.empty(), peerIdentity, new IllegalArgumentException("No incoming connection"));
            }
        } else {
            this.listener.messageFailed(msg, Optional.empty(), peerIdentity, new IllegalArgumentException("Invalid connection: " + connection));
            logger.error("Invalid sendMessage mode " + connection);
        }
    }

    private void sendOutConMessage(IdentifiedConnectionState<T> conState, T msg) {
        if (conState.isConnected()) {
            this.sendWithListener(msg, conState.getPeerListenAddress(), conState.getPeerId(), conState.getConnection());
        } else {
            conState.getQueue().add(msg);
        }
    }

    private void sendWithListener(T msg, Host peer, byte[] peerId, Connection<T> established) {
        Promise<Void> promise = this.loop.newPromise();
        promise.addListener(future -> {
            if (future.isSuccess() && this.triggerSent) {
                this.listener.messageSent(msg, peer, peerId);
            } else if (!future.isSuccess()) {
                this.listener.messageFailed(msg, Optional.of(peer), peerId, future.cause());
            }
        });
        established.sendMessage(msg, promise);
    }

    @Override
    protected void onOutboundConnectionUp(Connection<T> con) {
        IdentifiedConnectionState<T> conState = this.outConnections.get(con.getConnectionId());
        if (conState == null || !conState.isAuthenticated()) {
            throw new AssertionError((Object)"Connection up with no authenticated connection state");
        }
        Host peerHost = conState.getPeerListenAddress();
        byte[] peerId = conState.getPeerId();
        Bytes peerIdB = Bytes.of(peerId);
        logger.debug("OutboundConnectionUp {} ({})", (Object)peerHost, (Object)peerIdB);
        this.outIdConnections.put(peerIdB, conState);
        if (conState.isConnected()) {
            throw new AssertionError((Object)("ConnectionUp in CONNECTED state: " + String.valueOf(con)));
        }
        conState.setConnected();
        conState.getQueue().forEach(m4 -> this.sendWithListener(m4, peerHost, peerId, con));
        conState.getQueue().clear();
        this.listener.deliverEvent(new SecureOutConnectionUp(peerHost, peerId));
    }

    @Override
    protected void onCloseConnection(Host peer, int connection) {
        logger.debug("onCloseConnection {}. Closing all out connections to host...", (Object)peer);
        List<IdentifiedConnectionState<T>> connections = this.outHostConnections.remove(peer);
        if (connections != null) {
            for (IdentifiedConnectionState<T> conState : connections) {
                this.outIdConnections.remove(Bytes.of(conState.getPeerId()));
                this.outConnections.remove(conState.getConnectionId());
                conState.disconnect();
            }
        }
    }

    @Override
    protected void onCloseConnection(byte[] peerId, int connection) {
        Bytes peerIdB = Bytes.of(peerId);
        logger.debug("onCloseConnection " + String.valueOf(peerIdB));
        IdentifiedConnectionState<T> conState = this.outIdConnections.remove(peerIdB);
        if (conState != null) {
            this.removeHostIdConnection(conState.getPeerListenAddress(), peerId);
            this.outConnections.remove(conState.getConnectionId());
            conState.disconnect();
        }
    }

    @Override
    protected void onOutboundConnectionDown(Connection<T> con, Throwable cause) {
        logger.debug("onOutboundConnectionDown {}" + String.valueOf(con.getPeer()) + (String)(cause != null ? " " + String.valueOf(cause) : ""));
        IdentifiedConnectionState<T> conState = this.outConnections.remove(con.getConnectionId());
        if (conState != null) {
            byte[] peerId = conState.getPeerId();
            if (peerId != null) {
                this.outIdConnections.remove(Bytes.of(peerId));
                this.removeHostIdConnection(conState.getPeerListenAddress(), peerId);
            }
            this.listener.deliverEvent(new SecureOutConnectionDown(conState.getPeerListenAddress(), conState.getPeerId(), cause));
        }
    }

    @Override
    protected void onOutboundConnectionFailed(Connection<T> conn, Throwable cause) {
        IdentifiedConnectionState<T> conState = this.outConnections.remove(conn.getConnectionId());
        if (conState == null) {
            return;
        }
        Bytes peerIdB = Bytes.of(conState.getPeerId());
        logger.debug("OutboundConnectionFailed {} ({}){}", (Object)conn.getPeer(), (Object)peerIdB, cause != null ? " " + String.valueOf(cause) : "");
        if (peerIdB != null) {
            this.outIdConnections.remove(peerIdB);
            this.removeHostIdConnection(conState.getPeerListenAddress(), peerIdB.array());
        }
        this.listener.deliverEvent(new SecureOutConnectionFailed<T>(conn.getPeer(), conState.getPeerId(), conState.getQueue(), cause));
    }

    @Override
    protected void onInboundConnectionUp(Connection<T> con) {
        Host clientSocket;
        try {
            clientSocket = con.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTR);
        }
        catch (IOException e) {
            con.disconnect();
            throw new AssertionError((Object)("Inbound connection without valid listen address in connectionUp: " + e.getMessage()));
        }
        byte[] peerId = con.getPeerAttributes().getBytes(ID_ATTR);
        assert (peerId != null);
        Bytes peerIdB = Bytes.of(peerId);
        List idConList = this.inIdConnections.computeIfAbsent(peerIdB, k -> new LinkedList());
        idConList.add(Pair.of(con, clientSocket));
        List hostConList = this.inHostConnections.computeIfAbsent(clientSocket, k -> new LinkedList());
        hostConList.add(Pair.of(con, peerId));
        if (idConList.size() == 1 || hostConList.size() == 1) {
            logger.debug("InboundConnectionUp {} ({})", (Object)clientSocket, (Object)peerIdB);
            this.listener.deliverEvent(new SecureInConnectionUp(clientSocket, peerId));
        } else {
            logger.debug("Multiple InboundConnectionUp with {} ({})", (Object)clientSocket, (Object)peerIdB);
        }
    }

    @Override
    protected void onInboundConnectionDown(Connection<T> con, Throwable cause) {
        Host serverSocket;
        try {
            serverSocket = con.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTR);
        }
        catch (IOException e) {
            con.disconnect();
            throw new AssertionError((Object)("Inbound connection without valid listen address in connectionUp: " + e.getMessage()));
        }
        byte[] peerId = con.getPeerAttributes().getBytes(ID_ATTR);
        assert (peerId != null);
        Bytes peerIdB = Bytes.of(peerId);
        List<Pair<Connection<T>, Host>> idConList = this.inIdConnections.get(peerIdB);
        List<Pair<Connection<T>, byte[]>> hostConList = this.inHostConnections.get(serverSocket);
        if (idConList == null || idConList.isEmpty() || hostConList == null || hostConList.isEmpty()) {
            throw new AssertionError((Object)("No connections in InboundConnectionDown " + String.valueOf(serverSocket) + " (" + String.valueOf(peerIdB) + ")"));
        }
        Iterator<Pair<Connection<T>, Host>> idConIt = idConList.iterator();
        while (idConIt.hasNext() && !idConIt.next().getRight().equals(serverSocket)) {
        }
        idConIt.remove();
        Iterator<Pair<Connection<T>, byte[]>> hostConIt = hostConList.iterator();
        while (hostConIt.hasNext() && !Arrays.equals(hostConIt.next().getRight(), peerId)) {
        }
        hostConIt.remove();
        if (idConList.isEmpty() || hostConList.isEmpty()) {
            logger.debug(() -> "InboundConnectionDown %s (%s)%s".formatted(serverSocket, peerIdB, cause != null ? " " + String.valueOf(cause) : ""));
            if (idConList.isEmpty()) {
                this.inIdConnections.remove(peerIdB);
            }
            if (hostConList.isEmpty()) {
                this.inHostConnections.remove(serverSocket);
            }
            this.listener.deliverEvent(new SecureInConnectionDown(serverSocket, peerId, cause));
        } else {
            logger.debug("Extra InboundConnectionDown {}: {} or {}: {} remaining", (Object)serverSocket, (Object)hostConList.size(), (Object)peerIdB, (Object)idConList.size());
        }
        if (this.metrics) {
            this.oldIn.add(Pair.of(serverSocket, con));
        }
    }

    @Override
    public void onServerSocketBind(boolean success, Throwable cause) {
        if (success) {
            logger.debug("Server socket ready");
        } else {
            logger.error("Server socket bind failed: " + String.valueOf(cause));
        }
    }

    @Override
    public void onServerSocketClose(boolean success, Throwable cause) {
        logger.debug("Server socket closed. " + (String)(success ? "" : "Cause: " + String.valueOf(cause)));
    }

    @Override
    public void onDeliverMessage(T msg, Connection<T> conn) {
        byte[] peerId = conn.getPeerAttributes().getBytes(ID_ATTR);
        assert (peerId != null);
        Host host = conn.getPeer();
        if (conn.isInbound()) {
            try {
                host = conn.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTR);
            }
            catch (IOException e) {
                conn.disconnect();
                throw new AssertionError((Object)("Inbound connection without valid listen address in deliver message: " + e.getMessage()));
            }
        }
        logger.debug("DeliverMessage {} {} ({}) {}", (Object)msg, (Object)host, (Object)(conn.isInbound() ? "IN" : "OUT"));
        this.listener.deliverMessage(msg, host, peerId);
    }
}

