/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.tcp.events;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import pt.unl.fct.di.novasys.channel.tcp.ConnectionState;
import pt.unl.fct.di.novasys.channel.tcp.events.TCPEvent;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.data.Host;

public class ChannelMetrics
extends TCPEvent {
    public static final short EVENT_ID = 6;
    List<ConnectionMetrics> inConnections = new LinkedList<ConnectionMetrics>();
    List<ConnectionMetrics> outConnections;
    List<ConnectionMetrics> oldInConnections;
    List<ConnectionMetrics> oldOutConnections;

    public <T> ChannelMetrics(List<Pair<Host, Connection<T>>> oldIn, List<Pair<Host, ConnectionState<T>>> oldOUt, Map<Host, LinkedList<Connection<T>>> in, Map<Host, ConnectionState<T>> out) {
        super((short)6);
        in.forEach((h2, v) -> v.forEach(c -> this.inConnections.add(new ConnectionMetrics((Host)h2, c.getReceivedAppBytes(), c.getSentAppBytes(), c.getReceivedControlBytes(), c.getSentControlBytes(), c.getReceivedAppMessages(), c.getSentAppMessages(), c.getReceivedControlMessages(), c.getSentControlMessages(), true))));
        this.outConnections = new LinkedList<ConnectionMetrics>();
        out.forEach((h2, cc) -> {
            Connection c = cc.getConnection();
            this.outConnections.add(new ConnectionMetrics((Host)h2, c.getReceivedAppBytes(), c.getSentAppBytes(), c.getReceivedControlBytes(), c.getSentControlBytes(), c.getReceivedAppMessages(), c.getSentAppMessages(), c.getReceivedControlMessages(), c.getSentControlMessages(), true));
        });
        this.oldInConnections = new LinkedList<ConnectionMetrics>();
        oldIn.forEach(p -> {
            Connection c = (Connection)p.getRight();
            this.oldInConnections.add(new ConnectionMetrics((Host)p.getLeft(), c.getReceivedAppBytes(), c.getSentAppBytes(), c.getReceivedControlBytes(), c.getSentControlBytes(), c.getReceivedAppMessages(), c.getSentAppMessages(), c.getReceivedControlMessages(), c.getSentControlMessages(), true));
        });
        this.oldOutConnections = new LinkedList<ConnectionMetrics>();
        oldOUt.forEach(p -> {
            Connection c = ((ConnectionState)p.getRight()).getConnection();
            this.oldOutConnections.add(new ConnectionMetrics((Host)p.getLeft(), c.getReceivedAppBytes(), c.getSentAppBytes(), c.getReceivedControlBytes(), c.getSentControlBytes(), c.getReceivedAppMessages(), c.getSentAppMessages(), c.getReceivedControlMessages(), c.getSentControlMessages(), true));
        });
    }

    public String toString() {
        return "ChannelMetrics{inConnections=" + String.valueOf(this.inConnections) + ", outConnections=" + String.valueOf(this.outConnections) + ", oldInConnections=" + String.valueOf(this.oldInConnections) + ", oldOutConnections=" + String.valueOf(this.oldOutConnections) + "}";
    }

    public List<ConnectionMetrics> getInConnections() {
        return this.inConnections;
    }

    public List<ConnectionMetrics> getOutConnections() {
        return this.outConnections;
    }

    public List<ConnectionMetrics> getOldInConnections() {
        return this.oldInConnections;
    }

    public List<ConnectionMetrics> getOldOutConnections() {
        return this.oldOutConnections;
    }

    public static class ConnectionMetrics {
        private final Host peer;
        private final long receivedAppBytes;
        private final long sentAppBytes;
        private final long receivedControlBytes;
        private final long sentControlBytes;
        private final long receivedAppMessages;
        private final long sentAppMessages;
        private final long receivedControlMessages;
        private final long sentControlMessages;
        private final boolean active;

        public ConnectionMetrics(Host peer, long receivedAppBytes, long sentAppBytes, long receivedControlBytes, long sentControlBytes, long receivedAppMessages, long sentAppMessages, long receivedControlMessages, long sentControlMessages, boolean active) {
            this.peer = peer;
            this.receivedAppBytes = receivedAppBytes;
            this.sentAppBytes = sentAppBytes;
            this.receivedControlBytes = receivedControlBytes;
            this.sentControlBytes = sentControlBytes;
            this.receivedAppMessages = receivedAppMessages;
            this.sentAppMessages = sentAppMessages;
            this.receivedControlMessages = receivedControlMessages;
            this.sentControlMessages = sentControlMessages;
            this.active = active;
        }

        public long getReceivedAppBytes() {
            return this.receivedAppBytes;
        }

        public long getSentAppBytes() {
            return this.sentAppBytes;
        }

        public long getReceivedControlBytes() {
            return this.receivedControlBytes;
        }

        public long getSentControlBytes() {
            return this.sentControlBytes;
        }

        public long getReceivedAppMessages() {
            return this.receivedAppMessages;
        }

        public long getSentAppMessages() {
            return this.sentAppMessages;
        }

        public long getReceivedControlMessages() {
            return this.receivedControlMessages;
        }

        public long getSentControlMessages() {
            return this.sentControlMessages;
        }

        public boolean isActive() {
            return this.active;
        }

        public Host getPeer() {
            return this.peer;
        }

        public String toString() {
            return "Metrics " + String.valueOf(this.peer) + "{ receivedAppBytes=" + this.receivedAppBytes + ", sentAppBytes=" + this.sentAppBytes + ", receivedControlBytes=" + this.receivedControlBytes + ", sentControlBytes=" + this.sentControlBytes + ", receivedAppMessages=" + this.receivedAppMessages + ", sentAppMessages=" + this.sentAppMessages + ", receivedControlMessages=" + this.receivedControlMessages + ", sentControlMessages=" + this.sentControlMessages + ", active=" + this.active + "}";
        }
    }
}

