/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.security;

import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import pt.unl.fct.di.novasys.network.security.X509SubKeyManager;

public abstract class X509IKeyManager
extends X509ExtendedKeyManager {
    public abstract X509Certificate[] getCertificateChain(byte[] var1);

    public abstract PrivateKey getPrivateKey(byte[] var1);

    public abstract String getIdAlias(byte[] var1);

    public abstract byte[] getAliasId(String var1);

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseClientAlias(keyType, issuers, null);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseServerAlias(keyType, issuers, null);
    }

    public X509IKeyManager subKeyManagerWithAliases(String ... aliases) {
        List<String> aliasList = Arrays.asList(aliases);
        return new X509SubKeyManager(this, aliasList, aliasList.stream().map(this::getAliasId).collect(Collectors.toList()));
    }

    public X509IKeyManager subKeyManagerWithIds(byte[] ... id) {
        List<byte[]> idList = Arrays.asList(id);
        return new X509SubKeyManager(this, idList.stream().map(this::getIdAlias).collect(Collectors.toList()), idList);
    }

    public X509IKeyManager subKeyManagerWithAliases(Collection<String> aliases) {
        return new X509SubKeyManager(this, aliases, aliases.stream().map(this::getAliasId).collect(Collectors.toList()));
    }

    public X509IKeyManager subKeyManagerWithIds(Collection<byte[]> ids) {
        return new X509SubKeyManager(this, ids.stream().map(this::getIdAlias).collect(Collectors.toList()), ids);
    }
}

