/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.security;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import pt.unl.fct.di.novasys.network.data.Bytes;
import pt.unl.fct.di.novasys.network.security.X509SingleTrustManager;

public abstract class X509ITrustManager
extends X509ExtendedTrustManager {
    public abstract void checkClientTrusted(X509Certificate[] var1, byte[] var2, String var3) throws CertificateException;

    public abstract void checkServerTrusted(X509Certificate[] var1, byte[] var2, String var3) throws CertificateException;

    public abstract byte[] extractIdFromCertificate(X509Certificate var1) throws CertificateException;

    public abstract Set<Bytes> getTrustedIds();

    public abstract void addTrustedId(byte[] var1);

    public abstract void removeTrustedId(byte[] var1);

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkClientTrusted(chain, authType);
    }

    public X509ITrustManager singleTrustManager(byte[] trustedId) {
        return new X509SingleTrustManager(this, trustedId);
    }
}

