/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.tls.pipeline;

import io.netty.channel.ChannelHandlerContext;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeAttributesException;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeException;
import pt.unl.fct.di.novasys.network.messaging.NetworkMessage;
import pt.unl.fct.di.novasys.network.messaging.control.FirstHandshakeMessage;
import pt.unl.fct.di.novasys.network.messaging.control.NthHandshakeMessage;
import pt.unl.fct.di.novasys.network.messaging.control.SecondHandshakeMessage;
import pt.unl.fct.di.novasys.network.pipeline.InHandshakeHandler;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;
import pt.unl.fct.di.novasys.network.tls.userevents.PreTLSHandshakeCompleted;

public class InPreTLSHandshakeHandler
extends InHandshakeHandler {
    private final X509IKeyManager identityChooser;

    public InPreTLSHandshakeHandler(long connectionId, AttributeValidator validator, Attributes baseAttrs, int handshakeSteps, X509IKeyManager identityChooser) {
        super(connectionId, validator, baseAttrs, handshakeSteps);
        this.identityChooser = identityChooser;
    }

    @Override
    protected void handleFirstHandshakeMessage(ChannelHandlerContext ctx, FirstHandshakeMessage fhm) throws InvalidHandshakeException {
        Attributes replyAttrs = this.validator.getSecondHandshakeAttributes(this.connectionId, fhm.attributes, this.baseAttrs);
        byte[] peerId = fhm.attributes.getBytes("identity");
        if (peerId == null) {
            throw new InvalidHandshakeAttributesException(fhm.attributes, "Peer didn't specify its identity");
        }
        byte[] chosenId = replyAttrs.getBytes("identity");
        if (replyAttrs.getBytes("identity") == null) {
            String idAlias;
            byte[] expectedId = fhm.attributes.getBytes("expected_identity");
            if (expectedId != null && this.identityChooser.getIdAlias(expectedId) != null) {
                chosenId = expectedId;
            }
            if (chosenId == null && (chosenId = this.identityChooser.getAliasId(idAlias = this.identityChooser.chooseServerAlias(null, null, null))) == null) {
                throw new InvalidHandshakeException("Couldn't choose identity for in connection.");
            }
            replyAttrs.putBytes("identity", chosenId);
        }
        if (this.handshakeSteps <= 2) {
            ctx.fireUserEventTriggered(this.handshakeCompletedEvent(fhm.attributes, chosenId, peerId));
            ctx.pipeline().remove(this);
        }
        this.peerAttrs.add(fhm.attributes);
        this.myAttrs.add(replyAttrs);
        ctx.channel().writeAndFlush(new NetworkMessage(0, new SecondHandshakeMessage(replyAttrs)));
    }

    private PreTLSHandshakeCompleted handshakeCompletedEvent(Attributes peerAttrs, byte[] chosenId, byte[] peerId) {
        return new PreTLSHandshakeCompleted(peerAttrs, chosenId, peerId);
    }

    @Override
    protected void handleNthHandshakeMessage(ChannelHandlerContext ctx, NthHandshakeMessage nhm) throws InvalidHandshakeException {
        throw new UnsupportedOperationException("TODO");
    }
}

