/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.tls.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.listeners.InConnListener;
import pt.unl.fct.di.novasys.network.listeners.MessageListener;
import pt.unl.fct.di.novasys.network.pipeline.InConnectionHandler;
import pt.unl.fct.di.novasys.network.pipeline.MessageDecoder;
import pt.unl.fct.di.novasys.network.pipeline.MessageEncoder;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;
import pt.unl.fct.di.novasys.network.security.X509ITrustManager;
import pt.unl.fct.di.novasys.network.tls.userevents.PreTLSHandshakeCompleted;

public class InTLSConnectionHandler<T>
extends InConnectionHandler<T> {
    private static final Logger logger = LogManager.getLogger(InTLSConnectionHandler.class);
    private X509IKeyManager keyManager;
    private X509ITrustManager trustManager;

    public InTLSConnectionHandler(long connectionId, InConnListener<T> listener, MessageListener<T> consumer, EventLoop loop, Attributes selfAttrs, MessageEncoder<T> encoder, MessageDecoder<T> decoder, X509IKeyManager keyManager, X509ITrustManager trustManager) {
        super(connectionId, listener, consumer, loop, selfAttrs, encoder, decoder);
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    @Override
    public void internalUserEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof PreTLSHandshakeCompleted) {
            PreTLSHandshakeCompleted hsEvt = (PreTLSHandshakeCompleted)evt;
            this.peerAttributes = hsEvt.getAttr();
            logger.debug("Pre TLS in handshake completed from: " + String.valueOf(this.peer));
            try {
                this.addAndWaitTLSHandler(ctx, hsEvt.getSelectedId(), hsEvt.getPeerId());
            }
            catch (Exception e) {
                logger.error("SSLHandler creation in connection to {} failed with exception: {}", (Object)this.peer, (Object)e);
                this.exceptionCaught(ctx, e);
            }
        } else if (logger.isWarnEnabled() && !(evt instanceof SslHandshakeCompletionEvent)) {
            logger.warn("Unknown user event caught: " + String.valueOf(evt));
        }
    }

    private void addAndWaitTLSHandler(ChannelHandlerContext chCtx, byte[] selectedId, byte[] peerId) throws Exception {
        SslContext sslCtx = SslContextBuilder.forServer(this.keyManager.getPrivateKey(selectedId), this.keyManager.getCertificateChain(selectedId)).trustManager(this.trustManager.singleTrustManager(peerId)).clientAuth(ClientAuth.REQUIRE).sslContextProvider(new BouncyCastleJsseProvider()).startTls(true).build();
        SslHandler sslHandler = sslCtx.newHandler(chCtx.alloc(), this.peer.getAddress().getHostAddress(), this.peer.getPort(), this.loop);
        sslHandler.handshakeFuture().addListener(f -> this.loop.execute(() -> {
            if (f.isSuccess()) {
                this.outsideUp = true;
                this.listener.inboundConnectionUp(this);
            } else {
                this.exceptionCaught(chCtx, f.cause());
            }
        }));
        if ("IdleHandler".equals(chCtx.pipeline().names().getFirst())) {
            chCtx.pipeline().addAfter("IdleHandler", "TLSHandler", sslHandler);
        } else {
            chCtx.pipeline().addFirst("TLSHandler", (ChannelHandler)sslHandler);
        }
    }

    @Override
    public String toString() {
        return "InTLSConnectionHandler{peer=" + String.valueOf(this.peer) + ", attributes=" + String.valueOf(this.peerAttributes) + ", channel=" + String.valueOf(this.channel) + "}";
    }
}

