/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.tls.pipeline;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.listeners.MessageListener;
import pt.unl.fct.di.novasys.network.listeners.OutConnListener;
import pt.unl.fct.di.novasys.network.pipeline.OutConnectionHandler;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;
import pt.unl.fct.di.novasys.network.security.X509ITrustManager;
import pt.unl.fct.di.novasys.network.tls.pipeline.OutPreTLSHandshakeHandler;
import pt.unl.fct.di.novasys.network.tls.userevents.PreTLSHandshakeCompleted;

public class OutTLSConnectionHandler<T>
extends OutConnectionHandler<T> {
    private static final Logger logger = LogManager.getLogger(OutTLSConnectionHandler.class);
    private final X509IKeyManager keyManager;
    private final X509ITrustManager trustManager;

    public OutTLSConnectionHandler(long connectionId, Host peer, Bootstrap bootstrap, OutConnListener<T> listener, MessageListener<T> consumer, ISerializer<T> serializer, EventLoop loop, Attributes selfAttrs, int hbInterval, int hbTolerance, AttributeValidator validator, int handshakeSteps, X509IKeyManager keyManager, X509ITrustManager trustManager) {
        super(connectionId, peer, bootstrap, listener, consumer, serializer, loop, selfAttrs, hbInterval, hbTolerance, validator, handshakeSteps, new OutPreTLSHandshakeHandler(connectionId, validator, selfAttrs, handshakeSteps, keyManager));
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    @Override
    public void internalUserEventTriggered(ChannelHandlerContext ctx, Object evt) {
        logger.debug("User event triggered: {}", evt);
        if (evt instanceof PreTLSHandshakeCompleted) {
            PreTLSHandshakeCompleted hsEvt = (PreTLSHandshakeCompleted)evt;
            if (this.state != OutConnectionHandler.State.HANDSHAKING || ctx.channel() != this.channel) {
                throw new AssertionError((Object)("Handshake completed while not in handshake state: " + String.valueOf(this.peer)));
            }
            this.peerAttributes = hsEvt.getAttr();
            logger.debug("Pre TLS out handshake completed with: " + String.valueOf(this.peer));
            try {
                this.addAndStartTLSHandler(ctx, hsEvt.getSelectedId(), hsEvt.getPeerId());
            }
            catch (Exception e) {
                logger.error("SSLHandler creation in connection to {} failed with exception: {}", (Object)this.peer, (Object)e);
                this.exceptionCaught(ctx, e);
            }
        } else if (logger.isWarnEnabled() && !(evt instanceof SslHandshakeCompletionEvent)) {
            logger.warn("Unknown user event caught: " + String.valueOf(evt));
        }
    }

    private void addAndStartTLSHandler(ChannelHandlerContext chCtx, byte[] selectedId, byte[] peerId) throws Exception {
        SslContext sslCtx = SslContextBuilder.forClient().keyManager(this.keyManager.getPrivateKey(selectedId), this.keyManager.getCertificateChain(selectedId)).trustManager(this.trustManager.singleTrustManager(peerId)).clientAuth(ClientAuth.REQUIRE).sslContextProvider(new BouncyCastleJsseProvider()).startTls(false).build();
        SslHandler sslHandler = sslCtx.newHandler(chCtx.alloc(), this.peer.getAddress().getHostAddress(), this.peer.getPort(), this.loop);
        sslHandler.handshakeFuture().addListener(f -> this.loop.execute(() -> {
            if (f.isSuccess()) {
                this.state = OutConnectionHandler.State.CONNECTED;
                this.listener.outboundConnectionUp(this);
            } else {
                this.exceptionCaught(chCtx, f.cause());
            }
        }));
        if ("IdleHandler".equals(chCtx.pipeline().names().getFirst())) {
            chCtx.pipeline().addAfter("IdleHandler", "TLSHandler", sslHandler);
        } else {
            chCtx.pipeline().addFirst("TLSHandler", (ChannelHandler)sslHandler);
        }
        sslHandler.channelActive(chCtx);
    }

    @Override
    public String toString() {
        return "TLSOutConnectionHandler{peer=" + String.valueOf(this.peer) + ", attributes=" + String.valueOf(this.peerAttributes) + ", channel=" + String.valueOf(this.channel) + "}";
    }
}

