/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.StatementBuilder;
import com.datastax.oss.driver.internal.core.cql.DefaultBatchStatement;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class BatchStatementBuilder
extends StatementBuilder<BatchStatementBuilder, BatchStatement> {
    @NonNull
    private BatchType batchType;
    @Nullable
    private CqlIdentifier keyspace;
    @NonNull
    private ImmutableList.Builder<BatchableStatement<?>> statementsBuilder;
    private int statementsCount;

    public BatchStatementBuilder(@NonNull BatchType batchType) {
        this.batchType = batchType;
        this.statementsBuilder = ImmutableList.builder();
    }

    public BatchStatementBuilder(@NonNull BatchStatement template) {
        super(template);
        this.batchType = template.getBatchType();
        this.statementsBuilder = ImmutableList.builder().addAll((Iterable)template);
        this.statementsCount = template.size();
    }

    @NonNull
    public BatchStatementBuilder setKeyspace(@NonNull CqlIdentifier keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    @NonNull
    public BatchStatementBuilder setKeyspace(@NonNull String keyspaceName) {
        return this.setKeyspace(CqlIdentifier.fromCql(keyspaceName));
    }

    @NonNull
    public BatchStatementBuilder addStatement(@NonNull BatchableStatement<?> statement) {
        if (this.statementsCount >= 65535) {
            throw new IllegalStateException("Batch statement cannot contain more than 65535 statements.");
        }
        ++this.statementsCount;
        this.statementsBuilder.add((Object)statement);
        return this;
    }

    @NonNull
    public BatchStatementBuilder addStatements(@NonNull Iterable<BatchableStatement<?>> statements) {
        int delta = Iterables.size(statements);
        if (this.statementsCount + delta > 65535) {
            throw new IllegalStateException("Batch statement cannot contain more than 65535 statements.");
        }
        this.statementsCount += delta;
        this.statementsBuilder.addAll((Iterable)statements);
        return this;
    }

    @NonNull
    public BatchStatementBuilder addStatements(BatchableStatement<?> ... statements) {
        return this.addStatements(Arrays.asList(statements));
    }

    @NonNull
    public BatchStatementBuilder clearStatements() {
        this.statementsBuilder = ImmutableList.builder();
        this.statementsCount = 0;
        return this;
    }

    @Override
    @NonNull
    public BatchStatement build() {
        return new DefaultBatchStatement(this.batchType, (List<BatchableStatement<?>>)((Object)this.statementsBuilder.build()), this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.buildCustomPayload(), this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node);
    }

    public int getStatementsCount() {
        return this.statementsCount;
    }
}

