/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public abstract class StatementBuilder<SelfT extends StatementBuilder<SelfT, StatementT>, StatementT extends Statement<StatementT>> {
    private final SelfT self = this;
    @Nullable
    protected String executionProfileName;
    @Nullable
    protected DriverExecutionProfile executionProfile;
    @Nullable
    protected CqlIdentifier routingKeyspace;
    @Nullable
    protected ByteBuffer routingKey;
    @Nullable
    protected Token routingToken;
    @Nullable
    private NullAllowingImmutableMap.Builder<String, ByteBuffer> customPayloadBuilder;
    @Nullable
    protected Boolean idempotent;
    protected boolean tracing;
    protected long timestamp = Long.MIN_VALUE;
    @Nullable
    protected ByteBuffer pagingState;
    protected int pageSize = Integer.MIN_VALUE;
    @Nullable
    protected ConsistencyLevel consistencyLevel;
    @Nullable
    protected ConsistencyLevel serialConsistencyLevel;
    @Nullable
    protected Duration timeout;
    @Nullable
    protected Node node;

    protected StatementBuilder() {
    }

    protected StatementBuilder(StatementT template) {
        this.executionProfileName = template.getExecutionProfileName();
        this.executionProfile = template.getExecutionProfile();
        this.routingKeyspace = template.getRoutingKeyspace();
        this.routingKey = template.getRoutingKey();
        this.routingToken = template.getRoutingToken();
        if (!template.getCustomPayload().isEmpty()) {
            this.customPayloadBuilder = NullAllowingImmutableMap.builder().putAll(template.getCustomPayload());
        }
        this.idempotent = template.isIdempotent();
        this.tracing = template.isTracing();
        this.timestamp = template.getQueryTimestamp();
        this.pagingState = template.getPagingState();
        this.pageSize = template.getPageSize();
        this.consistencyLevel = template.getConsistencyLevel();
        this.serialConsistencyLevel = template.getSerialConsistencyLevel();
        this.timeout = template.getTimeout();
        this.node = template.getNode();
    }

    @NonNull
    public SelfT setExecutionProfileName(@Nullable String executionProfileName) {
        this.executionProfileName = executionProfileName;
        return this.self;
    }

    @NonNull
    public SelfT setExecutionProfile(@Nullable DriverExecutionProfile executionProfile) {
        this.executionProfile = executionProfile;
        this.executionProfileName = null;
        return this.self;
    }

    @NonNull
    public SelfT setRoutingKeyspace(@Nullable CqlIdentifier routingKeyspace) {
        this.routingKeyspace = routingKeyspace;
        return this.self;
    }

    @NonNull
    public SelfT setRoutingKeyspace(@Nullable String routingKeyspaceName) {
        return this.setRoutingKeyspace(routingKeyspaceName == null ? null : CqlIdentifier.fromCql(routingKeyspaceName));
    }

    @NonNull
    public SelfT setRoutingKey(@Nullable ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this.self;
    }

    @NonNull
    public SelfT setRoutingToken(@Nullable Token routingToken) {
        this.routingToken = routingToken;
        return this.self;
    }

    @NonNull
    public SelfT addCustomPayload(@NonNull String key, @Nullable ByteBuffer value) {
        if (this.customPayloadBuilder == null) {
            this.customPayloadBuilder = NullAllowingImmutableMap.builder();
        }
        this.customPayloadBuilder.put(key, value);
        return this.self;
    }

    @NonNull
    public SelfT clearCustomPayload() {
        this.customPayloadBuilder = null;
        return this.self;
    }

    @NonNull
    public SelfT setIdempotence(@Nullable Boolean idempotent) {
        this.idempotent = idempotent;
        return this.self;
    }

    @NonNull
    public SelfT setTracing() {
        this.tracing = true;
        return this.self;
    }

    @NonNull
    public SelfT setQueryTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this.self;
    }

    @NonNull
    public SelfT setPagingState(@Nullable ByteBuffer pagingState) {
        this.pagingState = pagingState;
        return this.self;
    }

    @NonNull
    public SelfT setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this.self;
    }

    @NonNull
    public SelfT setConsistencyLevel(@Nullable ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this.self;
    }

    @NonNull
    public SelfT setSerialConsistencyLevel(@Nullable ConsistencyLevel serialConsistencyLevel) {
        this.serialConsistencyLevel = serialConsistencyLevel;
        return this.self;
    }

    @NonNull
    public SelfT setTimeout(@Nullable Duration timeout) {
        this.timeout = timeout;
        return this.self;
    }

    public SelfT setNode(@Nullable Node node) {
        this.node = node;
        return this.self;
    }

    @NonNull
    protected Map<String, ByteBuffer> buildCustomPayload() {
        return this.customPayloadBuilder == null ? NullAllowingImmutableMap.of() : this.customPayloadBuilder.build();
    }

    @NonNull
    public abstract StatementT build();
}

