/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.Describable;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;

public interface AggregateMetadata
extends Describable {
    @NonNull
    public CqlIdentifier getKeyspace();

    @NonNull
    public FunctionSignature getSignature();

    @NonNull
    public Optional<FunctionSignature> getFinalFuncSignature();

    @NonNull
    public Optional<Object> getInitCond();

    @NonNull
    public DataType getReturnType();

    @NonNull
    public FunctionSignature getStateFuncSignature();

    @NonNull
    public DataType getStateType();

    @Override
    @NonNull
    default public String describeWithChildren(boolean pretty) {
        return this.describe(pretty);
    }

    @Override
    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty);
        builder.append("CREATE AGGREGATE ").append(this.getKeyspace()).append(".").append(this.getSignature().getName()).append("(");
        boolean first = true;
        for (int i = 0; i < this.getSignature().getParameterTypes().size(); ++i) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            DataType type = this.getSignature().getParameterTypes().get(i);
            builder.append(type.asCql(false, pretty));
        }
        builder.increaseIndent().append(")").newLine().append("SFUNC ").append(this.getStateFuncSignature().getName()).newLine().append("STYPE ").append(this.getStateType().asCql(false, pretty));
        if (this.getFinalFuncSignature().isPresent()) {
            builder.newLine().append("FINALFUNC ").append(this.getFinalFuncSignature().get().getName());
        }
        if (this.getInitCond().isPresent()) {
            Optional<String> formatInitCond = this.formatInitCond();
            if (!1.$assertionsDisabled && !formatInitCond.isPresent()) {
                throw new AssertionError();
            }
            builder.newLine().append("INITCOND ").append(formatInitCond.get());
        }
        return builder.append(";").build();
    }

    @NonNull
    public Optional<String> formatInitCond();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

