/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.session;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.ContactPoints;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public abstract class SessionBuilder<SelfT extends SessionBuilder, SessionT> {
    protected final SelfT self = this;
    protected DriverConfigLoader configLoader;
    protected Set<EndPoint> programmaticContactPoints = new HashSet<EndPoint>();
    protected List<TypeCodec<?>> typeCodecs = new ArrayList();
    private NodeStateListener nodeStateListener;
    private SchemaChangeListener schemaChangeListener;
    protected RequestTracker requestTracker;
    private ImmutableMap.Builder<String, String> localDatacenters = ImmutableMap.builder();
    private ImmutableMap.Builder<String, Predicate<Node>> nodeFilters = ImmutableMap.builder();
    protected CqlIdentifier keyspace;
    private ClassLoader classLoader = null;

    @NonNull
    public SelfT withConfigLoader(@Nullable DriverConfigLoader configLoader) {
        this.configLoader = configLoader;
        return this.self;
    }

    @NonNull
    protected DriverConfigLoader defaultConfigLoader() {
        return new DefaultDriverConfigLoader();
    }

    @NonNull
    public SelfT addContactPoints(@NonNull Collection<InetSocketAddress> contactPoints) {
        for (InetSocketAddress contactPoint : contactPoints) {
            this.addContactPoint(contactPoint);
        }
        return this.self;
    }

    @NonNull
    public SelfT addContactPoint(@NonNull InetSocketAddress contactPoint) {
        this.programmaticContactPoints.add(new DefaultEndPoint(contactPoint));
        return this.self;
    }

    @NonNull
    public SelfT addContactEndPoints(@NonNull Collection<EndPoint> contactPoints) {
        for (EndPoint contactPoint : contactPoints) {
            this.addContactEndPoint(contactPoint);
        }
        return this.self;
    }

    @NonNull
    public SelfT addContactEndPoint(@NonNull EndPoint contactPoint) {
        this.programmaticContactPoints.add(contactPoint);
        return this.self;
    }

    @NonNull
    public SelfT addTypeCodecs(TypeCodec<?> ... typeCodecs) {
        Collections.addAll(this.typeCodecs, typeCodecs);
        return this.self;
    }

    @NonNull
    public SelfT withNodeStateListener(@Nullable NodeStateListener nodeStateListener) {
        this.nodeStateListener = nodeStateListener;
        return this.self;
    }

    @NonNull
    public SelfT withSchemaChangeListener(@Nullable SchemaChangeListener schemaChangeListener) {
        this.schemaChangeListener = schemaChangeListener;
        return this.self;
    }

    @NonNull
    public SelfT withRequestTracker(@Nullable RequestTracker requestTracker) {
        this.requestTracker = requestTracker;
        return this.self;
    }

    public SelfT withLocalDatacenter(@NonNull String profileName, @NonNull String localDatacenter) {
        this.localDatacenters.put(profileName, localDatacenter);
        return this.self;
    }

    public SelfT withLocalDatacenter(@NonNull String localDatacenter) {
        return this.withLocalDatacenter("default", localDatacenter);
    }

    @NonNull
    public SelfT withNodeFilter(@NonNull String profileName, @NonNull Predicate<Node> nodeFilter) {
        this.nodeFilters.put(profileName, nodeFilter);
        return this.self;
    }

    @NonNull
    public SelfT withNodeFilter(@NonNull Predicate<Node> nodeFilter) {
        return this.withNodeFilter("default", nodeFilter);
    }

    @NonNull
    public SelfT withKeyspace(@Nullable CqlIdentifier keyspace) {
        this.keyspace = keyspace;
        return this.self;
    }

    @NonNull
    public SelfT withKeyspace(@Nullable String keyspaceName) {
        return this.withKeyspace(keyspaceName == null ? null : CqlIdentifier.fromCql(keyspaceName));
    }

    @NonNull
    public SelfT withClassLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this.self;
    }

    @NonNull
    public CompletionStage<SessionT> buildAsync() {
        CompletionStage<CqlSession> buildStage = this.buildDefaultSessionAsync();
        CompletionStage<Object> wrapStage = buildStage.thenApply(this::wrap);
        CompletableFutures.propagateCancellation(wrapStage, buildStage);
        return wrapStage;
    }

    @NonNull
    public SessionT build() {
        BlockingOperation.checkNotDriverThread();
        return CompletableFutures.getUninterruptibly(this.buildAsync());
    }

    protected abstract SessionT wrap(@NonNull CqlSession var1);

    @NonNull
    protected final CompletionStage<CqlSession> buildDefaultSessionAsync() {
        try {
            DriverConfigLoader configLoader = SessionBuilder.buildIfNull(this.configLoader, this::defaultConfigLoader);
            DriverExecutionProfile defaultConfig = configLoader.getInitialConfig().getDefaultProfile();
            List<String> configContactPoints = defaultConfig.getStringList(DefaultDriverOption.CONTACT_POINTS, Collections.emptyList());
            boolean resolveAddresses = defaultConfig.getBoolean(DefaultDriverOption.RESOLVE_CONTACT_POINTS, true);
            Set<EndPoint> contactPoints = ContactPoints.merge(this.programmaticContactPoints, configContactPoints, resolveAddresses);
            if (this.keyspace == null && defaultConfig.isDefined(DefaultDriverOption.SESSION_KEYSPACE)) {
                this.keyspace = CqlIdentifier.fromCql(defaultConfig.getString(DefaultDriverOption.SESSION_KEYSPACE));
            }
            return DefaultSession.init((InternalDriverContext)this.buildContext(configLoader, this.typeCodecs, this.nodeStateListener, this.schemaChangeListener, this.requestTracker, this.localDatacenters.build(), this.nodeFilters.build(), this.classLoader), contactPoints, this.keyspace);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture(t);
        }
    }

    protected DriverContext buildContext(DriverConfigLoader configLoader, List<TypeCodec<?>> typeCodecs, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, RequestTracker requestTracker, Map<String, String> localDatacenters, Map<String, Predicate<Node>> nodeFilters, ClassLoader classLoader) {
        return new DefaultDriverContext(configLoader, typeCodecs, nodeStateListener, schemaChangeListener, requestTracker, localDatacenters, nodeFilters, classLoader);
    }

    private static <T> T buildIfNull(T value, Supplier<T> builder) {
        return value == null ? builder.get() : value;
    }
}

