/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.adminrequest;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRequestHandler;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.AbstractIterator;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.Rows;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class AdminResult
implements Iterable<AdminRow> {
    private final Queue<List<ByteBuffer>> data;
    private final Map<String, ColumnSpec> columnSpecs;
    private final AdminRequestHandler nextHandler;
    private final ProtocolVersion protocolVersion;

    public AdminResult(Rows rows, AdminRequestHandler nextHandler, ProtocolVersion protocolVersion) {
        this.data = rows.getData();
        ImmutableMap.Builder<String, ColumnSpec> columnSpecsBuilder = ImmutableMap.builder();
        for (ColumnSpec spec : rows.getMetadata().columnSpecs) {
            columnSpecsBuilder.put(spec.name, spec);
        }
        this.columnSpecs = columnSpecsBuilder.build();
        this.nextHandler = nextHandler;
        this.protocolVersion = protocolVersion;
    }

    @Override
    @NonNull
    public Iterator<AdminRow> iterator() {
        return new AbstractIterator<AdminRow>(){

            @Override
            protected AdminRow computeNext() {
                List rowData = (List)AdminResult.this.data.poll();
                return rowData == null ? (AdminRow)this.endOfData() : new AdminRow(AdminResult.this.columnSpecs, rowData, AdminResult.this.protocolVersion);
            }
        };
    }

    public boolean hasNextPage() {
        return this.nextHandler != null;
    }

    public CompletionStage<AdminResult> nextPage() {
        return this.nextHandler == null ? CompletableFutures.failedFuture((Throwable)((Object)new AssertionError((Object)"No next page, use hasNextPage() before you call this method"))) : this.nextHandler.start();
    }
}

