/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.data.ValuesHelper;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultUdtValue
implements UdtValue,
Serializable {
    private static final long serialVersionUID = 1L;
    private final UserDefinedType type;
    private final ByteBuffer[] values;

    public DefaultUdtValue(@NonNull UserDefinedType type) {
        this(type, new ByteBuffer[type.getFieldTypes().size()]);
    }

    public DefaultUdtValue(@NonNull UserDefinedType type, Object ... values) {
        this(type, ValuesHelper.encodeValues(values, type.getFieldTypes(), type.getAttachmentPoint().getCodecRegistry(), type.getAttachmentPoint().getProtocolVersion()));
    }

    private DefaultUdtValue(UserDefinedType type, ByteBuffer[] values) {
        Preconditions.checkNotNull(type);
        this.type = type;
        this.values = values;
    }

    @Override
    @NonNull
    public UserDefinedType getType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public int firstIndexOf(@NonNull CqlIdentifier id) {
        int indexOf = this.type.firstIndexOf(id);
        if (indexOf == -1) {
            throw new IllegalArgumentException(id + " is not a field in this UDT");
        }
        return indexOf;
    }

    @Override
    public int firstIndexOf(@NonNull String name) {
        int indexOf = this.type.firstIndexOf(name);
        if (indexOf == -1) {
            throw new IllegalArgumentException(name + " is not a field in this UDT");
        }
        return indexOf;
    }

    @Override
    @NonNull
    public DataType getType(int i) {
        return this.type.getFieldTypes().get(i);
    }

    @Override
    public ByteBuffer getBytesUnsafe(int i) {
        return this.values[i];
    }

    @Override
    @NonNull
    public UdtValue setBytesUnsafe(int i, @Nullable ByteBuffer v) {
        this.values[i] = v;
        return this;
    }

    @Override
    @NonNull
    public CodecRegistry codecRegistry() {
        return this.type.getAttachmentPoint().getCodecRegistry();
    }

    @Override
    @NonNull
    public ProtocolVersion protocolVersion() {
        return this.type.getAttachmentPoint().getProtocolVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UdtValue)) {
            return false;
        }
        UdtValue that = (UdtValue)o;
        if (!this.type.equals(that.getType())) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            DataType thatValue;
            DataType innerThisType = this.type.getFieldTypes().get(i);
            DataType innerThatType = that.getType().getFieldTypes().get(i);
            DataType thisValue = this.codecRegistry().codecFor(innerThisType).decode(this.getBytesUnsafe(i), this.protocolVersion());
            if (Objects.equals(thisValue, thatValue = that.codecRegistry().codecFor(innerThatType).decode(that.getBytesUnsafe(i), that.protocolVersion()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        for (int i = 0; i < this.values.length; ++i) {
            DataType innerThisType = this.type.getFieldTypes().get(i);
            DataType thisValue = this.codecRegistry().codecFor(innerThisType).decode(this.values[i], this.protocolVersion());
            if (thisValue == null) continue;
            result = 31 * result + thisValue.hashCode();
        }
        return result;
    }

    public String toString() {
        return this.codecRegistry().codecFor(this.type).format((UserDefinedType)((Object)this));
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final UserDefinedType type;
        private final byte[][] values;

        SerializationProxy(DefaultUdtValue udt) {
            this.type = udt.type;
            this.values = new byte[udt.values.length][];
            for (int i = 0; i < udt.values.length; ++i) {
                ByteBuffer buffer = udt.values[i];
                this.values[i] = buffer == null ? null : Bytes.getArray(buffer);
            }
        }

        private Object readResolve() {
            ByteBuffer[] buffers = new ByteBuffer[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                byte[] value = this.values[i];
                buffers[i] = value == null ? null : ByteBuffer.wrap(value);
            }
            return new DefaultUdtValue(this.type, buffers);
        }
    }
}

