/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.Triple;
import pt.unl.fct.di.novasys.babel.core.BabelMessageSerializer;
import pt.unl.fct.di.novasys.babel.core.ChannelToProtoForwarder;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.InvalidParameterException;
import pt.unl.fct.di.novasys.babel.exceptions.NoSuchProtocolException;
import pt.unl.fct.di.novasys.babel.exceptions.ProtocolAlreadyExistsException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.generic.ProtoTimer;
import pt.unl.fct.di.novasys.babel.initializers.AccrualChannelInitializer;
import pt.unl.fct.di.novasys.babel.initializers.ChannelInitializer;
import pt.unl.fct.di.novasys.babel.initializers.SharedTCPChannelInitializer;
import pt.unl.fct.di.novasys.babel.initializers.SimpleClientChannelInitializer;
import pt.unl.fct.di.novasys.babel.initializers.SimpleServerChannelInitializer;
import pt.unl.fct.di.novasys.babel.initializers.TCPChannelInitializer;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.babel.internal.IPCEvent;
import pt.unl.fct.di.novasys.babel.internal.NotificationEvent;
import pt.unl.fct.di.novasys.babel.internal.TimerEvent;
import pt.unl.fct.di.novasys.babel.metrics.MetricsManager;
import pt.unl.fct.di.novasys.channel.IChannel;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class Babel {
    private static Babel system;
    private final Map<Short, GenericProtocol> protocolMap = new ConcurrentHashMap<Short, GenericProtocol>();
    private final Map<String, GenericProtocol> protocolByNameMap = new ConcurrentHashMap<String, GenericProtocol>();
    private final Map<Short, Set<GenericProtocol>> subscribers = new ConcurrentHashMap<Short, Set<GenericProtocol>>();
    private final Map<Long, TimerEvent> allTimers = new HashMap<Long, TimerEvent>();
    private final PriorityBlockingQueue<TimerEvent> timerQueue = new PriorityBlockingQueue();
    private final Thread timersThread;
    private final AtomicLong timersCounter = new AtomicLong();
    private final Map<String, ChannelInitializer<? extends IChannel<BabelMessage>>> initializers;
    private final Map<Integer, Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer>> channelMap;
    private final AtomicInteger channelIdGenerator;
    private long startTime;
    private boolean started = false;

    public static synchronized Babel getInstance() {
        if (system == null) {
            system = new Babel();
        }
        return system;
    }

    private Babel() {
        this.timersThread = new Thread(this::timerLoop);
        this.channelMap = new ConcurrentHashMap<Integer, Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer>>();
        this.channelIdGenerator = new AtomicInteger(0);
        this.initializers = new ConcurrentHashMap<String, ChannelInitializer<? extends IChannel<BabelMessage>>>();
        this.registerChannelInitializer("ClientChannel", new SimpleClientChannelInitializer());
        this.registerChannelInitializer("ServerChannel", new SimpleServerChannelInitializer());
        this.registerChannelInitializer("TCPChannel", new TCPChannelInitializer());
        this.registerChannelInitializer("AccrualChannel", new AccrualChannelInitializer());
        this.registerChannelInitializer("SharedTCPChannel", new SharedTCPChannelInitializer());
    }

    private void timerLoop() {
        while (true) {
            long toSleep;
            long now = this.getMillisSinceStart();
            TimerEvent tE = this.timerQueue.peek();
            long l = toSleep = tE != null ? tE.getTriggerTime() - now : Long.MAX_VALUE;
            if (toSleep <= 0L) {
                TimerEvent t = (TimerEvent)this.timerQueue.remove();
                t.getConsumer().deliverTimer(t);
                if (!t.isPeriodic()) continue;
                t.setTriggerTime(now + t.getPeriod());
                this.timerQueue.add(t);
                continue;
            }
            try {
                Thread.sleep(toSleep);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.started = true;
        MetricsManager.getInstance().start();
        this.timersThread.start();
        this.protocolMap.values().forEach(GenericProtocol::start);
    }

    public void registerProtocol(GenericProtocol p) throws ProtocolAlreadyExistsException {
        GenericProtocol old = this.protocolMap.putIfAbsent(p.getProtoId(), p);
        if (old != null) {
            throw new ProtocolAlreadyExistsException("Protocol conflicts on id with protocol: id=" + p.getProtoId() + ":name=" + this.protocolMap.get(p.getProtoId()).getProtoName());
        }
        old = this.protocolByNameMap.putIfAbsent(p.getProtoName(), p);
        if (old != null) {
            this.protocolMap.remove(p.getProtoId());
            throw new ProtocolAlreadyExistsException("Protocol conflicts on name: " + p.getProtoName() + " (id: " + this.protocolByNameMap.get(p.getProtoName()).getProtoId() + ")");
        }
    }

    public void registerChannelInitializer(String name, ChannelInitializer<? extends IChannel<BabelMessage>> initializer) {
        ChannelInitializer<? extends IChannel<BabelMessage>> old = this.initializers.putIfAbsent(name, initializer);
        if (old != null) {
            throw new IllegalArgumentException("Initializer for channel with name " + name + " already registered: " + old);
        }
    }

    int createChannel(String channelName, short protoId, Properties props) throws IOException {
        ChannelInitializer<? extends IChannel<BabelMessage>> initializer = this.initializers.get(channelName);
        if (initializer == null) {
            throw new IllegalArgumentException("Channel initializer not registered: " + channelName);
        }
        int channelId = this.channelIdGenerator.incrementAndGet();
        BabelMessageSerializer serializer = new BabelMessageSerializer(new ConcurrentHashMap<Short, ISerializer<? extends ProtoMessage>>());
        ChannelToProtoForwarder forwarder = new ChannelToProtoForwarder(channelId);
        IChannel<BabelMessage> newChannel = initializer.initialize(serializer, forwarder, props, protoId);
        this.channelMap.put(channelId, Triple.of(newChannel, forwarder, serializer));
        return channelId;
    }

    void registerChannelInterest(int channelId, short protoId, GenericProtocol consumerProto) {
        ChannelToProtoForwarder forwarder = this.channelMap.get(channelId).getMiddle();
        forwarder.addConsumer(protoId, consumerProto);
    }

    void sendMessage(int channelId, int connection, BabelMessage msg, Host target) {
        Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer> channelEntry = this.channelMap.get(channelId);
        if (channelEntry == null) {
            throw new AssertionError((Object)("Sending message to non-existing channelId " + channelId));
        }
        channelEntry.getLeft().sendMessage(msg, target, connection);
    }

    void closeConnection(int channelId, Host target, int connection) {
        Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer> channelEntry = this.channelMap.get(channelId);
        if (channelEntry == null) {
            throw new AssertionError((Object)("Closing connection in non-existing channelId " + channelId));
        }
        channelEntry.getLeft().closeConnection(target, connection);
    }

    void openConnection(int channelId, Host target, int connection) {
        Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer> channelEntry = this.channelMap.get(channelId);
        if (channelEntry == null) {
            throw new AssertionError((Object)("Opening connection in non-existing channelId " + channelId));
        }
        channelEntry.getLeft().openConnection(target, connection);
    }

    void registerSerializer(int channelId, short msgCode, ISerializer<? extends ProtoMessage> serializer) {
        Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer> channelEntry = this.channelMap.get(channelId);
        if (channelEntry == null) {
            throw new AssertionError((Object)("Registering serializer in non-existing channelId " + channelId));
        }
        channelEntry.getRight().registerProtoSerializer(msgCode, serializer);
    }

    void sendIPC(IPCEvent ipc) throws NoSuchProtocolException {
        GenericProtocol gp = this.protocolMap.get(ipc.getDestinationID());
        if (gp == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ipc.getDestinationID()).append(" not executing.");
            sb.append("Executing protocols: [");
            this.protocolMap.forEach((id, p) -> sb.append(id).append(" - ").append(p.getProtoName()).append(", "));
            sb.append("]");
            throw new NoSuchProtocolException(sb.toString());
        }
        gp.deliverIPC(ipc);
    }

    void subscribeNotification(short nId, GenericProtocol consumer) {
        this.subscribers.computeIfAbsent(nId, k -> ConcurrentHashMap.newKeySet()).add(consumer);
    }

    void unsubscribeNotification(short nId, GenericProtocol consumer) {
        this.subscribers.getOrDefault(nId, Collections.emptySet()).remove(consumer);
    }

    void triggerNotification(NotificationEvent n) {
        for (GenericProtocol c : this.subscribers.getOrDefault(n.getNotification().getId(), Collections.emptySet())) {
            c.deliverNotification(n);
        }
    }

    long setupPeriodicTimer(ProtoTimer t, GenericProtocol consumer, long first, long period) {
        long id = this.timersCounter.incrementAndGet();
        TimerEvent newTimer = new TimerEvent(t, id, consumer, this.getMillisSinceStart() + first, true, period);
        this.allTimers.put(newTimer.getUuid(), newTimer);
        this.timerQueue.add(newTimer);
        this.timersThread.interrupt();
        return id;
    }

    long setupTimer(ProtoTimer t, GenericProtocol consumer, long timeout) {
        long id = this.timersCounter.incrementAndGet();
        TimerEvent newTimer = new TimerEvent(t, id, consumer, this.getMillisSinceStart() + timeout, false, -1L);
        this.timerQueue.add(newTimer);
        this.allTimers.put(newTimer.getUuid(), newTimer);
        this.timersThread.interrupt();
        return id;
    }

    ProtoTimer cancelTimer(long timerID) {
        TimerEvent tE = this.allTimers.remove(timerID);
        if (tE == null) {
            return null;
        }
        this.timerQueue.remove(tE);
        this.timersThread.interrupt();
        return tE.getTimer();
    }

    public static Properties loadConfig(String[] args, String defaultConfigFile) throws IOException, InvalidParameterException {
        ArrayList<String> argsList = new ArrayList<String>();
        Collections.addAll(argsList, args);
        String configFile = Babel.extractConfigFileFromArguments(argsList, defaultConfigFile);
        Properties configuration = new Properties();
        if (configFile != null) {
            configuration.load(new FileInputStream(configFile));
        }
        for (String arg : argsList) {
            String[] property = arg.split("=");
            if (property.length == 2) {
                configuration.setProperty(property[0], property[1]);
                continue;
            }
            throw new InvalidParameterException("Unknown parameter: " + arg);
        }
        return configuration;
    }

    private static String extractConfigFileFromArguments(List<String> args, String defaultConfigFile) {
        String config = defaultConfigFile;
        Iterator<String> iter = args.iterator();
        while (iter.hasNext()) {
            String param = iter.next();
            if (!param.equals("-conf")) continue;
            if (!iter.hasNext()) break;
            iter.remove();
            config = iter.next();
            iter.remove();
            break;
        }
        return config;
    }

    public long getMillisSinceStart() {
        return this.started ? System.currentTimeMillis() - this.startTime : 0L;
    }
}

