/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.network.ISerializer;

public class BabelMessageSerializer
implements ISerializer<BabelMessage> {
    Map<Short, ISerializer<? extends ProtoMessage>> serializers;

    public BabelMessageSerializer(Map<Short, ISerializer<? extends ProtoMessage>> serializers) {
        this.serializers = serializers;
    }

    public void registerProtoSerializer(short msgCode, ISerializer<? extends ProtoMessage> protoSerializer) {
        if (this.serializers.putIfAbsent(msgCode, protoSerializer) != null) {
            throw new AssertionError((Object)("Trying to re-register serializer in Babel: " + msgCode));
        }
    }

    @Override
    public void serialize(BabelMessage msg, ByteBuf byteBuf) throws IOException {
        byteBuf.writeShort(msg.getSourceProto());
        byteBuf.writeShort(msg.getDestProto());
        byteBuf.writeShort(msg.getMessage().getId());
        ISerializer<? extends ProtoMessage> iSerializer = this.serializers.get(msg.getMessage().getId());
        if (iSerializer == null) {
            throw new AssertionError((Object)("No serializer found for message id " + msg.getMessage().getId()));
        }
        iSerializer.serialize(msg.getMessage(), byteBuf);
    }

    @Override
    public BabelMessage deserialize(ByteBuf byteBuf) throws IOException {
        short source = byteBuf.readShort();
        short dest = byteBuf.readShort();
        short id = byteBuf.readShort();
        ISerializer<? extends ProtoMessage> iSerializer = this.serializers.get(id);
        if (iSerializer == null) {
            throw new AssertionError((Object)("No deserializer found for message id " + id));
        }
        ProtoMessage deserialize = iSerializer.deserialize(byteBuf);
        return new BabelMessage(deserialize, source, dest);
    }
}

