/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.babel.internal.CustomChannelEvent;
import pt.unl.fct.di.novasys.babel.internal.MessageFailedEvent;
import pt.unl.fct.di.novasys.babel.internal.MessageInEvent;
import pt.unl.fct.di.novasys.babel.internal.MessageSentEvent;
import pt.unl.fct.di.novasys.channel.ChannelEvent;
import pt.unl.fct.di.novasys.channel.ChannelListener;
import pt.unl.fct.di.novasys.network.data.Host;

public class ChannelToProtoForwarder
implements ChannelListener<BabelMessage> {
    private static final Logger logger = LogManager.getLogger(ChannelToProtoForwarder.class);
    final int channelId;
    final Map<Short, GenericProtocol> consumers;

    public ChannelToProtoForwarder(int channelId) {
        this.channelId = channelId;
        this.consumers = new ConcurrentHashMap<Short, GenericProtocol>();
    }

    public void addConsumer(short protoId, GenericProtocol consumer) {
        if (this.consumers.putIfAbsent(protoId, consumer) != null) {
            throw new AssertionError((Object)("Consumer with protoId " + protoId + " already exists in channel"));
        }
    }

    @Override
    public void deliverMessage(BabelMessage message, Host host) {
        GenericProtocol channelConsumer = message.getDestProto() == -1 && this.consumers.size() == 1 ? this.consumers.values().iterator().next() : this.consumers.get(message.getDestProto());
        if (channelConsumer == null) {
            logger.error("Channel " + this.channelId + " received message to protoId " + message.getDestProto() + " which is not registered in channel");
            throw new AssertionError((Object)("Channel " + this.channelId + " received message to protoId " + message.getDestProto() + " which is not registered in channel"));
        }
        channelConsumer.deliverMessageIn(new MessageInEvent(message, host, this.channelId));
    }

    @Override
    public void messageSent(BabelMessage addressedMessage, Host host) {
        this.consumers.values().forEach(c -> c.deliverMessageSent(new MessageSentEvent(addressedMessage, host, this.channelId)));
    }

    @Override
    public void messageFailed(BabelMessage addressedMessage, Host host, Throwable throwable) {
        this.consumers.values().forEach(c -> c.deliverMessageFailed(new MessageFailedEvent(addressedMessage, host, throwable, this.channelId)));
    }

    @Override
    public void deliverEvent(ChannelEvent channelEvent) {
        this.consumers.values().forEach(v -> v.deliverChannelEvent(new CustomChannelEvent(channelEvent, this.channelId)));
    }
}

