/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.DiscoverableProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.DiscoveryProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.messages.ServiceMessage;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.timers.AnoucementTimer;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.network.data.Host;

public class BroadcastDiscoveryProtocol
extends DiscoveryProtocol {
    private static final Logger logger = LogManager.getLogger(BroadcastDiscoveryProtocol.class);
    public static final int DEFAULT_PORT = 1025;
    public static final int ANOUNCEMENT_COOLDOWN = 1000;
    public static final short PROTO_ID = 32700;
    public static final String PROTO_NAME = "BabelBroadcastDiscovery";
    public static final String PAR_DISCOVERY_BROADCAST_INTERFACE = "babel.discovery.broadcast.interface";
    public static final String PAR_DISCOVERY_BROADCAST_PORT = "babel.discovery.broadcast.port";
    private DatagramSocket socket;
    private int bcastPort;
    private Map<String, ServiceMessage> discoveryProtocolsData;
    private Map<String, DiscoverableProtocol> protocolsWaiting;
    private Thread listeningThread;
    private Set<InetAddress> broadcastAddresses;
    private Host discoveryHost;

    public BroadcastDiscoveryProtocol() throws IOException, HandlerRegistrationException {
        super(PROTO_NAME, (short)32700);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        if (!props.containsKey(PAR_DISCOVERY_BROADCAST_INTERFACE) && props.containsKey("babel.interface")) {
            props.put(PAR_DISCOVERY_BROADCAST_INTERFACE, props.get("babel.interface"));
        }
        this.discoveryProtocolsData = new HashMap<String, ServiceMessage>();
        this.protocolsWaiting = new HashMap<String, DiscoverableProtocol>();
        this.bcastPort = 1025;
        if (props.containsKey(PAR_DISCOVERY_BROADCAST_PORT)) {
            this.bcastPort = Integer.parseInt(props.getProperty(PAR_DISCOVERY_BROADCAST_PORT));
        }
        HashSet<NetworkInterface> broadcastInterfaces = new HashSet<NetworkInterface>();
        if (!props.containsKey(PAR_DISCOVERY_BROADCAST_INTERFACE)) {
            Iterator<Object> iterator = NetworkInterface.networkInterfaces().distinct().iterator();
            while (iterator.hasNext()) {
                NetworkInterface n = (NetworkInterface)iterator.next();
                if (n.isLoopback() || n.isVirtual() || !n.isUp()) continue;
                broadcastInterfaces.add(n);
            }
        } else {
            broadcastInterfaces.add(NetworkInterface.getByName(props.getProperty(PAR_DISCOVERY_BROADCAST_INTERFACE)));
        }
        this.broadcastAddresses = new HashSet<InetAddress>();
        for (NetworkInterface n : broadcastInterfaces) {
            for (InterfaceAddress a : n.getInterfaceAddresses()) {
                this.broadcastAddresses.add(a.getBroadcast());
            }
        }
        if (this.broadcastAddresses.size() == 0) {
            throw new RuntimeException("No available broadcast address in network interface");
        }
        InetAddress address = null;
        if (props.containsKey("babel.discovery.unicast.address")) {
            address = InetAddress.getByName(props.getProperty("babel.discovery.unicast.address"));
        } else if (props.containsKey("babel.discovery.unicast.interface")) {
            List<InterfaceAddress> l = NetworkInterface.getByName(props.getProperty("babel.discovery.unicast.interface")).getInterfaceAddresses();
            for (InterfaceAddress a : l) {
                if (a.getAddress() != null && a.getAddress() instanceof Inet4Address) {
                    address = a.getAddress();
                } else if (address == null) continue;
                break;
            }
        } else {
            Iterator iterator = NetworkInterface.networkInterfaces().distinct().iterator();
            while (iterator.hasNext()) {
                InterfaceAddress a;
                NetworkInterface n = (NetworkInterface)iterator.next();
                if (n.isLoopback() || n.isVirtual() || !n.isUp() || n.isPointToPoint()) continue;
                Iterator<InterfaceAddress> iterator2 = n.getInterfaceAddresses().iterator();
                if (iterator2.hasNext() && (a = iterator2.next()).getAddress() != null && a.getAddress() instanceof Inet4Address) {
                    address = a.getAddress();
                }
                if (address == null) continue;
                break;
            }
        }
        this.socket = new DatagramSocket(this.bcastPort, address);
        this.discoveryHost = new Host(this.socket.getLocalAddress(), this.socket.getLocalPort());
        this.socket.setBroadcast(true);
        this.registerTimerHandler((short)32501, this::announce);
        logger.info("BroadcastDiscoveryProtocol set up");
        this.listeningThread = new Thread(() -> this.listen(this.socket));
        this.listeningThread.start();
        logger.info("DiscoveryProtocol initialized");
    }

    private void announce(AnoucementTimer timer, long timerId) {
        logger.info("Firing anouncements");
        if (this.protocolsWaiting.size() == 0) {
            return;
        }
        ArrayList<ServiceMessage> pendingServices = new ArrayList<ServiceMessage>();
        for (String protocol : this.protocolsWaiting.keySet()) {
            pendingServices.add(this.discoveryProtocolsData.get(protocol));
        }
        try {
            List<byte[]> announces = ServiceMessage.convertToMessage(pendingServices, true);
            for (byte[] m : announces) {
                for (InetAddress a : this.broadcastAddresses) {
                    this.socket.send(new DatagramPacket(m, m.length, new InetSocketAddress(a, this.bcastPort)));
                    logger.info("Anounced search for broadcast address " + String.valueOf(a));
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not send announcements.");
            e.printStackTrace();
        }
    }

    @Override
    public void registerProtocol(DiscoverableProtocol dcProto) {
        this.discoveryProtocolsData.put(dcProto.getProtoName(), new ServiceMessage(dcProto.getProtoName(), dcProto.getMyself(), this.discoveryHost));
        if (!dcProto.needsDiscovery()) {
            this.protocolsWaiting.put(dcProto.getProtoName(), dcProto);
        }
    }

    private void listen(DatagramSocket socket) {
        while (true) {
            try {
                block3: while (true) {
                    DatagramPacket packet = new DatagramPacket(new byte[65507], 65507);
                    socket.receive(packet);
                    if (packet.getAddress().equals(this.socket.getLocalAddress()) && packet.getPort() == this.socket.getLocalPort()) {
                        logger.debug("Discarding multicast packet sent by myself.");
                        continue;
                    }
                    logger.debug("Receive a message with " + packet.getLength() + " bytes.");
                    byte[] data = new byte[packet.getLength()];
                    System.arraycopy(packet.getData(), 0, data, 0, packet.getLength());
                    List<ServiceMessage> messages = ServiceMessage.manyFromDatagram(data);
                    if (messages.size() > 0) {
                        if (messages.getFirst().isProbe()) {
                            ArrayList<ServiceMessage> replies = new ArrayList<ServiceMessage>();
                            for (ServiceMessage m : messages) {
                                ServiceMessage reply = this.discoveryProtocolsData.get(m.getServiceName());
                                if (reply == null) continue;
                                replies.add(reply);
                            }
                            for (byte[] bm : ServiceMessage.convertToMessage(replies, false)) {
                                this.socket.send(new DatagramPacket(bm, bm.length, packet.getAddress(), packet.getPort()));
                            }
                        }
                        if (this.protocolsWaiting.size() <= 0) continue;
                        Iterator<ServiceMessage> iterator = messages.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            ServiceMessage m = iterator.next();
                            DiscoverableProtocol dp = this.protocolsWaiting.get(m.getServiceName());
                            if (dp == null) continue;
                            dp.addContact(m.getServiceHost());
                            if (!dp.needsDiscovery()) {
                                this.protocolsWaiting.remove(m.getServiceName());
                            }
                            if (dp.hasProtocolThreadStarted() || !dp.readyToStart()) continue;
                            dp.start();
                            dp.startEventThread();
                        }
                    }
                    logger.warn("Could not deserialize any service message from received datagram.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

