/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.discovery.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pt.unl.fct.di.novasys.network.data.Host;

public class ServiceMessage {
    public static final int DATAGRAM_SIZE = 65507;
    public static final byte[] probeID = new byte[]{66, 80, 68, 80};
    public static final byte[] announceID = new byte[]{66, 80, 68, 65};
    private final byte[] id;
    private final String serviceName;
    private final Host serviceHost;
    private final Host discoveryHost;

    public ServiceMessage(String serviceName, Host serviceHost, Host discoveryHost) {
        this.id = probeID;
        this.serviceName = serviceName;
        this.serviceHost = serviceHost;
        this.discoveryHost = discoveryHost;
    }

    public ServiceMessage(byte[] rid, String serviceName, Host serviceHost, Host discoveryHost) throws Exception {
        if (Arrays.compare(rid, probeID) == 0) {
            this.id = probeID;
        } else if (Arrays.compare(rid, announceID) == 0) {
            this.id = announceID;
        } else {
            throw new Exception("Malformed ServiceMessage. No valid identifier: " + String.valueOf(rid));
        }
        this.serviceName = serviceName;
        this.serviceHost = serviceHost;
        this.discoveryHost = discoveryHost;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Host getServiceHost() {
        return this.serviceHost;
    }

    public Host getDiscoveryHost() {
        return this.discoveryHost;
    }

    public boolean isProbe() {
        return this.id == probeID;
    }

    public static byte[] convertToMessage(ServiceMessage m, boolean asProbe) throws IOException {
        ByteBuf buffer = Unpooled.wrappedBuffer(new byte[65507]);
        buffer.clear();
        if (asProbe) {
            buffer.writeBytes(probeID);
        } else {
            buffer.writeBytes(announceID);
        }
        buffer.writeInt(m.serviceName.getBytes().length);
        buffer.writeBytes(m.serviceName.getBytes());
        Host.serializer.serialize(m.serviceHost, buffer);
        Host.serializer.serialize(m.discoveryHost, buffer);
        return buffer.capacity(buffer.readableBytes()).array();
    }

    public static ServiceMessage fromDatagram(byte[] data) throws Exception {
        ByteBuf buffer = Unpooled.wrappedBuffer(data);
        buffer.resetReaderIndex();
        byte[] rid = new byte[4];
        buffer.readBytes(rid);
        byte[] serviceName = new byte[buffer.readInt()];
        buffer.readBytes(serviceName);
        Host seviceHost = Host.serializer.deserialize(buffer);
        Host discoveryHost = Host.serializer.deserialize(buffer);
        return new ServiceMessage(rid, new String(serviceName), seviceHost, discoveryHost);
    }

    public static List<byte[]> convertToMessage(Collection<ServiceMessage> ms, boolean asProbe) throws IOException {
        ByteBuf buffer = Unpooled.wrappedBuffer(new byte[65507]);
        buffer.clear();
        ArrayList<byte[]> messages = new ArrayList<byte[]>();
        for (ServiceMessage m : ms) {
            byte[] bm = ServiceMessage.convertToMessage(m, asProbe);
            if (buffer.capacity() - buffer.writerIndex() < 16 + bm.length) {
                messages.add(buffer.capacity(buffer.readableBytes()).array());
                buffer = Unpooled.wrappedBuffer(new byte[65507]);
            }
            buffer.writeShort(Integer.valueOf(bm.length).shortValue());
            buffer.writeBytes(bm);
        }
        if (buffer.isReadable()) {
            messages.add(buffer.capacity(buffer.readableBytes()).array());
        }
        return messages;
    }

    public static List<ServiceMessage> manyFromDatagram(byte[] data) {
        ArrayList<ServiceMessage> messages = new ArrayList<ServiceMessage>();
        ByteBuf buffer = Unpooled.wrappedBuffer(data);
        buffer.resetReaderIndex();
        while (buffer.isReadable()) {
            byte[] msg = new byte[buffer.readShort()];
            buffer.readBytes(msg);
            try {
                messages.add(ServiceMessage.fromDatagram(msg));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return messages;
    }
}

