/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.util.OptionalDouble;
import java.util.concurrent.ConcurrentLinkedQueue;
import pt.unl.fct.di.novasys.babel.metrics.Metric;

public class Reducer
extends Metric {
    private final ConcurrentLinkedQueue<Double> collection;
    private final Operation op;

    public Reducer(String name, boolean logPeriodically, long period, boolean resetOnLog, Operation op) {
        super(name, logPeriodically, period, false, resetOnLog);
        this.op = op;
        this.collection = new ConcurrentLinkedQueue();
    }

    public synchronized void add(Double val) {
        this.collection.add(val);
    }

    @Override
    protected synchronized void reset() {
        this.collection.clear();
    }

    @Override
    protected synchronized String computeValue() {
        String res;
        int nEntries = this.collection.size();
        switch (this.op) {
            case AVG: {
                OptionalDouble val = this.collection.stream().mapToDouble(i -> i).average();
                res = val.isPresent() ? String.valueOf(val.getAsDouble()) : "null";
                break;
            }
            case MAX: {
                OptionalDouble maxVal = this.collection.stream().mapToDouble(i -> i).max();
                res = maxVal.isPresent() ? String.valueOf(maxVal.getAsDouble()) : "null";
                break;
            }
            case MIN: {
                OptionalDouble minVal = this.collection.stream().mapToDouble(i -> i).min();
                res = minVal.isPresent() ? String.valueOf(minVal.getAsDouble()) : "null";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.op));
            }
        }
        return res + " " + nEntries;
    }

    public static enum Operation {
        AVG,
        MAX,
        MIN;

    }
}

