/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.accrual;

import java.util.LinkedList;

public class HeartbeatHistory {
    private final int maxSampleSize;
    private final long firstHeartbeatEstimateMs;
    private final LinkedList<Long> intervals;
    private long intervalSum;
    private long squaredIntervalSum;

    public HeartbeatHistory(int maxSampleSize, long firstHeartbeatEstimateMs) {
        this.maxSampleSize = maxSampleSize;
        this.firstHeartbeatEstimateMs = firstHeartbeatEstimateMs;
        this.intervals = new LinkedList();
        this.intervalSum = 0L;
        this.squaredIntervalSum = 0L;
    }

    public double mean() {
        return this.isEmpty() ? (double)this.firstHeartbeatEstimateMs : (double)this.intervalSum / (double)this.intervals.size();
    }

    public double stdDev() {
        return this.isEmpty() ? this.mean() / 4.0 : Math.sqrt(this.variance());
    }

    private double variance() {
        return (double)this.squaredIntervalSum / (double)this.intervals.size() - this.mean() * this.mean();
    }

    public void add(long interval) {
        if (this.intervals.size() >= this.maxSampleSize) {
            this.dropOldest();
        }
        this.intervals.addLast(interval);
        this.intervalSum += interval;
        this.squaredIntervalSum += interval * interval;
    }

    private void dropOldest() {
        long oldest = this.intervals.removeFirst();
        this.intervalSum -= oldest;
        this.squaredIntervalSum -= oldest * oldest;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public int size() {
        return this.intervals.size();
    }
}

