/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.messaging.NetworkMessage;
import pt.unl.fct.di.novasys.network.messaging.control.ControlMessage;

public class MessageEncoder<T>
extends MessageToByteEncoder<NetworkMessage> {
    private static final Logger logger = LogManager.getLogger(MessageEncoder.class);
    private final ISerializer<T> serializer;
    private long sentAppBytes;
    private long sentControlBytes;
    private long sentAppMessages;
    private long sentControlMessages;

    public MessageEncoder(ISerializer<T> serializer) {
        this.serializer = serializer;
        this.sentAppBytes = 0L;
        this.sentAppMessages = 0L;
        this.sentControlBytes = 0L;
        this.sentControlMessages = 0L;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, NetworkMessage msg, ByteBuf out) throws IOException {
        int sizeIndex = out.writerIndex();
        out.writeInt(-1);
        int startIndex = out.writerIndex();
        out.writeByte(msg.code);
        switch (msg.code) {
            case 0: {
                ControlMessage.serializer.serialize((ControlMessage)msg.payload, out);
                ++this.sentControlMessages;
                this.sentControlBytes += (long)(out.writerIndex() - sizeIndex);
                break;
            }
            case 1: {
                this.serializer.serialize(msg.payload, out);
                ++this.sentAppMessages;
                this.sentAppBytes += (long)(out.writerIndex() - sizeIndex);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown msg code in encoder: " + msg));
            }
        }
        int serializedSize = out.writerIndex() - startIndex;
        out.markWriterIndex();
        out.writerIndex(sizeIndex);
        out.writeInt(serializedSize);
        out.resetWriterIndex();
    }

    public long getSentAppBytes() {
        return this.sentAppBytes;
    }

    public long getSentAppMessages() {
        return this.sentAppMessages;
    }

    public long getSentControlBytes() {
        return this.sentControlBytes;
    }

    public long getSentControlMessages() {
        return this.sentControlMessages;
    }
}

