/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.HyParView;
import pt.unl.fct.di.novasys.babel.utils.NetworkingUtilities;
import pt.unl.fct.di.novasys.babel.utils.memebership.monitor.MembershipMonitor;
import pt.unl.fct.di.novasys.network.data.Host;

public class Main {
    private static final Logger logger;
    private static final String DEFAULT_CONF = "tardis.conf";

    public static void main(String[] args) throws Exception {
        logger.info("Starting...");
        Babel babel = Babel.getInstance();
        if (new File(DEFAULT_CONF).exists()) {
            System.err.println("The config file: tardis.conf is not accessible.");
            System.exit(1);
        }
        Properties props = babel.loadConfig(args, DEFAULT_CONF);
        String address = null;
        if (props.containsKey("babel.interface")) {
            address = NetworkingUtilities.getAddress(props.getProperty("babel.interface"));
        } else if (props.containsKey("babel.address")) {
            address = props.getProperty("babel.address");
        }
        int port = -1;
        if (props.containsKey("babel.port")) {
            port = Integer.parseInt(props.getProperty("babel.port"));
        }
        Host h = null;
        if (address == null || port == -1) {
            System.err.println("Configuration must contain one of 'babel.interface' or 'babel.address' and the 'babel.port'");
        } else {
            h = new Host(InetAddress.getByName(address), port);
        }
        HyParView hyparview = new HyParView("channel.hyparview", props, h);
        MembershipMonitor mm = new MembershipMonitor();
        babel.registerProtocol(hyparview);
        babel.registerProtocol(mm);
        hyparview.init(props);
        mm.init(props);
        System.out.println("Setup is complete.");
        babel.start();
        System.out.println("System is running.");
    }

    static {
        System.setProperty("log4j.configurationFile", "log4j2.xml");
        System.setProperty("java.net.preferIPv4Stack", "true");
        logger = LogManager.getLogger(Main.class);
    }
}

