/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.connection;

import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import edu.umd.cs.findbugs.annotations.NonNull;

public class BusyConnectionException
extends DriverException {
    public BusyConnectionException(int maxAvailableIds) {
        this(String.format("Connection has exceeded its maximum of %d simultaneous requests", maxAvailableIds), null, false);
    }

    private BusyConnectionException(String message, ExecutionInfo executionInfo, boolean writableStackTrace) {
        super(message, executionInfo, null, writableStackTrace);
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new BusyConnectionException(this.getMessage(), this.getExecutionInfo(), true);
    }
}

