/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class FunctionSignature {
    @NonNull
    private final CqlIdentifier name;
    @NonNull
    private final List<DataType> parameterTypes;

    public FunctionSignature(@NonNull CqlIdentifier name, @NonNull Iterable<DataType> parameterTypes) {
        this.name = name;
        this.parameterTypes = ImmutableList.copyOf(parameterTypes);
    }

    public FunctionSignature(@NonNull CqlIdentifier name, DataType ... parameterTypes) {
        this(name, parameterTypes.length == 0 ? ImmutableList.of() : ((ImmutableList.Builder)ImmutableList.builder().add(parameterTypes)).build());
    }

    public FunctionSignature(@NonNull String name, @NonNull Iterable<DataType> parameterTypes) {
        this(CqlIdentifier.fromCql(name), parameterTypes);
    }

    public FunctionSignature(@NonNull String name, DataType ... parameterTypes) {
        this(CqlIdentifier.fromCql(name), parameterTypes);
    }

    @NonNull
    public CqlIdentifier getName() {
        return this.name;
    }

    @NonNull
    public List<DataType> getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof FunctionSignature) {
            FunctionSignature that = (FunctionSignature)other;
            return this.name.equals(that.name) && this.parameterTypes.equals(that.parameterTypes);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parameterTypes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name.asInternal()).append('(');
        boolean first = true;
        for (DataType type : this.parameterTypes) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(type.asCql(true, true));
        }
        return builder.append(')').toString();
    }
}

