/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.NodesRefresh;
import com.datastax.oss.driver.internal.core.metadata.token.DefaultTokenMap;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactoryRegistry;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class FullNodeListRefresh
extends NodesRefresh {
    private static final Logger LOG = LoggerFactory.getLogger(FullNodeListRefresh.class);
    @VisibleForTesting
    final Iterable<NodeInfo> nodeInfos;

    FullNodeListRefresh(Iterable<NodeInfo> nodeInfos) {
        this.nodeInfos = nodeInfos;
    }

    @Override
    public MetadataRefresh.Result compute(DefaultMetadata oldMetadata, boolean tokenMapEnabled, InternalDriverContext context) {
        String logPrefix = context.getSessionName();
        TokenFactoryRegistry tokenFactoryRegistry = context.getTokenFactoryRegistry();
        Map<UUID, Node> oldNodes = oldMetadata.getNodes();
        HashMap<UUID, DefaultNode> added = new HashMap<UUID, DefaultNode>();
        HashSet<UUID> seen = new HashSet<UUID>();
        TokenFactory tokenFactory = oldMetadata.getTokenMap().map(m -> ((DefaultTokenMap)m).getTokenFactory()).orElse(null);
        boolean tokensChanged = false;
        for (NodeInfo nodeInfo : this.nodeInfos) {
            UUID id = nodeInfo.getHostId();
            seen.add(id);
            DefaultNode node = (DefaultNode)oldNodes.get(id);
            if (node == null) {
                node = new DefaultNode(nodeInfo.getEndPoint(), context);
                LOG.debug("[{}] Adding new node {}", (Object)logPrefix, (Object)node);
                added.put(id, node);
            }
            if (tokenFactory == null && nodeInfo.getPartitioner() != null) {
                tokenFactory = tokenFactoryRegistry.tokenFactoryFor(nodeInfo.getPartitioner());
            }
            tokensChanged |= FullNodeListRefresh.copyInfos(nodeInfo, node, tokenFactory, logPrefix);
        }
        Sets.SetView<UUID> removed = Sets.difference(oldNodes.keySet(), seen);
        if (added.isEmpty() && removed.isEmpty()) {
            if (!oldMetadata.getTokenMap().isPresent() && tokenFactory != null) {
                return new MetadataRefresh.Result(oldMetadata.withNodes(oldMetadata.getNodes(), tokenMapEnabled, true, tokenFactory, context));
            }
            return new MetadataRefresh.Result(oldMetadata);
        }
        ImmutableMap.Builder newNodesBuilder = ImmutableMap.builder();
        ImmutableList.Builder eventsBuilder = ImmutableList.builder();
        newNodesBuilder.putAll(added);
        for (Map.Entry<UUID, Node> entry : oldNodes.entrySet()) {
            if (removed.contains(entry.getKey())) continue;
            newNodesBuilder.put(entry.getKey(), entry.getValue());
        }
        for (Node node : added.values()) {
            eventsBuilder.add(NodeStateEvent.added((DefaultNode)node));
        }
        for (UUID id : removed) {
            Node node = oldNodes.get(id);
            eventsBuilder.add(NodeStateEvent.removed((DefaultNode)node));
        }
        return new MetadataRefresh.Result(oldMetadata.withNodes(newNodesBuilder.build(), tokenMapEnabled, tokensChanged, tokenFactory, context), (List<Object>)((Object)eventsBuilder.build()));
    }
}

