/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
abstract class NodesRefresh
implements MetadataRefresh {
    private static final Logger LOG = LoggerFactory.getLogger(NodesRefresh.class);

    NodesRefresh() {
    }

    protected static boolean copyInfos(NodeInfo nodeInfo, DefaultNode node, TokenFactory tokenFactory, String logPrefix) {
        boolean tokensChanged;
        node.broadcastRpcAddress = nodeInfo.getBroadcastRpcAddress().orElse(null);
        node.broadcastAddress = nodeInfo.getBroadcastAddress().orElse(null);
        node.listenAddress = nodeInfo.getListenAddress().orElse(null);
        node.datacenter = nodeInfo.getDatacenter();
        node.rack = nodeInfo.getRack();
        node.hostId = Objects.requireNonNull(nodeInfo.getHostId());
        node.schemaVersion = nodeInfo.getSchemaVersion();
        String versionString = nodeInfo.getCassandraVersion();
        try {
            node.cassandraVersion = Version.parse(versionString);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("[{}] Error converting Cassandra version '{}' for {}", logPrefix, versionString, node.getEndPoint());
        }
        boolean bl = tokensChanged = tokenFactory != null && !node.rawTokens.equals(nodeInfo.getTokens());
        if (tokensChanged) {
            node.rawTokens = nodeInfo.getTokens();
        }
        node.extras = nodeInfo.getExtras() == null ? Collections.emptyMap() : ImmutableMap.copyOf(nodeInfo.getExtras());
        return tokensChanged;
    }
}

