/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class StringCodec
implements TypeCodec<String> {
    private final DataType cqlType;
    private final Charset charset;

    public StringCodec(@NonNull DataType cqlType, @NonNull Charset charset) {
        this.cqlType = cqlType;
        this.charset = charset;
    }

    @Override
    @NonNull
    public GenericType<String> getJavaType() {
        return GenericType.STRING;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof String;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == String.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable String value, @NonNull ProtocolVersion protocolVersion) {
        return value == null ? null : ByteBuffer.wrap(value.getBytes(this.charset));
    }

    @Override
    @Nullable
    public String decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        if (bytes.remaining() == 0) {
            return "";
        }
        return new String(Bytes.getArray(bytes), this.charset);
    }

    @Override
    @NonNull
    public String format(@Nullable String value) {
        return value == null ? "NULL" : Strings.quote(value);
    }

    @Override
    @Nullable
    public String parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!Strings.isQuoted(value)) {
            throw new IllegalArgumentException("text or varchar values must be enclosed by single quotes");
        }
        return Strings.unquote(value);
    }
}

