/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class TupleCodec
implements TypeCodec<TupleValue> {
    private final TupleType cqlType;

    public TupleCodec(@NonNull TupleType cqlType) {
        this.cqlType = cqlType;
    }

    @Override
    @NonNull
    public GenericType<TupleValue> getJavaType() {
        return GenericType.TUPLE_VALUE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof TupleValue && ((TupleValue)value).getType().equals(this.cqlType);
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return TupleValue.class.equals(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable TupleValue value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        if (!value.getType().equals(this.cqlType)) {
            throw new IllegalArgumentException(String.format("Invalid tuple type, expected %s but got %s", this.cqlType, value.getType()));
        }
        int toAllocate = 0;
        for (int i = 0; i < value.size(); ++i) {
            ByteBuffer field = value.getBytesUnsafe(i);
            toAllocate += 4 + (field == null ? 0 : field.remaining());
        }
        ByteBuffer result = ByteBuffer.allocate(toAllocate);
        for (int i = 0; i < value.size(); ++i) {
            ByteBuffer field = value.getBytesUnsafe(i);
            if (field == null) {
                result.putInt(-1);
                continue;
            }
            result.putInt(field.remaining());
            result.put(field.duplicate());
        }
        return (ByteBuffer)result.flip();
    }

    @Override
    @Nullable
    public TupleValue decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteBuffer input = bytes.duplicate();
            TupleValue value = this.cqlType.newValue();
            int i = 0;
            while (input.hasRemaining()) {
                ByteBuffer element;
                if (i > this.cqlType.getComponentTypes().size()) {
                    throw new IllegalArgumentException(String.format("Too many fields in encoded tuple, expected %d", this.cqlType.getComponentTypes().size()));
                }
                int elementSize = input.getInt();
                if (elementSize == -1) {
                    element = null;
                } else {
                    element = input.slice();
                    element.limit(elementSize);
                    input.position(input.position() + elementSize);
                }
                value = (TupleValue)value.setBytesUnsafe(i, element);
                ++i;
            }
            return value;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalArgumentException("Not enough bytes to deserialize a tuple", e);
        }
    }

    @Override
    @NonNull
    public String format(@Nullable TupleValue value) {
        if (value == null) {
            return "NULL";
        }
        if (!value.getType().equals(this.cqlType)) {
            throw new IllegalArgumentException(String.format("Invalid tuple type, expected %s but got %s", this.cqlType, value.getType()));
        }
        CodecRegistry registry = this.cqlType.getAttachmentPoint().getCodecRegistry();
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (int i = 0; i < value.size(); ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            DataType elementType = this.cqlType.getComponentTypes().get(i);
            TypeCodec<DataType> codec = registry.codecFor(elementType);
            sb.append(codec.format(value.get(i, codec)));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    @Nullable
    public TupleValue parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        TupleValue tuple = this.cqlType.newValue();
        int position = ParseUtils.skipSpaces(value, 0);
        if (value.charAt(position++) != '(') {
            throw new IllegalArgumentException(String.format("Cannot parse tuple value from \"%s\", at character %d expecting '(' but got '%c'", value, position, Character.valueOf(value.charAt(position))));
        }
        if (value.charAt(position = ParseUtils.skipSpaces(value, position)) == ')') {
            return tuple;
        }
        CodecRegistry registry = this.cqlType.getAttachmentPoint().getCodecRegistry();
        int i = 0;
        while (position < value.length()) {
            int n;
            try {
                n = ParseUtils.skipCQLValue(value, position);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse tuple value from \"%s\", invalid CQL value at character %d", value, position), e);
            }
            String fieldValue = value.substring(position, n);
            DataType elementType = this.cqlType.getComponentTypes().get(i);
            TypeCodec<DataType> codec = registry.codecFor(elementType);
            tuple = (TupleValue)tuple.set(i, codec.parse(fieldValue), codec);
            position = n;
            ++i;
            position = ParseUtils.skipSpaces(value, position);
            if (value.charAt(position) == ')') {
                return tuple;
            }
            if (value.charAt(position) != ',') {
                throw new IllegalArgumentException(String.format("Cannot parse tuple value from \"%s\", at character %d expecting ',' but got '%c'", value, position, Character.valueOf(value.charAt(position))));
            }
            ++position;
            position = ParseUtils.skipSpaces(value, position);
        }
        throw new IllegalArgumentException(String.format("Malformed tuple value \"%s\", missing closing ')'", value));
    }
}

