/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.DiscoverableProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.DiscoveryProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.messages.ServiceMessage;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.timers.AnoucementTimer;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.network.data.Host;

public class MulticastDiscoveryProtocol
extends DiscoveryProtocol {
    private static final Logger logger = LogManager.getLogger(MulticastDiscoveryProtocol.class);
    public static final int DEFAULT_MULTICAST_PORT = 1025;
    public static final int DEFAULT_UNICAST_PORT = 1026;
    public static final String MULTICAST_ADDRESS = "233.138.122.123";
    public static final int ANOUNCEMENT_COOLDOWN = 1000;
    public static final short PROTO_ID = 32500;
    public static final String PROTO_NAME = "BabelMulticastDiscovery";
    public static final String PAR_DISCOVERY_MULTICAST_INTERFACE = "babel.discovery.multicast.interface";
    public static final String PAR_DISCOVERY_MULTICAST_ADDRESS = "babel.discovery.multicast.addr";
    public static final String PAR_DISCOVERY_MULTICAST_PORT = "babel.discovery.multicast.port";
    private MulticastSocket multicastSocket;
    private DatagramSocket unicastSocket;
    private Map<String, ServiceMessage> discoveryProtocolsData;
    private Map<String, DiscoverableProtocol> protocolsWaiting;
    private InetSocketAddress multicastSocketAddress;
    private Host discoveryHost;
    private Thread listeningMulticastThread;
    private Thread listeningUnicastThread;

    public MulticastDiscoveryProtocol() {
        super(PROTO_NAME, (short)32500);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        if (!props.containsKey("babel.discovery.unicast.interface") && props.containsKey("babel.interface")) {
            props.put("babel.discovery.unicast.interface", props.get("babel.interface"));
        }
        if (!props.containsKey(PAR_DISCOVERY_MULTICAST_INTERFACE) && props.containsKey("babel.interface")) {
            props.put(PAR_DISCOVERY_MULTICAST_INTERFACE, props.get("babel.interface"));
        }
        if (!props.containsKey("babel.discovery.unicast.address") && props.containsKey("babel.address")) {
            props.put("babel.discovery.unicast.address", props.get("babel.address"));
        }
        this.discoveryProtocolsData = new HashMap<String, ServiceMessage>();
        this.protocolsWaiting = new HashMap<String, DiscoverableProtocol>();
        int targetPort = 1025;
        if (props.containsKey(PAR_DISCOVERY_MULTICAST_PORT)) {
            targetPort = Integer.parseInt(props.getProperty(PAR_DISCOVERY_MULTICAST_PORT));
        }
        this.multicastSocketAddress = new InetSocketAddress(props.getProperty(PAR_DISCOVERY_MULTICAST_ADDRESS, MULTICAST_ADDRESS), targetPort);
        NetworkInterface networkInterface = !props.containsKey(PAR_DISCOVERY_MULTICAST_INTERFACE) ? NetworkInterface.networkInterfaces().filter(i -> {
            try {
                return i.supportsMulticast();
            }
            catch (SocketException e) {
                e.printStackTrace();
                return false;
            }
        }).findAny().orElseThrow(() -> new RuntimeException("No network interface supports multicast")) : NetworkInterface.getByName(props.getProperty(PAR_DISCOVERY_MULTICAST_INTERFACE));
        this.multicastSocket = new MulticastSocket(targetPort);
        System.err.println("Multicast is going to use interface: " + networkInterface.getDisplayName());
        this.multicastSocket.joinGroup(this.multicastSocketAddress, networkInterface);
        logger.info("DiscoveryProtocol set up");
        InetAddress address = null;
        if (props.containsKey("babel.discovery.unicast.address")) {
            address = InetAddress.getByName(props.getProperty("babel.discovery.unicast.address"));
        } else if (props.containsKey("babel.discovery.unicast.interface")) {
            List<InterfaceAddress> l = NetworkInterface.getByName(props.getProperty("babel.discovery.unicast.interface")).getInterfaceAddresses();
            for (InterfaceAddress a : l) {
                if (a.getAddress() != null && a.getAddress() instanceof Inet4Address) {
                    address = a.getAddress();
                } else if (address == null) continue;
                break;
            }
        } else {
            Iterator iterator = NetworkInterface.networkInterfaces().distinct().iterator();
            while (iterator.hasNext()) {
                InterfaceAddress a;
                NetworkInterface n = (NetworkInterface)iterator.next();
                if (n.isLoopback() || n.isVirtual() || !n.isUp() || n.isPointToPoint()) continue;
                Iterator<InterfaceAddress> iterator2 = n.getInterfaceAddresses().iterator();
                if (iterator2.hasNext() && (a = iterator2.next()).getAddress() != null && a.getAddress() instanceof Inet4Address) {
                    address = a.getAddress();
                }
                if (address == null) continue;
                break;
            }
        }
        int unicastPort = 1026;
        if (props.containsKey("babel.discovery.unicast.port")) {
            unicastPort = Integer.parseInt(props.getProperty("babel.discovery.unicast.port"));
        }
        this.discoveryHost = new Host(address, unicastPort);
        this.unicastSocket = new DatagramSocket(unicastPort, address);
        this.registerTimerHandler((short)32501, this::announce);
        this.setupPeriodicTimer(new AnoucementTimer(), 1000L, 1000L);
        this.listeningMulticastThread = new Thread(() -> this.listen(this.multicastSocket));
        this.listeningUnicastThread = new Thread(() -> this.listen(this.unicastSocket));
        this.listeningMulticastThread.start();
        this.listeningUnicastThread.start();
        logger.info("DiscoveryProtocol initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announce(AnoucementTimer timer, long timerId) {
        logger.info("Firing anouncements");
        ArrayList<ServiceMessage> pendingServices = new ArrayList<ServiceMessage>();
        Map<String, DiscoverableProtocol> map = this.protocolsWaiting;
        synchronized (map) {
            if (this.protocolsWaiting.size() == 0) {
                logger.debug("No protocols waiting registered");
                return;
            }
            for (String protocol : this.protocolsWaiting.keySet()) {
                pendingServices.add(this.discoveryProtocolsData.get(protocol));
                logger.debug("Added protocol " + protocol + " to seend buffer");
            }
        }
        try {
            List<byte[]> announces = ServiceMessage.convertToMessage(pendingServices, true);
            for (byte[] m : announces) {
                this.unicastSocket.send(new DatagramPacket(m, m.length, this.multicastSocketAddress.getAddress(), this.multicastSocketAddress.getPort()));
                logger.debug("Sent one multicast message to " + String.valueOf(this.multicastSocketAddress.getAddress()) + ":" + this.multicastSocketAddress.getPort() + " from " + String.valueOf(this.unicastSocket.getLocalAddress()) + ":" + this.unicastSocket.getLocalPort());
            }
        }
        catch (Exception e) {
            logger.error("Could not send announcements.");
            e.printStackTrace();
        }
    }

    @Override
    public void registerProtocol(DiscoverableProtocol dcProto) {
        this.discoveryProtocolsData.put(dcProto.getProtoName(), new ServiceMessage(dcProto.getProtoName(), dcProto.getMyself(), this.discoveryHost));
        if (dcProto.needsDiscovery()) {
            this.protocolsWaiting.put(dcProto.getProtoName(), dcProto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen(DatagramSocket socket) {
        block5: while (true) {
            try {
                while (true) {
                    DatagramPacket packet = new DatagramPacket(new byte[65507], 65507);
                    socket.receive(packet);
                    logger.debug("Discovery has received a message from " + packet.getAddress().getHostAddress() + ":" + packet.getPort() + "on " + (socket instanceof MulticastSocket ? "MulticastSocket" : "UnicastSocket"));
                    if (packet.getAddress().equals(this.unicastSocket.getLocalAddress()) && packet.getPort() == this.unicastSocket.getLocalPort()) {
                        logger.debug("Discarding multicast packet sent by myself.");
                        continue;
                    }
                    byte[] data = new byte[packet.getLength()];
                    System.arraycopy(packet.getData(), 0, data, 0, packet.getLength());
                    List<ServiceMessage> messages = ServiceMessage.manyFromDatagram(data);
                    if (messages.size() > 0) {
                        if (messages.getFirst().isProbe()) {
                            ArrayList<ServiceMessage> replies = new ArrayList<ServiceMessage>();
                            for (ServiceMessage m : messages) {
                                ServiceMessage reply = this.discoveryProtocolsData.get(m.getServiceName());
                                if (reply == null) continue;
                                replies.add(reply);
                            }
                            for (byte[] bm : ServiceMessage.convertToMessage(replies, false)) {
                                this.unicastSocket.send(new DatagramPacket(bm, bm.length, packet.getAddress(), packet.getPort()));
                                logger.debug("Sent a reply back to announcer with " + bm.length + " bytes");
                            }
                        }
                        Map<String, DiscoverableProtocol> map = this.protocolsWaiting;
                        synchronized (map) {
                            if (this.protocolsWaiting.size() > 0) {
                                for (ServiceMessage m : messages) {
                                    DiscoverableProtocol dp = this.protocolsWaiting.get(m.getServiceName());
                                    if (dp == null) continue;
                                    dp.addContact(m.getServiceHost());
                                    if (!dp.needsDiscovery()) {
                                        this.protocolsWaiting.remove(m.getServiceName());
                                    }
                                    if (dp.hasProtocolThreadStarted() || !dp.readyToStart()) continue;
                                    dp.start();
                                    dp.startEventThread();
                                }
                            }
                            continue block5;
                        }
                    }
                    logger.warn("Could not deserialize any service message from received datagram.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

