/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.SelfConfigurableProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.Parameter;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.SelfConfigurationProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.messages.ParameterMessage;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.timers.SearchTimer;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.utils.NetworkingUtilities;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.data.Host;

public class SimpleCopySelfConfigurationProtocol
extends SelfConfigurationProtocol {
    private static final Logger logger = LogManager.getLogger(SimpleCopySelfConfigurationProtocol.class);
    public static final String DEFAULT_PORT = "19349";
    public static final short PROTO_ID = 604;
    public static final String PROTO_NAME = "BabelSelfConfiguration";
    public static final int SEARCH_COOLDOWN = 5000;
    private final Map<String, Map<String, Parameter>> protocolToParameterToConfigure = new ConcurrentHashMap<String, Map<String, Parameter>>();
    private final Map<String, Map<String, Parameter>> protocolToParameterConfigured = new ConcurrentHashMap<String, Map<String, Parameter>>();
    private final Map<String, SelfConfigurableProtocol> protocolMap = new ConcurrentHashMap<String, SelfConfigurableProtocol>();
    private final Map<Host, ParameterMessage> msgToSend = new HashMap<Host, ParameterMessage>();
    private int defaultChannelID;

    public SimpleCopySelfConfigurationProtocol() {
        super(PROTO_NAME, (short)604);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        String networkInterface = props.getProperty("BabelWhisperer.Unicast.Interface");
        String address = null;
        if (networkInterface == null) {
            address = props.getProperty("BabelWhisperer.Unicast.Address");
            if (address == null) {
                address = NetworkingUtilities.getAddress("eth0");
            }
        } else {
            address = NetworkingUtilities.getAddress(networkInterface);
        }
        String port = props.getProperty("BabelWhisperer.Unicast.Port", DEFAULT_PORT);
        Properties channelProps = new Properties(2);
        channelProps.setProperty("address", address);
        channelProps.setProperty("port", port);
        this.defaultChannelID = this.createChannel("TCPChannel", channelProps);
        this.registerChannelEventHandler(this.defaultChannelID, (short)1, this::uponInConnectionDown);
        this.registerChannelEventHandler(this.defaultChannelID, (short)2, this::uponInConnectionUp);
        this.registerChannelEventHandler(this.defaultChannelID, (short)3, this::uponOutConnectionDown);
        this.registerChannelEventHandler(this.defaultChannelID, (short)5, this::uponOutConnectionUp);
        this.registerChannelEventHandler(this.defaultChannelID, (short)4, this::uponOutConnectionFailed);
        this.registerMessageSerializer(this.defaultChannelID, (short)10604, ParameterMessage.serializer);
        this.registerMessageHandler(this.defaultChannelID, (short)10604, this::uponParameterMessage, this::uponMessageFailed);
        this.registerTimerHandler((short)341, this::search);
        this.setupPeriodicTimer(new SearchTimer(), 5000L, 5000L);
    }

    @Override
    public void addProtocolParameterToConfigure(String parameterName, Method setter, Method getter, SelfConfigurableProtocol proto) {
        Parameter parameter = new Parameter(getter, setter, proto);
        Map<String, Parameter> protocolParameters = this.protocolToParameterToConfigure.get(proto.getProtoName());
        if (protocolParameters == null) {
            protocolParameters = new ConcurrentHashMap<String, Parameter>();
            this.protocolToParameterToConfigure.put(proto.getProtoName(), protocolParameters);
        }
        protocolParameters.put(parameterName, parameter);
        this.protocolMap.put(proto.getProtoName(), proto);
    }

    @Override
    public void addProtocolParameterConfigured(String parameterName, Method setter, Method getter, SelfConfigurableProtocol proto) {
        Parameter parameter = new Parameter(getter, setter, proto);
        Map<String, Parameter> protocolParameter = this.protocolToParameterConfigured.get(proto.getProtoName());
        if (protocolParameter == null) {
            protocolParameter = new ConcurrentHashMap<String, Parameter>();
            this.protocolToParameterConfigured.put(proto.getProtoName(), protocolParameter);
        }
        protocolParameter.put(parameterName, parameter);
        this.protocolMap.put(proto.getProtoName(), proto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(SearchTimer timer, long timerId) {
        logger.info("Trying to search");
        for (Map.Entry<String, Map<String, Parameter>> protoEntry : this.protocolToParameterToConfigure.entrySet()) {
            Host protoHost = this.protocolMap.get(protoEntry.getKey()).getWhisperer();
            Map<Host, ParameterMessage> map = this.msgToSend;
            synchronized (map) {
                ParameterMessage msg = this.msgToSend.get(protoHost);
                if (msg == null) {
                    msg = new ParameterMessage();
                    this.msgToSend.put(protoHost, msg);
                    logger.info("Opening connection to " + String.valueOf(protoHost));
                    this.openConnection(protoHost, this.defaultChannelID);
                }
                for (Map.Entry<String, Parameter> paramEntry : protoEntry.getValue().entrySet()) {
                    msg.addAskingParameter(protoEntry.getKey(), paramEntry.getKey());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uponParameterMessage(ParameterMessage msg, Host from, short sourceProto, int channelId) {
        logger.info("Got parameter message from " + String.valueOf(from));
        Map<String, Map<String, String>> receivedParams = msg.getAllProtocolParams();
        ParameterMessage replyMsg = new ParameterMessage();
        for (Map.Entry<String, Map<String, String>> protoEntry : receivedParams.entrySet()) {
            SelfConfigurableProtocol proto = this.protocolMap.get(protoEntry.getKey());
            boolean wasNotReady = proto.readyToStart();
            Map<String, Parameter> thisProtocolToConfigure = this.protocolToParameterToConfigure.get(protoEntry.getKey());
            Map<String, Parameter> thisProtocolConfigured = this.protocolToParameterConfigured.get(protoEntry.getKey());
            for (Map.Entry<String, String> paramEntry : protoEntry.getValue().entrySet()) {
                Parameter paramConfigured;
                Parameter paramToConfigure = thisProtocolToConfigure != null ? thisProtocolToConfigure.get(paramEntry.getKey()) : null;
                Parameter parameter = paramConfigured = thisProtocolConfigured != null ? thisProtocolConfigured.get(paramEntry.getKey()) : null;
                if (paramEntry.getValue() != null && paramToConfigure != null) {
                    try {
                        paramToConfigure.setter().invoke((Object)proto, paramEntry.getValue());
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("Protocol badly constructed");
                    }
                }
                if (paramEntry.getValue() != null || paramConfigured == null) continue;
                try {
                    String value = (String)paramConfigured.getter().invoke((Object)proto, new Object[0]);
                    replyMsg.addParameter(protoEntry.getKey(), paramEntry.getKey(), value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Protocol badly constructed");
                }
            }
            if (wasNotReady || !proto.readyToStart()) continue;
            babel.setupSelfConfiguration(proto);
        }
        Map<Host, ParameterMessage> map = this.msgToSend;
        synchronized (map) {
            ParameterMessage oldMsg = this.msgToSend.get(from);
            if (oldMsg != null) {
                oldMsg.join(replyMsg);
            } else {
                this.msgToSend.put(from, replyMsg);
            }
            if (oldMsg != null && oldMsg.getAllProtocolParams().size() > 0 || replyMsg.getAllProtocolParams().size() > 0) {
                this.openConnection(from);
            }
        }
    }

    private void uponMessageFailed(ProtoMessage msg, Host host, short destProto, Throwable error, int channelId) {
        logger.warn("Failed message: {} to host: {} with error: {}", (Object)msg, (Object)host, (Object)error.getMessage());
    }

    private void uponInConnectionUp(InConnectionUp event, int channel) {
        logger.debug(event);
    }

    private void uponInConnectionDown(InConnectionDown event, int channel) {
        logger.info(event);
    }

    private void uponOutConnectionDown(OutConnectionDown event, int channel) {
        logger.warn(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uponOutConnectionUp(OutConnectionUp event, int channel) {
        logger.info("Connection to {} is now up", (Object)event.getNode());
        Map<Host, ParameterMessage> map = this.msgToSend;
        synchronized (map) {
            this.sendMessage(this.msgToSend.remove(event.getNode()), event.getNode());
            this.closeConnection(event.getNode(), this.defaultChannelID);
        }
    }

    private void uponOutConnectionFailed(OutConnectionFailed<ProtoMessage> event, int channel) {
        logger.debug(event);
        System.exit(1);
    }
}

