/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.metrics.Metric;

public class MetricsManager {
    private static final Logger logger = LogManager.getLogger(MetricsManager.class);
    private static MetricsManager system;
    private final Queue<Metric> toSchedule;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private boolean started = false;

    public static synchronized MetricsManager getInstance() {
        if (system == null) {
            system = new MetricsManager();
        }
        return system;
    }

    MetricsManager() {
        this.toSchedule = new LinkedList<Metric>();
    }

    public synchronized void start() {
        this.started = true;
        Iterator iterator = this.toSchedule.iterator();
        while (iterator.hasNext()) {
            this.scheduleMetric((Metric)iterator.next());
            iterator.remove();
        }
    }

    private void scheduleMetric(Metric m) {
        this.scheduler.scheduleAtFixedRate(() -> this.logMetric(m), m.getPeriod(), m.getPeriod(), TimeUnit.MILLISECONDS);
    }

    public synchronized void registerMetric(Metric m) {
        if (m.isLogPeriodically()) {
            if (this.started) {
                this.scheduleMetric(m);
            } else {
                this.toSchedule.add(m);
            }
        }
        if (m.isLogOnChange()) {
            m.setOnChangeHandler(this::logMetric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMetric(Metric m) {
        Metric metric = m;
        synchronized (metric) {
            logger.info("[" + Babel.getInstance().getMillisSinceStart() + "] " + m.getName() + " " + m.computeValue());
            if (m.isResetOnLog()) {
                m.reset();
            }
        }
    }
}

