/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.membership;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.InetAddress;
import java.util.UUID;
import pt.unl.fct.di.novasys.babel.protocols.membership.Peer;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class VersionedPeer
extends Peer
implements Cloneable {
    public static final int BYTES = 30;
    private long version;
    public static ISerializer<VersionedPeer> serializer = new ISerializer<VersionedPeer>(){

        @Override
        public void serialize(VersionedPeer p, ByteBuf out) throws IOException {
            Peer.serializer.serialize(p, out);
            out.writeLong(p.version);
        }

        @Override
        public VersionedPeer deserialize(ByteBuf in) throws IOException {
            Peer p = Peer.serializer.deserialize(in);
            return new VersionedPeer(p, in.readLong());
        }
    };

    public VersionedPeer(InetAddress address, int port) {
        super(address, port);
        this.version = 0L;
    }

    public VersionedPeer(InetAddress address, int port, UUID peerID) {
        super(address, port, peerID);
        this.version = 0L;
    }

    public VersionedPeer(InetAddress address, int port, UUID peerID, long version) {
        super(address, port, peerID);
        this.version = version;
    }

    private VersionedPeer(Host h) {
        super(h.getAddress(), h.getPort());
        this.version = 0L;
    }

    private VersionedPeer(Peer p, long v) {
        super(p.getAddress(), p.getPort(), p.getPeerID());
        this.version = v;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long v) {
        this.version = v;
    }

    public void incrementVersion() {
        ++this.version;
    }

    public void incrementVersion(long v) {
        this.version = v > this.version ? v + 1L : ++this.version;
    }

    @Override
    public String toString() {
        return super.toString() + " v: " + this.version;
    }

    public static VersionedPeer fromHost(Host h) {
        return new VersionedPeer(h);
    }

    @Override
    public VersionedPeer clone() {
        return new VersionedPeer(this.getAddress(), this.getPort(), this.getPeerID(), this.version);
    }
}

