/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkingUtilities {
    private static final Logger logger = LogManager.getLogger(NetworkingUtilities.class);

    public static String getAddress(String inter) throws SocketException {
        NetworkInterface byName = NetworkInterface.getByName(inter);
        if (byName == null) {
            logger.error("No interface named " + inter);
            return null;
        }
        Enumeration<InetAddress> addresses = byName.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress currentAddress = addresses.nextElement();
            if (!(currentAddress instanceof Inet4Address)) continue;
            return currentAddress.getHostAddress();
        }
        logger.error("No ipv4 found for interface " + inter);
        return null;
    }
}

