/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.api.core.data.AccessibleByName;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.SettableByIndex;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface SettableByName<SelfT extends SettableByName<SelfT>>
extends SettableByIndex<SelfT>,
AccessibleByName {
    @NonNull
    @CheckReturnValue
    default public SelfT setBytesUnsafe(@NonNull String name, @Nullable ByteBuffer v) {
        return (SelfT)((SettableByName)this.setBytesUnsafe(this.firstIndexOf(name), v));
    }

    @Override
    @NonNull
    default public DataType getType(@NonNull String name) {
        return this.getType(this.firstIndexOf(name));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setToNull(@NonNull String name) {
        return (SelfT)((SettableByName)this.setToNull(this.firstIndexOf(name)));
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(@NonNull String name, @Nullable ValueT v, @NonNull TypeCodec<ValueT> codec) {
        return (SelfT)((SettableByName)this.set(this.firstIndexOf(name), v, codec));
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(@NonNull String name, @Nullable ValueT v, @NonNull GenericType<ValueT> targetType) {
        return (SelfT)((SettableByName)this.set(this.firstIndexOf(name), v, targetType));
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(@NonNull String name, @Nullable ValueT v, @NonNull Class<ValueT> targetClass) {
        return (SelfT)((SettableByName)this.set(this.firstIndexOf(name), v, targetClass));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBoolean(@NonNull String name, boolean v) {
        return (SelfT)((SettableByName)this.setBoolean(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setByte(@NonNull String name, byte v) {
        return (SelfT)((SettableByName)this.setByte(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setDouble(@NonNull String name, double v) {
        return (SelfT)((SettableByName)this.setDouble(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setFloat(@NonNull String name, float v) {
        return (SelfT)((SettableByName)this.setFloat(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInt(@NonNull String name, int v) {
        return (SelfT)((SettableByName)this.setInt(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLong(@NonNull String name, long v) {
        return (SelfT)((SettableByName)this.setLong(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setShort(@NonNull String name, short v) {
        return (SelfT)((SettableByName)this.setShort(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInstant(@NonNull String name, @Nullable Instant v) {
        return (SelfT)((SettableByName)this.setInstant(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLocalDate(@NonNull String name, @Nullable LocalDate v) {
        return (SelfT)((SettableByName)this.setLocalDate(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLocalTime(@NonNull String name, @Nullable LocalTime v) {
        return (SelfT)((SettableByName)this.setLocalTime(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setByteBuffer(@NonNull String name, @Nullable ByteBuffer v) {
        return (SelfT)((SettableByName)this.setByteBuffer(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setString(@NonNull String name, @Nullable String v) {
        return (SelfT)((SettableByName)this.setString(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBigInteger(@NonNull String name, @Nullable BigInteger v) {
        return (SelfT)((SettableByName)this.setBigInteger(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBigDecimal(@NonNull String name, @Nullable BigDecimal v) {
        return (SelfT)((SettableByName)this.setBigDecimal(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setUuid(@NonNull String name, @Nullable UUID v) {
        return (SelfT)((SettableByName)this.setUuid(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInetAddress(@NonNull String name, @Nullable InetAddress v) {
        return (SelfT)((SettableByName)this.setInetAddress(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setCqlDuration(@NonNull String name, @Nullable CqlDuration v) {
        return (SelfT)((SettableByName)this.setCqlDuration(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setToken(@NonNull String name, @NonNull Token v) {
        return (SelfT)((SettableByName)this.setToken(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public <ElementT> SelfT setList(@NonNull String name, @Nullable List<ElementT> v, @NonNull Class<ElementT> elementsClass) {
        return (SelfT)((SettableByName)this.setList(this.firstIndexOf(name), v, elementsClass));
    }

    @NonNull
    @CheckReturnValue
    default public <ElementT> SelfT setSet(@NonNull String name, @Nullable Set<ElementT> v, @NonNull Class<ElementT> elementsClass) {
        return (SelfT)((SettableByName)this.setSet(this.firstIndexOf(name), v, elementsClass));
    }

    @NonNull
    @CheckReturnValue
    default public <KeyT, ValueT> SelfT setMap(@NonNull String name, @Nullable Map<KeyT, ValueT> v, @NonNull Class<KeyT> keyClass, @NonNull Class<ValueT> valueClass) {
        return (SelfT)((SettableByName)this.setMap(this.firstIndexOf(name), v, keyClass, valueClass));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setUdtValue(@NonNull String name, @Nullable UdtValue v) {
        return (SelfT)((SettableByName)this.setUdtValue(this.firstIndexOf(name), v));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setTupleValue(@NonNull String name, @Nullable TupleValue v) {
        return (SelfT)((SettableByName)this.setTupleValue(this.firstIndexOf(name), v));
    }
}

